<?php
  /**************************************************************************\
  * phpGroupWare - NNTP administration                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: preferences.php,v 1.31 2001/05/17 01:51:06 skeeter Exp $ */

	$phpgw_flags = Array(
		'currentapp'	=> 'nntp',
		'enable_nextmatchs_class'	=> True,
		'noheader'	=> True,
		'nonavbar'	=> True
	);
	$phpgw_info['flags'] = $phpgw_flags;

	include('../header.inc.php');

	function get_tg()
	{
		global $phpgw;

		$phpgw->db->query("SELECT count(con) FROM newsgroups WHERE active='Y'");
		$phpgw->db->next_record();
		return $phpgw->db->f(0);
	}

	if((!isset($submit) || !$submit) && (!isset($nntplist) || !$nntplist))
	{
		if (!isset($start) || !$start)
		{
			$start = 0;
		}

		if (!isset($query_result) || !$query_result)
		{
			$query_result = 0;
		}

		$orderby = '';
		if (isset($order) && $order)
		{
			switch ($order)
			{
			case 1:
				$orderby = ' ORDER BY CON '.$sort;
				break;
			case 2:
				$orderby = ' ORDER BY NAME '.$sort;
				break;
			case 3:
				$orderby = ' ORDER BY ACTIVE '.$sort;
				break;
			}
		}
   	 else
	    {
			$orderby = '';
		}

		if ((isset($search) && $search) || (isset($next) && $next))
		{
			if (isset($search) && $search)
			{
				$query_result = 0;
			}
			else
			{
				$query_result++;
			}
			$phpgw->db->query("SELECT name FROM newsgroups WHERE active='Y'$orderby");
			$j = 0;
			$i = 0;
			while($phpgw->db->next_record())
			{
				if (stristr($phpgw->db->f('name'),$query))
				{
					if($i==$query_result)
					{
						$start = $j;
						break;
					}
					else
					{
						$i++;
					}
				}
				$j++;
			}
		}

		$querystr = "SELECT con, name FROM newsgroups WHERE active='Y'$orderby ".$phpgw->db->limit($start);
		$phpgw->db->query($querystr);

		if(!$phpgw->db->num_rows())
		{
			header('Location: '.$phpgw->link('/nntp/admin.php'));
			$phpgw->common->phpgw_exit();
		}
		else
		{
			$phpgw->common->phpgw_header();
			echo parse_navbar();

			$phpgw->db->query($querystr);
			while($phpgw->db->next_record())
			{
				$nntpavailgroups['con'][] = $phpgw->db->f('con');
				$nntpavailgroups['name'][] = $phpgw->db->f('name');
			}
		}
		
		$p = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('nntp'));
		$templates = Array(
			'nntp_form'	=>	'nntp.tpl'
		);
		
		$p->set_file($templates);

		$p->set_block('nntp_form','nntp','nntp');
		$p->set_block('nntp_form','nntp_list','nntp_list');

		if (!isset($tg) || !$tg)
		{
			$tg = get_tg();
		}

		$first = ($nntpavailgroups['con'])?min($nntpavailgroups['con']):0;

		$common_hidden_vars = '<input type="hidden" name="start" value="'.$start.'">'."\n"
                        . '<input type="hidden" name="first" value="'.$first.'">'."\n"
                        . '<input type="hidden" name="tg" value="'.$tg.'">'."\n";
		if(isset($order) && $order)
		{
			$common_hidden_vars .= '<input type="hidden" name="order" value="'.$order.'">'."\n";
		}
		if(isset($sort) && $sort)
		{
			$common_hidden_vars .= '<input type="hidden" name="sort" value="'.$sort.'">'."\n";
		}
		if(isset($query_result) && $query_result)
		{
			$common_hidden_vars .= '<input type="hidden" name="query_result" value="'.$query_result.'">'."\n";
		}

		$extra_parms = '&tg='.$tg;
		if(isset($sort) && $sort)
		{
			$extra_parms .= '&sort='.$sort;
		}
		if(isset($order) && $order)
    	{
			$extra_parms .= '&order='.$order;
		}
		
		$urlname = '/nntp/preferences.php';

		$var = Array(
			'search_value'	=>	(isset($query) && $query?$query:''),
			'search'		=> lang('search'),
			'next'		=> lang('next'),
			'nml'		=> $phpgw->nextmatchs->left($urlname,$start,$tg,$extra_parms),
			'nmr'		=> $phpgw->nextmatchs->right($urlname,$start,$tg,$extra_parms),
			'title'	=> lang('Newsgroups'),
			'action_url'	=>$phpgw->link('/nntp/preferences.php'),
			'common_hidden_vars'	=> $common_hidden_vars,
			'th_bg'		=> $phpgw_info['theme']['th_bg'],
			'th_font'	=> $phpgw_info['theme']['font'],
			'sort_con'	=> $phpgw->nextmatchs->show_sort_order($sort,'1',$order,$urlname,' # ','&tg='.$tg),
			'sort_group'	=> $phpgw->nextmatchs->show_sort_order($sort,'2',$order,$urlname,'Name','&tg='.$tg),
			'sort_active'	=> $phpgw->nextmatchs->show_sort_order($sort,'3',$order,$urlname,' Active ','&tg='.$tg)
		);

		$p->set_var($var);

		if(count($phpgw_info['user']['preferences']['nntp']))
		{
			while($pref = each($phpgw_info['user']['preferences']['nntp']))
			{
				$found[$pref[0]] = ' checked';
			}
		}

		for($i=0;$i<count($nntpavailgroups['con']);$i++)
		{
			$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);

			$con = $nntpavailgroups['con'][$i];

			if (!$nntpavailgroups['name'][$i])
			{
				$nntpavailgroups['name'][$i]  = '&nbsp;';
			}
			$active_var = '<input type="checkbox" name="nntplist[]" value="'.$con.'"'.$found[$con].'>';

			$var = Array(
				'tr_color'	=> $tr_color,
				'con'		=> $con,
				'group'	=> $nntpavailgroups['name'][$i],
				'active'	=> $active_var
			);

			$p->set_var($var);

			$p->parse('rows','nntp_list',True);
		}

		$var = Array(
			'lang_update'	=> lang('update'),
			'checkmark'	=> $phpgw->common->get_image_path('email').'/check.gif'
		);

		$p->set_var($var);

		$p->pparse('out','nntp');
		$phpgw->common->phpgw_footer();
	}
	else
	{
		$phpgw->preferences->read_repository();
		for($i=$start;$i<=$last;$i++)
		{
			if($phpgw_info['user']['preferences']['nntp'][$i])
			{
				$preference = each($phpgw_info['user']['preferences']['nntp']);
				$phpgw->preferences->delete('nntp',$preference[0]);
			}
		}

		for ($i=0;$i<count($nntplist);$i++)
		{
			$phpgw->preferences->add('nntp',$nntplist[$i],True);
		}
		$phpgw->preferences->save_repository(True);

		Header('Location: ' . $phpgw->link('/nntp/preferences.php','start='.$start.'&tg='.$tg));
		$phpgw->common->phpgw_exit();
  }
?>
