<?php
	/***************************************************************************\
	* phpGroupWare - Notes														*
	* http://www.phpgroupware.org												*
	* Written by: Andy Holman (LoCdOg)											*
	*			  Bettina Gille [ceb@phpgroupware.org]							*
	* ------------------------------------------------							*
	* This program is free software; you can redistribute it and/or modify it	*
	* under the terms of the GNU General Public License as published by the		*
	* Free Software Foundation; either version 2 of the License, or (at your	*
	* option) any later version.												*
	\***************************************************************************/
	/* $Id: index.php,v 1.37.2.5 2001/06/29 11:32:08 skeeter Exp $ */

	$phpgw_info['flags'] = array('currentapp' => 'notes',
					'enable_nextmatchs_class' => True,
					'enable_categories_class' => True);

	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array( 'notes_list_t' => 'list.tpl',
						'notes_list' => 'list.tpl'));
	$t->set_block('notes_list_t','notes_list','list');

	$notes = CreateObject('notes.notes');
	$grants = $phpgw->acl->get_grants('notes');
	if(gettype($grants) <> 'array')
	{
		settype($grants,'array');
	}
	$grants[intval($phpgw_info['user']['account_id'])] = PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;

	$hidden_vars = '<input type="hidden" name="search" value="' . $search . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="cat_id" value="' . $cat_id . '">' . "\n";

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font']))
	{
		$font = $phpgw_info['user']['preferences']['notes']['notes_font'];
	}
	else
	{
		$font = set_font();
	}

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font_size']))
	{
		$font_size = $phpgw_info['user']['preferences']['notes']['notes_font_size'];
	}
	else
	{
		$font_size = set_font_size();
	}

	if (! $start) { $start = 0; }

	if($phpgw_info['user']['preferences']['common']['maxmatchs'] && $phpgw_info['user']['preferences']['common']['maxmatchs'] > 0)
	{
		$limit = $phpgw_info['user']['preferences']['common']['maxmatchs'];
	}
	else
	{
		$limit = 15;
	}

	$notes_list = $notes->read_notes($start,$limit,$search,$filter,$cat_id);

// --------------------------------- nextmatch ---------------------------

	$left = $phpgw->nextmatchs->left('/notes/index.php',$start,$notes->total_records);
	$right = $phpgw->nextmatchs->right('/notes/index.php',$start,$notes->total_records);
	$t->set_var('left',$left);
	$t->set_var('right',$right);

	if ($notes->total_records > $limit)
	{
		if ($start + $limit > $notes->total_records)
		{
			$end = $notes->total_records;
		}
		else
		{
			$end = $start + $limit;
		}
		$t->set_var('search_message',lang('showing x - x of x',($start + 1),$end,$notes->total_records));
	}
	else
	{
		$t->set_var('search_message',lang('showing x',$notes->total_records));
	}

// -------------------------- end nextmatch ------------------------------------

	$t->set_var('actionurl',$phpgw->link('/notes/index.php'));
	$t->set_var('addurl',$phpgw->link('/notes/add.php',"cat_id=$cat_id&start=$start$search=$search"));
	$t->set_var('lang_search',lang('Search'));
	$t->set_var('lang_add',lang('Add note'));
	$t->set_var('title_notes',lang('Personalized notes for'));
	$t->set_var('name',$phpgw_info['user']['fullname']);
	$t->set_var('cat_action',$phpgw->link('/notes/index.php'));
	$t->set_var('hidden_vars',$hidden_vars);
	$t->set_var('font',$font);
	$t->set_var('font_size',$font_size);
	$t->set_var('lang_all',lang('All'));
	$t->set_var('lang_category',lang('Category'));
	$t->set_var('category_list',$phpgw->categories->formated_list('select','all',$cat_id,True));
	$t->set_var('lang_submit',lang('Submit'));

	for ($i=0;$i<count($notes_list);$i++)
	{
		$note_owner = intval($notes_list[$i]['owner']);
		$new_date = $notes_list[$i]['date'];
		$month = $phpgw->common->show_date(time(),'n');
		$day = $phpgw->common->show_date(time(),'d');
		$year = $phpgw->common->show_date(time(),'Y');
		$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
		$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

		$words = split(' ',$phpgw->strip_html($notes_list[$i]['content']));
		$first = "$words[0] $words[1] $words[2] $words[3] .....";
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
		$t->set_var('tr_color',$tr_color);

		$t->set_var(array('new_date' => $new_dateout,
							'first' => $first));

		$t->set_var('view',$phpgw->link('/notes/view.php','id=' . $notes_list[$i]['id']) . "&cat_id=$cat_id&start=$start&search=$search");

		if ($notes->check_perms($grants[$note_owner],PHPGW_ACL_EDIT))
		{
			$t->set_var('edit',$phpgw->link('/notes/edit.php','id=' . $notes_list[$i]['id']) . "&cat_id=$cat_id&start=$start&search=$search");
			$t->set_var('lang_edit',lang('Edit'));
		}
		else
		{
			$t->set_var('edit','');
			$t->set_var('lang_edit','');
		}

		if ($notes->check_perms($grants[$note_owner],PHPGW_ACL_DELETE))
		{
			$t->set_var('delete',$phpgw->link('/notes/delete.php','id=' . $notes_list[$i]['id']) . "&cat_id=$cat_id&start=$start&search=$search");
			$t->set_var('lang_delete',lang('Delete'));
		}
		else
		{
			$t->set_var('delete','');
			$t->set_var('lang_delete','');
		}

		$t->set_var('lang_view',lang('View'));

		$t->parse('list','notes_list',True);
	}

	$t->parse('out','notes_list_t',True);
	$t->p('out');

	$phpgw->common->phpgw_footer();
?>
