<?php
	/**************************************************************************\
	* phpGroupWare - todo list                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: add.php,v 1.49.2.1 2001/06/23 03:26:13 jengo Exp $ */

	if ($submit)
	{
		$phpgw_info['flags'] = array(
			'noheader'                => True,
			'nonavbar'                => True
		);
	}

	$phpgw_info['flags']['currentapp']              = 'todo';
	$phpgw_info['flags']['enable_categories_class'] = True;
	include('../header.inc.php');

	$phpgw->todo = createobject('todo.todo');
	$_query = urlencode(stripslashes($query));

	if ($todo_cat) { $cat_id = $todo_cat; }

	if ($submit)
	{
		if (strlen($des) >= 8000)
		{
			$error[] = lang('Description can not exceed 8000 characters in length');
		}

		if ($daysfromstart && ! ereg('^[0-9]+$',$daysfromstart))
		{
			$error[] = lang('You can only enter numbers for days from now');
		}

		if (! $des)
		{
			$error[] = lang('You must enter a description');
		}

		// check wether to write dates or not
		if ($seltoday)
		{
			// startdate is today (checkbox is clicked)
			$startdate = time();
		}
		else
		{
			if ($smonth || $sday || $syear)
			{
				if (! checkdate($smonth,$sday,$syear))
				{
					$error[] = lang('You have entered an starting invalid date');
				}
				else
				{
					$startdate = mktime(0,0,0,$smonth, $sday, $syear);
				}
			}
		}

		if (! $startdate)
		{
			$startdate = time();
		}

		// Check ending date
		if ($emonth || $eday || $eyear)
		{
			if (! checkdate($emonth,$eday,$eyear))
			{
				$error[] = lang('You have entered an ending invalid date');
			}
			else
			{
				$enddate = mktime(2,0,0,$emonth,$eday,$eyear);
			}
		}
		else if ($daysfromstart > 0)
		{
			$enddate = mktime(0,0,0,date('m',$startdate), date('d',$startdate)+$daysfromstart, date('Y',$startdate));
		}

		if (! $enddate)
		{
			$enddate = 0;
		}

		if ($enddate < $startdate && $enddate && $startdate)
		{
			$error[] = lang('Ending date can not be before start date');
		}

		if ($action == 'sp')
		{
			$todo_id_parent = $todo_id;
		}
		else
		{
			$todo_id_parent = 0;
		}

		if ($access)
		{
			$access = 'private';
		}
		else
		{
			$access = 'public';
		}

		if (! is_array($error))
		{
			$phpgw->todo->add(array(
				'todo_id_parent' => $todo_id_parent,
				'owner'          => $phpgw_info['user']['account_id'],
				'access'         => $access,
				'cat'            => $cat_id,
				'des'            => $des,
				'pri'            => $pri,
				'status'         => $status,
				'startdate'      => $startdate,
				'enddate'        => $enddate
			));
	

			Header('Location: ' . $phpgw->link('/todo/index.php',"cd=14&sort=$sort&order=$order&query=$_query&start="
				. "$start&filter=$filter&cat_id=$cat_id"));
		}

	}

	$phpgw->template->set_file(array(
		'todo_add' => 'form.tpl'
	));

	// ====================================================================
	// create two seperate blocks, editblock will be cut off from template
	// addblock contains the buttons needed
	// ====================================================================
	$phpgw->template->set_block('todo_add','add','addhandle');
	$phpgw->template->set_block('todo_add','edit','edithandle');

	if (is_array($error))
	{
		$phpgw->common->phpgw_header();
		echo parse_navbar();
		$phpgw->template->set_var('error_list',$phpgw->common->error_list($error));
	}

	if ($action == 'sp')
	{
		$phpgw->db->query("select * from phpgw_todo where todo_id='$todo_id'");
		$phpgw->db->next_record();

		$phpgw->template->set_var("lang_todo_action",lang("todo list - add Sub-Project"));
		$phpgw->template->set_var("lang_project",lang("Parent Project"));
		$phpgw->template->set_var("lang_projdesc",$phpgw->db->f("todo_des"));
		$phpgw->template->set_var("lang_prdesc",lang("Subproject Description"));
	}
	else
	{
		$phpgw->template->set_var("lang_todo_action",lang("todo list - add"));
		$phpgw->template->set_block("todo_add", "subpro", "subprohandle");
		$phpgw->template->set_var("lang_prdesc",lang("Project Description"));
	}

	$phpgw->template->set_var("actionurl",$phpgw->link("/todo/add.php"));

	$common_hidden_vars = "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n"
		. "<input type=\"hidden\" name=\"todo_id\" value=\"$todo_id\">\n"
		. "<input type=\"hidden\" name=\"action\" value=\"$action\">";

	$phpgw->template->set_var('lang_category',lang('Category'));
	$phpgw->template->set_var('lang_none',lang('None'));
	$phpgw->template->set_var('cat_list',$phpgw->categories->formated_list('select','all',$cat_id,'True'));

	$phpgw->template->set_var('common_hidden_vars',$common_hidden_vars);
	$phpgw->template->set_var('descval',$des);
	$phpgw->template->set_var('lang_urgency',lang('Urgency'));

	// get an instance of select box class
	$sm = CreateObject('phpgwapi.sbox');

	$phpgw->template->set_var("pri_list",$sm->getPriority("pri"));
	$phpgw->template->set_var("lang_completed",lang("completed"));
	$phpgw->template->set_var("lang_start_date",lang("Start Date"));
	$phpgw->template->set_var("lang_end_date",lang("End Date"));
	$phpgw->template->set_var("stat_list", $sm->getPercentage("status", 0));

	$phpgw->template->set_var("start_select_date",$phpgw->common->dateformatorder($sm->getYears("syear", $syear),$sm->getMonthText("smonth", $smonth),$sm->getDays("sday", $sday)));
	$phpgw->template->set_var("end_select_date",$phpgw->common->dateformatorder($sm->getYears("eyear", $eyear),$sm->getMonthText("emonth", $emonth),$sm->getDays("eday", $eday)));

	$phpgw->template->set_var("sel_for_today",lang("or: select for today:"));

	$phpgw->template->set_var("lang_selfortoday",lang("or: select for today:"));
	$phpgw->template->set_var("selfortoday","<input type=\"checkbox\" name=\"seltoday\" value=\"y\">");
	$phpgw->template->set_var("lang_daysfromstartdate",lang("or: days from startdate:"));
	$phpgw->template->set_var("daysfromstartdate",'<input type="text" name="daysfromstart" size="3" maxlength="3">');

	$phpgw->template->set_var("lang_completed",lang("completed"));
	$phpgw->template->set_var("lang_date_due",lang("date due"));

	$phpgw->template->set_var('lang_access_type',lang('Private'));
	$phpgw->template->set_var('access_list', '<input type="checkbox" name="access" value="True" checked>');

	$phpgw->template->set_var("lang_addsubmitb",lang("Add"));
	$phpgw->template->set_var("lang_addresetb",lang("Clear Form"));

	$phpgw->template->set_var("edithandle","");
	$phpgw->template->set_var("addhandle","");
	$phpgw->template->set_var("subprohandle","");

	// $phpgw->template->parse("out","subpro");
	$phpgw->template->pfp("out","todo_add");
	$phpgw->template->pfp("addhandle","add");

	$phpgw->common->phpgw_footer();
?>
