<?php
	/**************************************************************************\
	* phpGroupWare - todo list                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: edit.php,v 1.46.2.3 2001/06/26 23:19:00 skeeter Exp $ */

	$phpgw_info['flags'] = array(
		'currentapp'              => 'todo',
		'noheader'                => True,
		'nofooter'                => True,
		'nonavbar'                => True,
		'enable_categories_class' => True
	);
	include('../header.inc.php');

	$_query = urlencode(stripslashes($query));
	if (! isset($todo_id) || !$todo_id)
	{
			Header('Location: ' . $phpgw->link('/todo/index.php',sprintf('sort=%s&order=%s&query=%s&start=%s'
				. '&filter=%s&cat_id=%s',$sort,$order,$_query,$start,$filter,$cat_id)));
	}

	$common_hidden_vars =
	  '<input type="hidden" name="sort" value="' . $sort . '">'
	. '<input type="hidden" name="order" value="' . $order. '">'
	. '<input type="hidden" name="query" value="' . $query . '">'
	. '<input type="hidden" name="start" value="' . $start . '">'
	. '<input type="hidden" name="filter" value="' . $filter . '">'
	. '<input type="hidden" name="todo_id" value="' . $todo_id. '">';

	$phpgw->todo = createobject('todo.todo');

	if ($submit)
	{
		if (strlen($des) >= 8000)
		{
			$error[] = lang('Description can not exceed 8000 characters in length');
		}

		if (! $des)
		{
			$error[] = lang('You must enter a description');
		}

		// check wether to write dates or not
		if ($seltoday)
		{
			// startdate is today (checkbox is clicked)
			$startdate = time();
		}
		else
		{
			if ($smonth || $sday || $syear)
			{
				if (! checkdate($smonth,$sday,$syear))
				{
					$error[] = lang('You have entered an starting invalid date');
				}
				else
				{
					$startdate = mktime(0,0,0,$smonth, $sday, $syear);
				}
			}
		}

		if (! $startdate)
		{
			$startdate = time();
		}

		// Check ending date
		if ($emonth || $eday || $eyear)
		{
			if (! checkdate($emonth,$eday,$eyear))
			{
				$error[] = lang('You have entered an ending invalid date');
			}
			else
			{
				$enddate = mktime(2,0,0,$emonth,$eday,$eyear);
			}
		}
		else if ($daysfromstart > 0)
		{
			$enddate = mktime(0,0,0,date('m',$startdate), date('d',$startdate)+$daysfromstart, date('Y',$startdate));
		}

		if (! $enddate)
		{
			$enddate = 0;
		}

		if ($enddate < $startdate && $enddate && $startdate)
		{
			$error[] = lang('Ending date can not be before start date');
		}



		if ($access)
		{
			$access = 'private';
		}
		else
		{
			$access = 'public';
		}


		if (! is_array($error))
		{
			$phpgw->todo->edit(array(
				'des'       => $des,
				'pri'       => $pri,
				'status'    => $status,
				'access'    => $access,
				'cat'       => $todo_cat,
				'startdate' => $startdate,
				'enddate'   => $enddate,
				'todo_id'   => $todo_id
			));
	
			$cat_id = $todo_cat;

			Header('Location: ' . $phpgw->link('/todo/index.php', "cd=15&sort=$sort&order=$order&query=$_query&start="
				. "$start&filter=$filter&cat_id=$cat_id"));
		}
	}


	$phpgw->db->query("select todo_owner from phpgw_todo where todo_id='$todo_id'");
	$phpgw->db->next_record();

	// Make sure this user has access to this item
	if (! $phpgw->todo->check_perms($phpgw->todo->grants[$phpgw->db->f('todo_owner')],PHPGW_ACL_EDIT) && $phpgw->db->f('todo_owner') != $phpgw_info['user']['account_id'])
	{
		Header('Location: ' . $phpgw->link('/todo/index.php',sprintf('sort=%s&order=%s&query=%s&start=%s'
			. '&filter=%s',$sort,$order,$_query,$start,$filter)));
		$phpgw->common->phpgw_exit();
	}

	$phpgw->common->phpgw_header();
	echo parse_navbar();

	$phpgw->db->query("select * from phpgw_todo where todo_id='$todo_id'");
	$phpgw->db->next_record();

	$pri_selected[$phpgw->db->f('todo_pri')] = ' selected';
	$status_selected[$phpgw->db->f('todo_status')] = ' selected';

	$phpgw->template->set_file(array('todo_edit' => 'form.tpl'));

	// ====================================================================
	// create two seperate blocks, addblock will be cut off from template
	// editblock contains the buttons and forms for edit
	// ====================================================================
	$phpgw->template->set_block('todo_edit', 'add', 'addhandle');
	$phpgw->template->set_block('todo_edit', 'edit', 'edithandle');
	$phpgw->template->set_block('todo_edit', 'subpro', 'subprohandle');

	if (is_array($error))
	{
		$phpgw->template->set_var('error_list',$phpgw->common->error_list($error));
	}

	$phpgw->template->set_var('lang_category',lang('Category'));
	$phpgw->template->set_var('lang_none',lang('None'));
	$phpgw->template->set_var('cat_list',$phpgw->categories->formated_list('select','all',$phpgw->db->f('todo_cat'),'True'));

	$phpgw->template->set_var('actionurl',$phpgw->link('/todo/edit.php'));
	$phpgw->template->set_var('lang_todo_action',lang('todo list - edit'));
	$phpgw->template->set_var('common_hidden_vars',$common_hidden_vars);
	$phpgw->template->set_var('lang_prdesc', lang('Project Description'));
	$phpgw->template->set_var('descval', $phpgw->strip_html($phpgw->db->f('todo_des')));

	// get month/day/year fields for startdate and enddate
	if ($phpgw->db->f('todo_startdate') == 0)
	{
		$sday = 0;
		$smonth = 0;
		$syear = 0;
	}
	else
	{
		$sday = date('d',$phpgw->db->f('todo_startdate'));
		$smonth = date('m',$phpgw->db->f('todo_startdate'));
		$syear = date('Y',$phpgw->db->f('todo_startdate'));
	}

	if ($phpgw->db->f('todo_enddate') == 0)
	{
		$eday = 0;
		$emonth = 0;
		$eyear = 0;
	}
	else
	{
		$eday = date('d',$phpgw->db->f('todo_enddate'));
		$emonth = date('m',$phpgw->db->f('todo_enddate'));
		$eyear = date('Y',$phpgw->db->f('todo_enddate'));
	}

	// get an instance of select box class
	$sm = CreateObject('phpgwapi.sbox');

	$phpgw->template->set_var('lang_start_date',lang('Start Date'));
	$phpgw->template->set_var('start_select_date',$phpgw->common->dateformatorder($sm->getYears('syear', $syear),$sm->getMonthText('smonth', $smonth),$sm->getDays('sday', $sday)));

	$phpgw->template->set_var('lang_end_date',lang('End Date'));
	$phpgw->template->set_var('end_select_date',$phpgw->common->dateformatorder($sm->getYears('eyear', $eyear),$sm->getMonthText('emonth', $emonth),$sm->getDays('eday', $eday)));

	$phpgw->template->set_var('lang_selfortoday','&nbsp;');
	$phpgw->template->set_var('selfortoday','&nbsp;');
	$phpgw->template->set_var('lang_daysfromstartdate','&nbsp;');
	$phpgw->template->set_var('daysfromstartdate','&nbsp;');

	$phpgw->template->set_var('lang_completed',lang('completed'));
	$phpgw->template->set_var('stat_list',$sm->getPercentage('status',$phpgw->db->f('todo_status')));

	$phpgw->template->set_var('lang_urgency',lang('urgency'));
	$phpgw->template->set_var('pri_list',$sm->getPriority('pri', $phpgw->db->f('todo_pri')));

	$phpgw->template->set_var('lang_access_type',lang('Private'));
	$phpgw->template->set_var('access_list', '<input type="checkbox" name="access" value="True"' . ($phpgw->db->f('todo_access') == 'private'?' checked':'') . '>');

	$phpgw->template->set_var('delete_action',$phpgw->link('/todo/delete.php'));

	if ($phpgw->todo->check_perms($phpgw->todo->grants[$phpgw->db->f('todo_owner')],PHPGW_ACL_DELETE) || $phpgw->db->f('todo_owner') == $phpgw_info['user']['account_id'])
	{
		$phpgw->template->set_var('delete_button','<input type="submit" name="delete" value="' . lang('Delete') . '">');
	}

	if ($phpgw->todo->check_perms($phpgw->todo->grants[$phpgw->db->f('todo_owner')],PHPGW_ACL_EDIT) || $phpgw->db->f('todo_owner') == $phpgw_info['user']['account_id'])
	{
		$phpgw->template->set_var('edit_button','<input type="submit" name="submit" value="' . lang('Edit') . '">');
	}

	$phpgw->template->set_var('edithandle','');
	$phpgw->template->set_var('addhandle','');
	$phpgw->template->set_var('subprohandle','');
	$phpgw->template->pfp('out','todo_edit');
	$phpgw->template->pfp('edithandle','edit');

	// I would like to have it calculate the amount of days and drop it in days from now.

	$phpgw->common->phpgw_footer();
	echo parse_navbar_end();
