<?php
  /**************************************************************************\
  * phpGroupWare - Weather Center Metar Station Functions                    *
  * http://www.phpgroupware.org                                              *
  * This file written by Sam Wynn <neotexan@wynnsite.com>                    *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: metar_stations.inc.php,v 1.9 2001/03/28 16:07:28 neotexan Exp $ */

function station_table($order, $sort, $filter, $start, $query, $qfield, &$table_c)
{
    global $phpgw, $phpgw_info;
    
    $edit_label   = lang("Edit");
    $delete_label = lang("Delete");

    $searchobj = array(array("metar_station",  "Station"),
                       array("metar_forecast", "Forecast Zone"),
                       array("metar_city",     "City"),
                       array("region_name",    "Region"));
    
    if ($order)
    {
        $ordermethod = "order by $order $sort ";
    }
    else
    {
        $ordermethod = "order by metar_city asc ";
    }
    
    if (! $sort)
    {
        $sort = "desc";
    }
    
    if (! $start)
    {
        $start = 0;
    }
    
    if (! $filter)
    {
        $filter = "none";
    }
    
    $limit = $phpgw->db->limit($start);
    
    if (!$qfield)
    {
        $qfield = "metar_city";
    }
    
    
    if (!$query)
    {
        $phpgw->db->query("select count(*) from phpgw_weather_metar "
                          ."left join phpgw_weather_region on "
                          ."phpgw_weather_metar.region_id="
                          ."phpgw_weather_region.region_id "
                          .$ordermethod);
    }
    else
    {
        $phpgw->db->query("select count(*) from phpgw_weather_metar "
                          ."left join phpgw_weather_region on "
                          ."phpgw_weather_metar.region_id="
                          ."phpgw_weather_region.region_id "
                          ."WHERE $qfield like '%$query%' "
                          .$ordermethod);
    }
    
    $phpgw->db->next_record();
    if ($phpgw->db->f(0) >
        $phpgw_info["user"]["preferences"]["common"]["maxmatchs"])
    {
        $match_comment = 
            lang("showing x - x of x",($start + 1),
                 ($start +
                  $phpgw_info["user"]["preferences"]["common"]["maxmatchs"]),
                 $phpgw->db->f(0));
    }
    else
    {
        $match_comment = lang("showing x",$phpgw->db->f(0));
    }
    
    $match_bar =
        $phpgw->nextmatchs->show_tpl("/weather/admin_stations.php",
                                     $start,$phpgw->db->f(0), "",
                                     "85%", $phpgw_info["theme"]["th_bg"],
                                     $searchobj,0);
    
    $station_link_label =
        $phpgw->nextmatchs->show_sort_order($sort,"metar_station",$order,
                                            "/weather/admin_stations.php",
                                            lang("Station"));
    $fzone_link_label   =
        $phpgw->nextmatchs->show_sort_order($sort,"metar_forecast",$order,
                                            "/weather/admin_stations.php",
                                            lang("FZone"));
    $city_link_label    =
        $phpgw->nextmatchs->show_sort_order($sort,"metar_city",$order,
                                            "/weather/admin_stations.php",
                                            lang("City"));
    $region_link_label  =
        $phpgw->nextmatchs->show_sort_order($sort,"region_name",$order,
                                            "/weather/admin_stations.php",
                                            lang("Region"));

    if (! $query)
    {
        $phpgw->db->query("select * from phpgw_weather_metar "
                          ."left join phpgw_weather_region on "
                          ."phpgw_weather_metar.region_id="
                          ."phpgw_weather_region.region_id " 
                          .$ordermethod 
                          .$limit);
    }
    else
    {
        $phpgw->db->query("select * from phpgw_weather_metar "
                          ."left join phpgw_weather_region on "
                          ."phpgw_weather_metar.region_id="
                          ."phpgw_weather_region.region_id "
                          ."WHERE $qfield like '%$query%' "
                          .$ordermethod
                          .$limit);
    }
    
    $table_tpl =
        CreateObject('phpgwapi.Template',
                     $phpgw->common->get_tpl_dir('weather'));
    $table_tpl->set_unknowns("remove");
    $table_tpl->set_file(array(table => "table.stations.tpl",
                               row   => "row.stations.tpl"));
    
    while ($phpgw->db->next_record()) 
    {
        $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
        
        $station = $phpgw->db->f("metar_station");
        if (! $station)
        {
            $station = "&nbsp;";
        }
        
        $forecast = $phpgw->db->f("metar_forecast");
        if (! $forecast)
        {
            $forecast = "&nbsp;";
        }
        
        $city = $phpgw->db->f("metar_city");
        if (! $city)
        {
            $city = "&nbsp;";
        }
        
        $region = $phpgw->db->f("region_name");
        if (! $region)
        {
            $region = "&nbsp;";
        }
        
        $metar_encoded = urlencode($phpgw->db->f("metar_id"));
        
        $table_tpl->
            set_var(
                array(row_color    => $tr_color,
                      station      => $station,
                      forecast     => $forecast,
                      city         => $city,
                      region       => $region,
                      edit_url     => $phpgw->link("/weather/admin_stations.php",
                                                   "con=".$metar_encoded
                                                   ."&act=edit"
                                                   ."&start=$start"
                                                   ."&order=$order"
                                                   ."&filter=$filter"
                                                   ."&sort=$sort"
                                                   ."&query="
                                                   .urlencode($query)
                                                   ."&qfield=$qfield"),
                      edit_label   => $edit_label,
                      delete_url   => $phpgw->link("/weather/admin_stations.php",
                                                   "con=".$metar_encoded
                                                   ."&act=delete"
                                                   ."&start=$start"
                                                   ."&order=$order"
                                                   ."&filter=$filter"
                                                   ."&sort=$sort"
                                                   ."&query="
                                                   .urlencode($query)
                                                   ."&qfield=$qfield"),
                      delete_label => $delete_label));
        $table_tpl->parse(station_rows, "row", True);
    }
    
    $table_tpl->
        set_var(array
                (th_bg                => $phpgw_info["theme"]["th_bg"],
                 
                 total_matchs         => $match_comment,
                 next_matchs          => $match_bar,
                 
                 station_link_label   => $station_link_label,
                 fzone_link_label     => $fzone_link_label,
                 city_link_label      => $city_link_label,
                 region_link_label    => $region_link_label,

                 edit_label           => $edit_label,
                 delete_label         => $delete_label,
                 
                 action_url           => $action_url,
                 action_label         => lang($act),
                 reset_label          => lang("Reset")));
    
    $table_tpl->parse(table_part, "table");
    $table_c = $table_tpl->get("table_part");
}


function station_entry($con, $act,$order, $sort, $filter, $start, $query, $qfield, &$form_c)
{
    global $phpgw, $phpgw_info;

    $action_url   =  $phpgw->link("/weather/admin_stations.php",
                                  "act=$act"
                                  ."&start=$start&order=$order&filter=$filter"
                                  ."&sort=$sort"
                                  ."&query=".urlencode($query)
                                  ."&qfield=$qfield");
    
    switch($act)
    {
      case "add":
        $bg_color = $phpgw_info["theme"]["th_bg"];
        break;
      case "delete":
        $bg_color = $phpgw_info["theme"]["bg07"];
        break;
      default:
        $bg_color = $phpgw_info["theme"]["table_bg"];
        break;
    }

    $station   = "";
    $city      = "";
    $region_id = "";
    $forecast  = "";
    
    if ($con != "")
    {
        $phpgw->db->query("select * from phpgw_weather_metar where metar_id=$con");
        $phpgw->db->next_record();
    
        $station   = $phpgw->db->f("metar_station");
        $city      = $phpgw->db->f("metar_city");
        $region_id = $phpgw->db->f("region_id");
        $forecast  = $phpgw->db->f("metar_forecast");
    }
        
    $modify_tpl =
        CreateObject('phpgwapi.Template',
                     $phpgw->common->get_tpl_dir('weather'));
    $modify_tpl->set_unknowns("remove");
    $modify_tpl->set_file(array(form   => "form.stations.tpl",
                                option => "option.common.tpl"));
    
    
    $phpgw->db->query("select * from phpgw_weather_region");
    while ($phpgw->db->next_record())
    {
        $cur_region_id =  $phpgw->db->f("region_id");

        $selected = "";
        if ($region_id == $cur_region_id)
        {
            $selected = "selected";
        }

        $modify_tpl->set_var(array(OPTION_SELECTED => $selected,
                                   OPTION_VALUE    => $cur_region_id,
                                   OPTION_NAME     => $phpgw->db->f("region_name")));
        $modify_tpl->parse(region_options, "option", True);
    }

    $modify_tpl->
        set_var(array
                (bg_color         => $bg_color,
                 
                 metar_id         => $con,
                 station_label    => lang("Station"),
                 metar_station    => $station,
                 city_label       => lang("City"),
                 metar_city       => $city,
                 forecast_label   => lang("Forecast Zone"),
                 metar_forecast   => $forecast,
                 region_label     => lang("Region"),

                 action_url       => $action_url,
                 action_label     => lang($act),
                 reset_label      => lang("Reset")));
    
    $modify_tpl->parse(form_part, "form");
    $form_c = $modify_tpl->get("form_part");
}
?>
