/*
 * tkKinput2.h --
 *
 *	Declarations for the kinput2.
 *
 * Copyright 1988,1993 Software Research Associates, Inc.
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * $Header: /ext/cvsroot/tk/unix/tkKinput2.h,v 1.1 1995/12/21 08:32:41 hoshi Exp $
 */

#ifndef _TKKINPUT2
#define _TKKINPUT2

/* ѴФΥץե뤬ץѥƥ̾ */
#define CONVERSION_PROFILE	"_CONVERSION_PROFILE"

/* ѴФΥץեΥץѥƥѴ°ΥץѥƥΥ */
#define CONVERSION_ATTRIBUTE_TYPE	"_CONVERSION_ATTRIBUTE_TYPE"

/* ץȥС̾ */
#define PROTOCOL_VERSION	"PROTOCOL-2.0"

#define CONV_ATTR(code,len)	((unsigned long)((code)<<16)+(len))

#define UPPER16U(data)		(((data)>>16)&0xffff)
#define UPPER16S(data)		((short)(((data)>>16)&0xffff))
#define LOWER16U(data)		((data)&0xffff)
#define LOWER16S(data)		((short)((data)&0xffff))

#define CODE_OF_ATTR(head)	UPPER16U(head)
#define LENGTH_OF_ATTR(head)	LOWER16U(head)

/*
 * Conversion Profile Codes
 */

#define CONVPROF_PROTOCOL_VERSION	1
#define CONVPROF_SUPPORTED_STYLES	2
#define CONVPROF_SUPPORTED_EXTENSIONS	3
#define CONVPROF_EXTENSION_DATA		4

/*
 * Standard Conversion Attribute Codes (0-255)
 */

/* 0-127: can be specified at any time (startup and during conversion) */
#define CONVATTR_NONE			0
#define CONVATTR_INDIRECT		1
#define CONVATTR_FOCUS_WINDOW		2
#define CONVATTR_SPOT_LOCATION		3
#define CONVATTR_CLIENT_AREA		4
#define CONVATTR_STATUS_AREA		5
#define CONVATTR_COLORMAP		6
#define CONVATTR_COLOR			7
#define CONVATTR_BACKGROUND_PIXMAP	8
#define CONVATTR_LINE_SPACING		9
#define CONVATTR_FONT_ATOMS		10
#define CONVATTR_CURSOR			11

/* 128-255: can be specified only at startup time */
#define CONVATTR_INPUT_STYLE		128
#define CONVATTR_EVENT_CAPTURE_METHOD	129
#define CONVATTR_USE_EXTENSION		255

/* argument for CONVATTR_INPUT_STYLE and CONVPROP_SUPPORTED_STYLES */
#define CONVARG_ROOTWINDOW		1L
#define CONVARG_OFFTHESPOT		2L
#define CONVARG_OVERTHESPOT		4L

/* argument for CONVATTR_EVENT_CAPTURE_METHOD */
#define CONVARG_NONE			0L
#define CONVARG_CREATE_INPUTONLY	1L
#define CONVARG_SELECT_FOCUS_WINDOW	2L

/*
 * ץեǡ / Ѵ°ǡɽˡ
 *
 * ѴФɽץեǡȡѴ˴ؤ°ꤹ
 * Ѵ°ǡ϶̤ΥեޥåȤѤ롣
 *
 * ġΥǡ 32bitͤɽ롣ǽ 1ɤϥإåǡ
 *  0ɰʾΥǡ³إåξ 16bit ϤΥץե
 *  / Ѵ°Υɤɽ 16 bit ³ǡΥɿ 
 * (32bit ñ) ɽ
 *
 *	+----------------+----------------+
 *	|  Code (16bit)  | Length (16bit) |
 *	+----------------+----------------+
 *	|              Data0              |
 *	+---------------------------------+
 *	|              .....              |
 *	+---------------------------------+
 *	|              DataN              |
 *	+---------------------------------+
 *
 * ºݤΥץեǡѴ°ǡϤΥǡĤϢ³
 * ΤǤ롣
 */

/*
 * ץեǡ
 *
 * ץեǡѤΥɤϼ 4बƤ롣Ѵ°
 * ǡȰۤʤꡢץ饤١ѤΥΰʤɤѰդƤʤ
 *
 * Protocol Version
 *	code: 1
 *	data-length: 1
 *	data[0]:
 *		CARD32: protocol version atom ("PROTOCOL-2.0")
 *
 *	ǡѴФΥץȥСɽȥǤ롣
 *	ƤץȥΥС "PROTOCOL-2.0" Ǥ롣
 *
 * Supported Styles
 *	code: 2
 *	data-length: 1
 *	data[0]:
 *		CARD32: input styles
 *
 *	ǡѴФݡȤϥɽݡȤ
 *	ϥͤ bitwise-or Ǥ롣
 *
 * Supported Extensions
 *	code: 3
 *	data-length: N
 *	data[0]:
 *		CARD32: extension atom 1 (Atom)
 *	...
 *	data[N-1]:
 *		CARD32: extension atom N (Atom)
 *
 *	ǡѴФݡȤĥɽȥΥꥹȤǤ롣
 *
 * Extension Data
 *	code: 4
 *	data-length: N
 *	data[0]:
 *		CARD32: extension atom (Atom)
 *	data[1] - data[N-1]:
 *		extension specific data
 *
 *	ǡϳĥȼץեǡǤ롣ɸץȥ
 *	ȤƤϥǡƬ˳ĥȥ (Supported Extensions 
 *	˻ꤵ줿ΤǤʤФʤʤ)Ĥ뤳Ȥꤹǡ
 *	θΥǡ˴ؤƤϰڵꤷʤ
 *
 * 饤¦̵ѤκɤᡢProtocol Version  Supported
 * StylesιܤɬʤФʤʤޤExtension Data ʳϥץե
 * ǡƱɤΥǡʣäƤϤʤʤ
 */

/*
 * Ѵ°ǡ
 *
 * °ɤΤ0  255 ޤǤɸץȥ뤬ѤΤǡ
 * °꿶ƤʤȤäƾ˻ѤƤϤʤʤ
 * 褦ŪΤ° 256  65535 ץ饤١ȥɳĥ
 * ȤѰդƤ롣ΰλѤäƤϤ餫᤽
 * γĥɤѤ뤳Ȥ Use Extension () ѤƤ餫
 * ɬפ롣
 *
 * °ǡλˡˤϡѴϻ˻ꤹˡȡѴ˻ꤹ
 * ˡ 2̤꤬뤬°ɤˤäƤѴϻˤǤ
 * ʤΤ롣ǡ0-255 ɸॳɤΤ0  127 ޤǤ
 * ϻǤѴǤǤΡ128  255 ޤǤѴϻ
 * ǤʤΡʬƤ롣ĥɤˤĤƤäˤΤ褦
 * ʶ̤ʤ
 *
 * Υץȥ°ɤϼ̤Ǥ롣
 *
 * -- Ѵϻˤ⡢ѴˤǤ --
 *
 * No Operation:
 *	code: 0
 *	data-length: N (could be 0)
 *	data: anything
 *
 *	⤷ʤץѥƥΤʬ򥹥åפΤ
 *	
 * Indirect Attribute:
 *	code: 1
 *	data-length: 1
 *	data[0]:
 *		CARD32: property name (Atom)
 *
 *	ꤵ줿ץѥƥ˽ä°ꤹ롣CONVERSION_ATTRIBUTE
 * 	٥Ȥʣ°ǡꤷ䡢٥Ȥ°ǡ
 *	ڤʤ˻Ѥ롣
 *
 * Focus Window:
 *	code: 2
 *	data-length: 1
 *	data[0]:
 *		CARD32: focus window (Window)
 *
 *	եɥꤹ롣
 *
 * Spot Location:
 *	data-length: 1
 *	data[0]:
 *		INT16(upper 16bit): X
 *		INT16(lower 16bit): Y
 *
 *	ݥåȥꤹ롣١饤γǻꤹ롣
 *
 * Client Area:
 *	data-length: 2
 *	data[0]:
 *		INT16(upper 16bit): X
 *		INT16(lower 16bit): Y
 *	data[1]:
 *		CARD16(upper 16bit): Width
 *		CARD16(lower 16bit): Height
 *
 *	Ѵƥɽΰꤹ롣
 *
 * Status Area:
 *	data-length: 2
 *	data[0]:
 *		INT16(upper 16bit): X
 *		INT16(lower 16bit): Y
 *	data[1]:
 *		CARD16(upper 16bit): Width
 *		CARD16(lower 16bit): Height
 *
 *	ơɽΰꤹ롣
 *
 * Colormap:
 *	data-length: 1
 *	data[0]:
 *		CARD32: colormap (XID)
 *
 *	顼ޥå ID ꤹ롣
 *
 * Color:
 *	data-length: 2
 *	data[0]:
 *		CARD32: foreground pixel
 *	data[1]:
 *		CARD32: background pixel
 *
 *	ե饦ɤȥХå饦ɤΥԥͤꤹ롣
 *
 * Background Pixmap:
 *	data-length: 1
 *	data[0]:
 *		CARD32: background pixmap (Pixmap)
 *
 *	Хå饦ɤ Pixmap ID ꤹ롣
 *
 * Line Spacing:
 *	data-length: 1
 *	data[0]:
 *		CARD32: line spacing
 *
 *	Դ֤ꤹ롣١饤֤εΥǻꤹ롣
 *
 * Font Atoms:
 *	data-length: N (>0)
 *	data[0]:
 *		CARD32: font atom 1 (Atom)
 *	...
 *	data[N-1]:
 *		CARD32: font atom N (Atom)
 *
 *	ѤեȤ "FONT" ȥΥꥹȤꤹ롣
 *
 * Cursor:
 *	data-length: 1
 *	data[0]:
 *		CARD32: cursor (Cursor)
 *
 *	 ID ꤹ롣
 *
 * -- ѴϻΤ߻Ǥ --
 *
 * Input Style:
 *	data-length: 1
 *	data[0]:
 *		CARD32: input style
 *
 *	ˡꤹ롣
 *	ǥեȤ Root Window Style Ǥ롣
 *
 * Event Capture Method:
 *	data-length: 1
 *	data[0]:
 *		CARD32: event capture method
 *
 *	饤ȥɥΥ٥Ȥμˡꤹ롣ǥե
 *	Ȥϥ饤ȥɥ InputOnly ɥä
 *	Υ٥Ȥ򥻥쥯ȤȤΤǤ롣¾ˡȤƤϡ
 *	եɥ (եɥꤵƤʤ
 *	饤ȥɥ) Υ٥Ȥľܥ쥯Ȥ (ξ
 *	硢Ѵϥ饤Ȥϥ٥Ȥ̵뤷ʤƤϤʤʤ) 
 *	Τȡ⤷ʤĤޤѴΥ饤Ȥϥ٥Ȥ
 *	ȥɤ SendEvent ʤƤϤʤʤȤˡ롣
 *
 * Use Extension:
 *	data-length: N
 *	data[0]:
 *		CARD32: extension atom 1 (Atom)
 *	...
 *	data[N-1]:
 *		CARD32: extension atom N (Atom)
 *
 *	°ǻѤĥꤹ롣ǻꤹĥϥ
 *	ФݡȤƤΡĤޤץեǡSupported
 *	Extensions ˽񤫤줿ĥǤʤФʤʤ
 */

#endif /* _TKKINPUT2 */
