;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; See Template.scm in the Scheme Library for how to set up
;;; vicinities and require.

(define jacal-vicinity (program-vicinity))
;;	Save our vicinity for later dynamic loads.
(slib:load (in-vicinity jacal-vicinity "scl"))
;;	Common Lisp/Scheme compatability definitions.
(slib:load (in-vicinity jacal-vicinity "toploads"))
;;	Initialize modes to something reasonable.
(slib:load (in-vicinity jacal-vicinity "modeinit"))

;;;; error and interrupt response for SCM.
;;; Put appropriate handlers for other systems here.

(define (impl:error str args)
  (force-output)
  (newline-diag)
  (perror (tran:translate 'ERROR))
  (set-errno 0)
  (display-diag str)
  (display-diag (tran:translate 'Last-expression-lost))
  (newline-diag)
  (display-diag args)
  (newline-diag)
  (force-output)
  (math:exit #f))			;return to math top level.

;;;; These are error handlers for SCM.
;;(define out-of-storage #f)
(define could-not-open #f)
(define arithmetic-error #f)
;;(define user-interrupt #f)
(define end-of-program #f)
;(define hang-up end-of-program)		;automatic

(define (set-handlers!)
;;  (set! out-of-storage (lambda args (impl:error "Out of storage" args)))
  (set! could-not-open (lambda args (impl:error "File not found" args)))
  (set! arithmetic-error (lambda args (impl:error "Arithmetic Error" args)))
;;  (set! user-interrupt (lambda args (impl:error "User Interrupt" args)))
  (set! end-of-program (lambda args (math:exit #t))))

(define (cleanup-handlers!)
;;  (set! out-of-storage #f)
  (set! could-not-open #f)
  (set! arithmetic-error #f)
;;  (set! user-interrupt #f)
  (set! end-of-program #f))
