/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.facade.HttpServletRequestFacade;
import org.apache.tomcat.facade.ServletOutputStreamFacade;
import org.apache.tomcat.facade.ServletWriterFacade;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.net.URL;
import org.apache.tomcat.util.res.StringManager;

public final class HttpServletResponseFacade
implements HttpServletResponse {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    private Response response;
    private boolean usingStream = false;
    private boolean usingWriter = false;
    ServletOutputStreamFacade osFacade = null;
    ServletWriterFacade writer;

    HttpServletResponseFacade(Response response) {
        this.response = response;
        OutputBuffer oBuffer = response.getBuffer();
        this.writer = new ServletWriterFacade(oBuffer, response);
    }

    void recycle() {
        this.usingStream = false;
        this.usingWriter = false;
        if (this.writer.checkError()) {
            OutputBuffer oBuffer = this.response.getBuffer();
            this.writer = new ServletWriterFacade(oBuffer, this.response);
        }
        if (this.osFacade != null) {
            this.osFacade.recycle();
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.response.isIncluded()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
        this.addHeader("Set-Cookie", sb.toString());
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeRedirectURL(String location) {
        if (this.isEncodeable(this.toAbsolute(location))) {
            return this.toEncoded(location, this.response.getRequest().getSession(false));
        }
        return location;
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.response.getRequest().getSession(false));
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            String msg = sm.getString("serverResponse.outputStream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        if (this.osFacade != null) {
            return this.osFacade;
        }
        this.osFacade = new ServletOutputStreamFacade(this.response);
        return this.osFacade;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingStream) {
            String msg = sm.getString("serverResponse.writer.ise");
            throw new IllegalStateException(msg);
        }
        this.usingWriter = true;
        return this.writer;
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "No detailed message");
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            Context ctx = this.response.getRequest().getContext();
            ctx.log("Servlet API error: sendError with commited buffer ", new Throwable("Trace"));
            throw new IllegalStateException(sm.getString("hsrf.error.ise"));
        }
        this.setStatus(sc);
        Request request = this.response.getRequest();
        request.setAttribute("javax.servlet.error.message", (Object)msg);
        ContextManager cm = request.getContextManager();
        cm.handleStatus(request, this.response, sc);
    }

    public void sendRedirect(String location) throws IOException, IllegalArgumentException {
        if (location == null) {
            String msg = sm.getString("hsrf.redirect.iae");
            throw new IllegalArgumentException(msg);
        }
        this.sendError(302, this.toAbsolute(location));
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        if (!this.response.isIncluded()) {
            MimeHeaders headers = this.response.getMimeHeaders();
            headers.setValue(name).setTime(date);
        }
    }

    public void addDateHeader(String name, long value) {
        if (!this.response.isIncluded()) {
            MimeHeaders headers = this.response.getMimeHeaders();
            headers.addValue(name).setTime(value);
        }
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.response.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setBufferSize(int size) throws IllegalStateException {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void reset() throws IllegalStateException {
        this.response.reset();
    }

    public boolean isCommitted() {
        return this.response.isBufferCommitted();
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setStatus(int sc, String msg) {
        this.response.setStatus(sc);
    }

    private boolean isEncodeable(String location) {
        int serverPort;
        if (location.startsWith("#")) {
            return false;
        }
        Request request = this.response.getRequest();
        ServerSession session = request.getSession(false);
        if (session == null || !session.isValid()) {
            return false;
        }
        if (!session.getTimeStamp().isNew() && ((HttpServletRequestFacade)request.getFacade()).isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!request.scheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.serverName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int urlPort = url.getPort();
        if (urlPort == -1) {
            if ("http".equalsIgnoreCase(url.getProtocol())) {
                urlPort = 80;
            } else if ("https".equalsIgnoreCase(url.getProtocol())) {
                urlPort = 443;
            }
        }
        if ((serverPort = request.getServerPort()) == -1) {
            serverPort = 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = request.getContext().getPath();
        if (contextPath != null && contextPath.length() > 0) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e1) {
            Request request = this.response.getRequest();
            HttpServletRequestFacade reqF = (HttpServletRequestFacade)request.getFacade();
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)reqF).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException e2) {
                return location;
            }
        }
        return url.toExternalForm();
    }

    private String toEncoded(String url, ServerSession session) {
        StringBuffer sb;
        if (url == null || session == null) {
            return url;
        }
        String sessionId = session.getId().toString();
        String path = null;
        String query = null;
        int question = url.indexOf("?");
        if (question < 0) {
            path = url;
        } else {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        String anchor = null;
        int hashP = path.indexOf("#");
        if (hashP >= 0) {
            anchor = path.substring(hashP);
            path = path.substring(0, hashP);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if (anchor != null) {
            sb.append(anchor);
        }
        if (query != null) {
            sb.append(query);
        }
        return sb.toString();
    }
}

