/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.ParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        try {
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '\\' && chars[i + 3] == '>') {
                    caw.write(37);
                    caw.write(62);
                    i += 3;
                } else {
                    caw.write(chars[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return caw.toCharArray();
    }

    public static boolean isExpression(String token) {
        return token.startsWith(OPEN_EXPR) && token.endsWith(CLOSE_EXPR);
    }

    public static String getExpr(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(OPEN_EXPR.length(), length - CLOSE_EXPR.length()) : "";
        return returnString;
    }

    public static Document parseXMLDoc(InputStream in, String dtdResource, String dtdId) throws JasperException {
        return JspUtil.parseXMLDocJaxp(in, dtdResource, dtdId);
    }

    /*
     * WARNING - void declaration
     */
    public static Document parseXMLDocJaxp(InputStream in, String dtdResource, String dtdId) throws JasperException {
        try {
            void ex;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(true);
            docFactory.setNamespaceAware(true);
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            MyEntityResolver resolver = new MyEntityResolver(dtdId, dtdResource);
            builder.setEntityResolver(resolver);
            Document tld = builder.parse(in);
            return ex;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{ex.getMessage()}));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString("jsp.error.unable.to.open.TLD", new Object[]{io.getMessage()}));
        }
    }

    public static void checkAttributes(String typeOfTag, Hashtable attrs, ValidAttribute[] validAttributes, Mark start) throws JasperException {
        boolean valid = true;
        Hashtable temp = (Hashtable)attrs.clone();
        String missingAttribute = null;
        int i = 0;
        while (i < validAttributes.length) {
            if (validAttributes[i].mandatory) {
                if (temp.get(validAttributes[i].name) != null) {
                    temp.remove(validAttributes[i].name);
                    valid = true;
                } else {
                    valid = false;
                    missingAttribute = validAttributes[i].name;
                    break;
                }
            }
            ++i;
        }
        if (!valid) {
            throw new ParseException(start, Constants.getString("jsp.error.mandatory.attribute", new Object[]{typeOfTag, missingAttribute}));
        }
        if (temp.size() == 0) {
            return;
        }
        Enumeration enumeration = temp.keys();
        String attribute = null;
        while (enumeration.hasMoreElements()) {
            valid = false;
            attribute = (String)enumeration.nextElement();
            int i2 = 0;
            while (i2 < validAttributes.length) {
                if (attribute.equals(validAttributes[i2].name)) {
                    valid = true;
                    break;
                }
                ++i2;
            }
            if (valid) continue;
            throw new ParseException(start, Constants.getString("jsp.error.invalid.attribute", new Object[]{typeOfTag, attribute}));
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "\\\"";
        int index = 0;
        while (index < unescString.length()) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
            ++index;
        }
        return escString;
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quote;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public ValidAttribute(String name) {
            this(name, false);
        }
    }
}

