/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class TagPoolGenerator
extends GeneratorBase
implements ClassDeclarationPhase,
InitMethodPhase {
    private String prefix;
    private String shortTagName;
    private TagLibraryInfo tli;
    private TagInfo ti;
    private Hashtable attrs;
    private String poolName;
    private String poolVarName;
    private static final String POOL_VARIABLE_NAME_PREFIX = "_jspx_tagPool_";
    private static final String VALID_FIRST_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
    private static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_1234567890";
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    private TagPoolGenerator() {
    }

    public TagPoolGenerator(String prefix, String shortTagName, Hashtable attrs, TagLibraryInfo tli, TagInfo ti) {
        this.prefix = prefix;
        this.shortTagName = shortTagName;
        this.tli = tli;
        this.ti = ti;
        this.attrs = attrs;
        this.poolName = TagPoolGenerator.getPoolName(tli, ti, attrs);
        this.poolVarName = TagPoolGenerator.getPoolVariableName(this.poolName);
    }

    public static String getPoolName(TagLibraryInfo tli, TagInfo ti, Hashtable attributes) {
        return TagPoolGenerator.getSafeVariableName(tli.getURI() + "_" + ti.getTagName() + TagPoolGenerator.getStringFromAttributes(attributes));
    }

    public static String getPoolVariableName(TagLibraryInfo tli, TagInfo ti, Hashtable attributes) {
        return TagPoolGenerator.getPoolVariableName(TagPoolGenerator.getPoolName(tli, ti, attributes));
    }

    public static String getPoolVariableName(String poolName) {
        return TagPoolGenerator.getSafeVariableName(POOL_VARIABLE_NAME_PREFIX + poolName);
    }

    public void generate(ServletWriter writer, Class phase) {
        if ((class$org$apache$jasper$compiler$ClassDeclarationPhase == null ? (class$org$apache$jasper$compiler$ClassDeclarationPhase = TagPoolGenerator.class$("org.apache.jasper.compiler.ClassDeclarationPhase")) : class$org$apache$jasper$compiler$ClassDeclarationPhase).isAssignableFrom(phase)) {
            writer.println(Constants.JSP_RUNTIME_PACKAGE + ".TagHandlerPool " + this.poolVarName + " = null;");
        } else if ((class$org$apache$jasper$compiler$InitMethodPhase == null ? (class$org$apache$jasper$compiler$InitMethodPhase = TagPoolGenerator.class$("org.apache.jasper.compiler.InitMethodPhase")) : class$org$apache$jasper$compiler$InitMethodPhase).isAssignableFrom(phase)) {
            writer.println("if (tagPoolManager != null) {");
            writer.pushIndent();
            writer.println(this.poolVarName + " = ");
            writer.pushIndent();
            writer.println("tagPoolManager.getPool(\"" + this.poolName + "\",");
            writer.println(this.ti.getTagClassName() + ".class);");
            writer.popIndent();
            writer.popIndent();
            writer.println("}");
        }
    }

    private static String getStringFromAttributes(Hashtable attributes) {
        int i;
        if (attributes == null || attributes.isEmpty()) {
            return "";
        }
        Vector<String> sortedAttributes = new Vector<String>(attributes.size());
        Enumeration elements = attributes.keys();
        while (elements.hasMoreElements()) {
            String attributeName = (String)elements.nextElement();
            i = 0;
            while (i < sortedAttributes.size()) {
                if (attributeName.compareTo((String)sortedAttributes.elementAt(i)) < 0) break;
                ++i;
            }
            sortedAttributes.insertElementAt(attributeName, i);
        }
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < sortedAttributes.size()) {
            buffer.append('_');
            buffer.append(sortedAttributes.elementAt(i));
            ++i;
        }
        return buffer.toString();
    }

    private static String getSafeVariableName(String s) {
        StringBuffer buffer = new StringBuffer();
        String compareAgainst = VALID_FIRST_CHARS;
        int i = 0;
        while (i < s.length()) {
            if (i == 1) {
                compareAgainst = VALID_CHARS;
            }
            if (compareAgainst.indexOf(s.charAt(i)) != -1) {
                buffer.append(s.charAt(i));
            } else {
                buffer.append('_');
            }
            ++i;
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

