/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.runtime.TagHandlerPool;
import org.apache.jasper.runtime.TagHandlerPoolImpl;
import org.apache.jasper.runtime.TagPoolManager;
import org.apache.tomcat.util.log.Log;

public class TagPoolManagerImpl
implements TagPoolManager {
    Hashtable myPools = new Hashtable();
    Log myLog = Log.getLog("tag_pool_log", this);
    public static final String LOG_NAME = "tag_pool_log";

    public TagHandlerPool getPool(String poolName, Class handlerClass) {
        TagHandlerPool returnValue = null;
        Hashtable hashtable = this.myPools;
        synchronized (hashtable) {
            returnValue = (TagHandlerPool)this.myPools.get(poolName);
            if (returnValue == null) {
                returnValue = new TagHandlerPoolImpl(handlerClass, poolName);
                this.myPools.put(poolName, returnValue);
            }
            if (this.myLog.getLevel() >= 3) {
                this.myLog.log("Getting pool named '" + poolName + "' for tag handler class '" + handlerClass.getName() + "'", 3);
                this.myLog.log("Number of pools is now " + this.myPools.size(), 3);
            }
        }
        return returnValue;
    }

    public void shutdown() {
        Hashtable hashtable = this.myPools;
        synchronized (hashtable) {
            if (this.myLog.getLevel() >= 3) {
                this.myLog.log("Shutting down " + this.myPools.size() + " pools", 3);
            }
            Enumeration pools = this.myPools.elements();
            while (pools.hasMoreElements()) {
                ((TagHandlerPool)pools.nextElement()).shutdown();
            }
        }
    }
}

