/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.runtime.JspLoader;
import org.apache.jasper.servlet.JspServlet;

public class JasperLoader
extends JspLoader {
    Object pd;
    private static final int debug = 0;

    public void setProtectionDomain(Object pd) {
        this.pd = pd;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public URL getResource(String name) {
        if (this.parent != null) {
            return this.parent.getResource(name);
        }
        return super.getResource(name);
    }

    private void log(String s) {
        System.out.println("JspLoader: " + s);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        try {
            int beg = className.lastIndexOf(".") == -1 ? 0 : className.lastIndexOf(".") + 1;
            int end = className.lastIndexOf("_jsp_");
            if (end <= 0) {
                byte[] classBytes = this.loadClassDataFromJar(className);
                if (classBytes == null) {
                    throw new ClassNotFoundException(className);
                }
                return this.defClass(className, classBytes);
            }
            String fileName = null;
            String outputDir = this.options.getScratchDir().toString();
            if (className.indexOf(36, end) != -1) {
                fileName = outputDir + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
            } else {
                fileName = className.substring(beg, end) + ".class";
                fileName = outputDir + File.separatorChar + fileName;
            }
            byte[] classBytes = null;
            classBytes = this.loadClassDataFromFile(fileName);
            if (classBytes == null) {
                throw new ClassNotFoundException(Constants.getString("jsp.error.unable.loadclass", new Object[]{className}));
            }
            return this.defClass(className, classBytes);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(Constants.getString("jsp.error.unable.loadclass", new Object[]{className}));
        }
    }

    protected Class defClass(String className, byte[] classData) {
        return this.defineClass(className, classData, 0, classData.length);
    }

    protected byte[] loadClassDataFromFile(String fileName) {
        return this.doLoadClassDataFromFile(fileName);
    }

    protected byte[] doLoadClassDataFromFile(String fileName) {
        byte[] classBytes = null;
        try {
            FileInputStream fin = new FileInputStream(fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fin.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            fin.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
        return classBytes;
    }

    private byte[] loadClassDataFromJar(String className) {
        String entryName = className.replace('.', '/') + ".class";
        InputStream classStream = null;
        int i = 0;
        while (i < this.jars.size()) {
            File thisFile = new File((String)this.jars.elementAt(i));
            try {
                if (thisFile.exists()) {
                    if (thisFile.isFile()) {
                        ZipFile zip = new ZipFile(thisFile);
                        ZipEntry entry = zip.getEntry(entryName);
                        if (entry != null) {
                            classStream = zip.getInputStream(entry);
                            byte[] classData = this.getClassData(classStream);
                            zip.close();
                            return classData;
                        }
                        zip.close();
                    } else {
                        File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                        if (classFile.exists()) {
                            classStream = new FileInputStream(classFile);
                            byte[] classData = this.getClassData(classStream);
                            classStream.close();
                            return classData;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                return null;
            }
            ++i;
        }
        return null;
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public String toString() {
        File obj = this.options == null ? null : this.options.getScratchDir();
        String s = obj == null ? "null" : ((Object)obj).toString();
        return "JspLoader@" + this.hashCode() + "( " + s + " ) / " + this.parent;
    }

    boolean loadJSP(JspServlet jspS, String name, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        return jspS.doLoadJSP(name, classpath, isErrorPage, req, res);
    }
}

