/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathAPI {
    public static XObject eval(Node node, String string) throws TransformerException {
        return XPathAPI.eval(node, string, node);
    }

    public static XObject eval(Node node, String string, PrefixResolver prefixResolver) throws TransformerException {
        XPath xPath = new XPath(string, null, prefixResolver, 0, null);
        return xPath.execute(new XPathContext(), node, prefixResolver);
    }

    public static XObject eval(Node node, String string, Node node2) throws TransformerException {
        XPathContext xPathContext = new XPathContext();
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node2.getNodeType() == 9 ? ((Document)node2).getDocumentElement() : node2);
        XPath xPath = new XPath(string, null, prefixResolverDefault, 0, null);
        return xPath.execute(xPathContext, node, prefixResolverDefault);
    }

    public static NodeIterator selectNodeIterator(Node node, String string) throws TransformerException {
        return XPathAPI.selectNodeIterator(node, string, node);
    }

    public static NodeIterator selectNodeIterator(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = XPathAPI.eval(node, string, node2);
        return xObject.nodeset();
    }

    public static NodeList selectNodeList(Node node, String string) throws TransformerException {
        return XPathAPI.selectNodeList(node, string, node);
    }

    public static NodeList selectNodeList(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = XPathAPI.eval(node, string, node2);
        NodeSet nodeSet = xObject.mutableNodeset();
        nodeSet.setShouldCacheNodes(true);
        return nodeSet;
    }

    public static Node selectSingleNode(Node node, String string) throws TransformerException {
        return XPathAPI.selectSingleNode(node, string, node);
    }

    public static Node selectSingleNode(Node node, String string, Node node2) throws TransformerException {
        NodeIterator nodeIterator = XPathAPI.selectNodeIterator(node, string, node2);
        return nodeIterator.nextNode();
    }
}

