/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import org.apache.tomcat.util.depend.Dependency;

public class DependManager {
    int delay = 4000;
    Dependency[] deps;
    int depsCount = 0;
    long lastCheck = 0L;
    boolean checking = false;
    long checkTime = 0L;
    int checkCount = 0;
    private boolean expired = false;
    static final int INITIAL_DEP_SIZE = 32;
    private static boolean noWarnBadVM = true;
    private int debug = 0;

    public DependManager() {
        this(32);
    }

    public DependManager(int initial_size) {
        this.deps = new Dependency[initial_size];
    }

    public void reset() {
        this.expired = false;
        int i = 0;
        while (i < this.depsCount) {
            Dependency d = this.deps[i];
            d.reset();
            ++i;
        }
    }

    public void setDelay(int d) {
        this.delay = d;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public long getCheckCount() {
        return this.checkCount;
    }

    public boolean shouldReload() {
        boolean b = this.shouldReload1();
        if (b != this.expired && noWarnBadVM) {
            this.log("BUG ( VM or Tomcat? ) shouldReload returns expired=" + b + " and the real value is " + this.expired);
            noWarnBadVM = false;
        }
        return this.expired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldReload1() {
        if (this.debug > 0 && this.expired) {
            this.log("ShouldReload1 E=" + this.expired + " C=" + this.checking);
        }
        if (this.checking) {
            return this.expired;
        }
        DependManager dependManager = this;
        synchronized (dependManager) {
            block16: {
                boolean bl;
                block15: {
                    try {
                        if (this.debug > 0 && this.expired) {
                            this.log("ShouldReload2 E=" + this.expired + " C=" + this.checking);
                        }
                        if (this.checking) {
                            boolean bl2 = this.expired;
                            Object var8_4 = null;
                            this.checking = false;
                            return bl2;
                        }
                        long startCheck = System.currentTimeMillis();
                        if (startCheck - this.lastCheck < (long)this.delay) {
                            if (this.debug > 0 && this.expired) {
                                this.log("ShouldReload3 E=" + this.expired + " C=" + this.checking);
                            }
                            bl = this.expired;
                            break block15;
                        }
                        this.checking = true;
                        int i = 0;
                        while (true) {
                            if (i >= this.depsCount) {
                                this.checkTime += this.lastCheck - startCheck;
                                ++this.checkCount;
                                this.lastCheck = startCheck;
                                break block16;
                            }
                            Dependency d = this.deps[i];
                            if (d.checkExpiry()) {
                                if (this.debug > 0) {
                                    this.log("Found expired file " + d.getOrigin().getName());
                                }
                                if (!d.isLocal()) {
                                    this.expired = true;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        this.checking = false;
                        throw throwable;
                    }
                }
                Object var8_5 = null;
                this.checking = false;
                return bl;
            }
            Object var8_6 = null;
            this.checking = false;
            if (this.debug <= 0) return this.expired;
            if (!this.expired) return this.expired;
            this.log("ShouldReload5 E=" + this.expired + " C=" + this.checking);
            return this.expired;
        }
    }

    public void setLastModified(long time) {
        int i = 0;
        while (i < this.depsCount) {
            this.deps[i].setLastModified(time);
            ++i;
        }
    }

    public void setExpired(boolean e) {
        if (this.debug > 0) {
            this.log("SetExpired " + e);
        }
        int i = 0;
        while (i < this.depsCount) {
            this.deps[i].setExpired(e);
            ++i;
        }
    }

    public synchronized void addDependency(Dependency dep) {
        if (this.depsCount >= this.deps.length) {
            Dependency[] deps1 = new Dependency[this.deps.length * 2];
            System.arraycopy(this.deps, 0, deps1, 0, this.depsCount);
            this.deps = deps1;
        }
        this.deps[this.depsCount++] = dep;
        if (this.debug > 2) {
            this.log("Added " + dep.getOrigin() + " " + dep.getTarget());
        }
    }

    public void setDebug(int i) {
        this.debug = i;
    }

    void log(String s) {
        System.out.println("DependManager: " + s);
    }
}

