/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tomcat.util.log.Log;

public class FileUtil {
    static final String osName = System.getProperty("os.name");
    static Log loghelper = Log.getLog("tc/FileUtil", "FileUtil");

    public static File[] listFiles(File dir) {
        String[] ss = dir.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new File[n];
        int i = 0;
        while (i < n) {
            fs[i] = new File(dir.getPath(), ss[i]);
            ++i;
        }
        return fs;
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        lookupPath = lookupPath.substring(0, index);
        while (path.startsWith("../")) {
            if (lookupPath.length() <= 0) {
                return null;
            }
            index = lookupPath.lastIndexOf("/");
            lookupPath = lookupPath.substring(0, index);
            index = path.indexOf("../") + 3;
            path = path.substring(index);
        }
        return lookupPath + "/" + path;
    }

    public static String safePath(String base, String path) {
        int ls;
        int index;
        if (path == null || path.equals("")) {
            return base;
        }
        String normP = path;
        if (path.indexOf(92) >= 0) {
            normP = path.replace('\\', '/');
        }
        if (!normP.startsWith("/")) {
            normP = "/" + normP;
        }
        if ((index = normP.indexOf("/../")) >= 0) {
            int index2 = 0;
            while ((index2 = normP.indexOf("//", index2)) >= 0) {
                normP = normP.substring(0, index2) + normP.substring(index2 + 1);
                if (index2 >= index) continue;
                --index;
            }
            index2 = 0;
            while ((index2 = normP.indexOf("/./", index2)) >= 0) {
                normP = normP.substring(0, index2) + normP.substring(index2 + 2);
                if (index2 >= index) continue;
                index -= 2;
            }
            while (index >= 0) {
                if (index == 0) {
                    return null;
                }
                index2 = normP.lastIndexOf(47, index - 1);
                normP = normP.substring(0, index2) + normP.substring(index + 3);
                index = normP.indexOf("/../", index2);
            }
        }
        String realPath = base + normP;
        realPath = FileUtil.patch(realPath);
        String canPath = null;
        try {
            canPath = new File(realPath).getCanonicalPath();
        }
        catch (IOException ex) {
            loghelper.log("in safePath(" + base + ", " + path + "), realPath=" + realPath, ex);
            return null;
        }
        if (File.separatorChar == '\\' && !realPath.equals(canPath) && (ls = realPath.lastIndexOf(92)) > 0 && !realPath.substring(0, ls).equals(canPath)) {
            return null;
        }
        if (realPath.indexOf("..") != -1) {
            return null;
        }
        return realPath;
    }

    public static String patch(String path) {
        char[] ca;
        String patchPath = path;
        if (patchPath.length() >= 3 && patchPath.charAt(0) == '/' && Character.isLetter(patchPath.charAt(1)) && patchPath.charAt(2) == ':') {
            patchPath = patchPath.substring(1, 3) + "/" + patchPath.substring(3);
        }
        if (patchPath.length() >= 2 && Character.isLetter(patchPath.charAt(0)) && patchPath.charAt(1) == ':') {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    char c = i == 0 && Character.isLetter(ca[i]) && i < ca.length - 1 && ca[i + 1] == ':' ? Character.toUpperCase(ca[i]) : ca[i];
                    sb.append(c);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        if (osName.startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0) {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    sb.append(ca[i]);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        return patchPath;
    }

    public static boolean isAbsolute(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        if (path.startsWith(File.separator)) {
            return true;
        }
        if (path.length() >= 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return true;
        }
        return osName.startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0;
    }

    public static String getCanonicalPath(String name) {
        if (name == null) {
            return null;
        }
        File f = new File(name);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            System.err.println("getCanonicalPath(" + name + ")");
            ioe.printStackTrace();
            return name;
        }
    }

    public static String removeLast(String s) {
        int i = s.lastIndexOf("/");
        s = i > 0 ? s.substring(0, i) : (i == 0 && !s.equals("/") ? "/" : "");
        return s;
    }

    public static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf(File.separator);
        if (i > 0 && i > j) {
            return path.substring(i);
        }
        return null;
    }

    public static String getBase(String path) {
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf(File.separator);
        if (j < 0) {
            if (i < 0) {
                return path;
            }
            return path.substring(0, i);
        }
        if (i < j) {
            return path.substring(j);
        }
        return path.substring(j + 1, i);
    }

    public static void expand(String src, String dest) throws IOException {
        File srcF = new File(src);
        File dir = new File(dest);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(srcF));
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            File f = File.separatorChar == '\\' ? new File(dir, ze.getName().replace('/', '\\')) : new File(dir, ze.getName());
            File dirF = new File(f.getParent());
            dirF.mkdirs();
            if (ze.isDirectory()) {
                f.mkdirs();
                continue;
            }
            byte[] buffer = new byte[1024];
            int length = 0;
            FileOutputStream fos = new FileOutputStream(f);
            while ((length = zis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fos.close();
        }
    }

    public static void clearDir(File dir) {
        String[] files = dir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = new File(dir, files[i]);
                if (f.isDirectory()) {
                    FileUtil.clearDir(f);
                }
                try {
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            try {
                dir.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static File getConfigFile(File base, File configDir, String defaultF) {
        File parent;
        if (base == null) {
            base = new File(defaultF);
        }
        if (!base.isAbsolute()) {
            base = configDir != null ? new File(configDir, base.getPath()) : new File(base.getAbsolutePath());
        }
        if (!(parent = new File(base.getParent())).exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create path to config file :" + base.getAbsolutePath());
        }
        return base;
    }
}

