/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.SSLSupport;

class JSSESupport
implements SSLSupport {
    private SSLSocket ssl;

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
    }

    public String getCipherSuite() throws IOException {
        return "Unknown";
    }

    public Object[] getPeerCertificateChain() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        Object[] x509Certs = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
            if (jsseCerts == null) {
                jsseCerts = new javax.security.cert.X509Certificate[]{};
            }
            x509Certs = new X509Certificate[jsseCerts.length];
            int i = 0;
            while (i < x509Certs.length) {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (x509Certs == null || x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }
}

