/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.Socket;
import org.apache.tomcat.util.collections.SimplePool;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

class TcpWorkerThread
implements ThreadPoolRunnable {
    PoolTcpEndpoint endpoint;
    SimplePool connectionCache;
    static final boolean usePool = true;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connectionCache = new SimplePool(endpoint.getMaxThreads());
        int i = 0;
        while (i < endpoint.getMaxThreads() / 2) {
            this.connectionCache.put(new TcpConnection());
            ++i;
        }
    }

    public Object[] getInitData() {
        return this.endpoint.getConnectionHandler().init();
    }

    public void runIt(Object[] perThrData) {
        TcpConnection con = null;
        while (this.endpoint.isRunning()) {
            Socket s = this.endpoint.acceptSocket();
            if (null == s) continue;
            this.endpoint.tp.runIt(this);
            try {
                try {
                    if (this.endpoint.getServerSocketFactory() != null) {
                        this.endpoint.getServerSocketFactory().handshake(s);
                    }
                    if ((con = (TcpConnection)this.connectionCache.get()) == null) {
                        con = new TcpConnection();
                    }
                    con.setEndpoint(this.endpoint);
                    con.setSocket(s);
                    this.endpoint.setSocketOptions(s);
                    this.endpoint.getConnectionHandler().processConnection(con, perThrData);
                }
                catch (IOException e) {
                    this.endpoint.log("Handshake failed", e, 1);
                    Object var6_5 = null;
                    con.recycle();
                    if (con == null) break;
                    this.connectionCache.put(con);
                    break;
                }
                Object var6_4 = null;
                con.recycle();
                if (con == null) break;
                this.connectionCache.put(con);
                break;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                con.recycle();
                if (con != null) {
                    this.connectionCache.put(con);
                }
                throw throwable;
            }
        }
    }
}

