/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.qlog;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;

public class FastDateFormat
extends DateFormat {
    DateFormat df;
    long lastSec = -1L;
    StringBuffer sb = new StringBuffer();
    FieldPosition fp = new FieldPosition(8);

    public FastDateFormat(DateFormat df) {
        this.df = df;
    }

    public Date parse(String text, ParsePosition pos) {
        return this.df.parse(text, pos);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long dt = date.getTime();
        long ds = dt / 1000L;
        if (ds != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = ds;
        } else {
            int ms = (int)(dt % 1000L);
            int pos = this.fp.getEndIndex();
            int begin = this.fp.getBeginIndex();
            if (pos > 0) {
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
            }
        }
        toAppendTo.append(this.sb.toString());
        return toAppendTo;
    }
}

