/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.qlog;

import org.apache.tomcat.util.collections.Queue;
import org.apache.tomcat.util.qlog.LogEntry;

public final class LogDaemon
implements Runnable {
    private boolean shouldStop = false;
    private Thread logDaemonThread = null;
    private Queue logQueue = null;

    public void start() {
        if (this.logDaemonThread != null) {
            return;
        }
        this.logQueue = new Queue();
        this.logDaemonThread = new Thread(this);
        this.logDaemonThread.setName("QueueLogDaemon");
        this.shouldStop = false;
        this.logDaemonThread.start();
    }

    public void stop() {
        if (this.shouldStop) {
            return;
        }
        this.shouldStop = true;
        this.logQueue.stop();
        this.logDaemonThread = null;
        this.logQueue = null;
    }

    public boolean isStarted() {
        return this.logDaemonThread != null;
    }

    public void add(LogEntry logE) {
        if (this.logQueue != null) {
            this.logQueue.put(logE);
        } else {
            logE.getLogger().log(logE);
        }
    }

    public void run() {
        do {
            LogEntry logEntry = (LogEntry)this.logQueue.pull();
            if (this.shouldStop) {
                return;
            }
            logEntry.getLogger().log(logEntry);
        } while (!this.shouldStop);
    }
}

