/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.qlog;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.tomcat.util.log.LogHandler;
import org.apache.tomcat.util.qlog.FastDateFormat;

public abstract class Logger
extends LogHandler {
    protected static PrintWriter defaultSink = new PrintWriter(new OutputStreamWriter(System.err));
    protected long day;
    private static final String separator = System.getProperty("line.separator", "\n");
    public static final char[] NEWLINE = separator.toCharArray();
    protected boolean custom = true;
    protected String path;
    protected boolean timestamp = true;
    protected boolean timestampRaw = false;
    protected String timestampFormat = "yyyy-MM-dd HH:mm:ss";
    protected DateFormat timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
    private static FieldPosition position = new FieldPosition(1);
    static final String START_FORMAT = "${";
    static final String END_FORMAT = "}";
    public static final int MAX_THROWABLE_DEPTH = 3;
    private static Object[] emptyObjectArray = new Object[0];

    public static void setDefaultSink(Writer w) {
        if (w != null) {
            defaultSink = new PrintWriter(w);
        }
    }

    public void setPath(String path) {
        if (File.separatorChar == '/') {
            this.path = path.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = path.replace('/', '\\');
        }
    }

    public String getPath() {
        return this.path;
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        long date = System.currentTimeMillis();
        this.day = this.getDay(date);
        try {
            File file = new File(this.path);
            String logName = file.getParent() + File.separator + this.getDatePrefix(date, file.getName());
            file = new File(logName);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new PrintWriter(new FileWriter(logName));
        }
        catch (IOException ex) {
            System.err.print("Unable to open log file: " + this.path + "! ");
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    public void setVerbosityLevel(String level) {
        if ("warning".equalsIgnoreCase(level)) {
            this.level = 2;
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.level = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(level)) {
            this.level = 1;
        } else if ("information".equalsIgnoreCase(level)) {
            this.level = 3;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.level = 4;
        }
    }

    public void setVerbosityLevel(int level) {
        this.level = level;
    }

    public int getVerbosityLevel() {
        return this.level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setTimestamp(String value) {
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            this.timestamp = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            this.timestamp = false;
        }
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setTimestampFormat(String value) {
        if (value.equalsIgnoreCase("msec")) {
            this.timestampRaw = true;
        } else {
            this.timestampRaw = false;
            this.timestampFormat = value;
            this.timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
        }
    }

    public String getTimestampFormat() {
        if (this.timestampRaw) {
            return "msec";
        }
        return this.timestampFormat;
    }

    protected String formatTimestamp(long msec) {
        StringBuffer buf = new StringBuffer();
        this.formatTimestamp(msec, buf);
        return buf.toString();
    }

    protected void formatTimestamp(long msec, StringBuffer buf) {
        if (!this.timestamp) {
            return;
        }
        if (this.timestampRaw) {
            buf.append(Long.toString(msec));
            return;
        }
        Date d = new Date(msec);
        this.timestampFormatter.format(d, buf, position);
    }

    protected String getDatePrefix(long millis, String format) {
        try {
            int pos = format.indexOf(START_FORMAT);
            int lpos = format.lastIndexOf(END_FORMAT);
            if (pos != -1 && lpos != -1) {
                String f = "'" + format.substring(0, pos) + "'" + format.substring(pos + 2, lpos) + "'" + format.substring(lpos + 1) + "'";
                SimpleDateFormat sdf = new SimpleDateFormat(f);
                return sdf.format(new Date(millis));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return format;
    }

    protected long getDay(long millis) {
        return (millis + (long)TimeZone.getDefault().getRawOffset()) / 86400000L;
    }

    public static String throwableToString(Throwable t) {
        return Logger.throwableToString(t, "Root cause:");
    }

    public static String throwableToString(Throwable t, String rootcause) {
        if (rootcause == null) {
            rootcause = "Root Cause:";
        }
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        Logger.printThrowable(w, t, rootcause, 3);
        w.flush();
        return sw.toString();
    }

    private static void printThrowable(PrintWriter w, Throwable t, String rootcause, int depth) {
        if (t != null) {
            t.printStackTrace(w);
            Class<?> tC = t.getClass();
            Method[] mA = tC.getMethods();
            Method nextThrowableMethod = null;
            int i = 0;
            while (i < mA.length) {
                Class<?>[] params;
                if (("getRootCause".equals(mA[i].getName()) || "getNextException".equals(mA[i].getName()) || "getException".equals(mA[i].getName())) && ((params = mA[i].getParameterTypes()) == null || params.length == 0)) {
                    nextThrowableMethod = mA[i];
                    break;
                }
                ++i;
            }
            if (nextThrowableMethod != null) {
                try {
                    Throwable nextT = (Throwable)nextThrowableMethod.invoke((Object)t, emptyObjectArray);
                    if (nextT != null) {
                        w.println(rootcause);
                        if (depth > 0) {
                            Logger.printThrowable(w, nextT, rootcause, depth - 1);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }
}

