/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.qlog;

import org.apache.tomcat.util.collections.SimplePool;
import org.apache.tomcat.util.qlog.LogDaemon;
import org.apache.tomcat.util.qlog.LogEntry;
import org.apache.tomcat.util.qlog.Logger;

public class QueueLogger
extends Logger {
    private LogDaemon logDaemon = null;
    private SimplePool pool = new SimplePool();
    private static final char[] NEWLINE = Logger.NEWLINE;
    char[] outBuffer = new char[512];
    StringBuffer outSB = new StringBuffer();

    public void setLogDaemon(LogDaemon ld) {
        this.logDaemon = ld;
    }

    public void log(String prefix, String message, Throwable t, int verbosityLevel) {
        if (!this.logDaemon.isStarted()) {
            System.out.println("SUPER " + this.logDaemon + " " + message);
            super.log(prefix, message, t, verbosityLevel);
            return;
        }
        if (verbosityLevel <= this.getVerbosityLevel()) {
            LogEntry entry;
            if (this.path != null && this.day != this.getDay(System.currentTimeMillis())) {
                QueueLogger queueLogger = this;
                synchronized (queueLogger) {
                    this.close();
                    this.open();
                }
            }
            if ((entry = (LogEntry)this.pool.get()) == null) {
                entry = new LogEntry(this);
            }
            if (this.timestamp) {
                entry.setDate(System.currentTimeMillis());
            } else {
                entry.setDate(0L);
            }
            entry.setPrefix(prefix);
            entry.setMessage(message);
            entry.setThrowable(t);
            this.logDaemon.add(entry);
        }
    }

    public void flush() {
    }

    void log(LogEntry logEntry) {
        if (logEntry == null) {
            System.out.println("Null log entry ");
            return;
        }
        try {
            this.outSB.setLength(0);
            logEntry.print(this.outSB);
            this.outSB.append(NEWLINE);
            int len = this.outSB.length();
            if (len > this.outBuffer.length) {
                this.outBuffer = new char[len];
            }
            this.outSB.getChars(0, len, this.outBuffer, 0);
            if (this.sink != null) {
                this.sink.write(this.outBuffer, 0, len);
                this.sink.flush();
            } else {
                System.out.println("No writer ");
                System.out.print(new String(this.outBuffer, 0, len));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.pool.put(logEntry);
    }
}

