/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.Jdk11Compat;

public class Jspc {
    Hashtable attributes = new Hashtable();
    String[] args;
    String installDir;
    ClassLoader parentL;
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    private static int dL = 0;

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setInstall(String s) {
        this.installDir = s;
    }

    public void execute() throws Exception {
        if (this.args != null) {
            this.processArgs(this.args);
        }
        Vector v = new Vector();
        String commonDir = this.installDir + File.separator + "lib" + File.separator + "common";
        IntrospectionUtils.addToClassPath(v, (String)commonDir);
        IntrospectionUtils.addToolsJar(v);
        String containerDir = this.installDir + File.separator + "lib" + File.separator + "container";
        IntrospectionUtils.addToClassPath(v, (String)containerDir);
        String appsDir = this.installDir + File.separator + "lib" + File.separator + "apps";
        IntrospectionUtils.addToClassPath(v, (String)appsDir);
        URL[] commonCP = IntrospectionUtils.getClassPath(v);
        ClassLoader commonCL = jdk11Compat.newClassLoaderInstance(commonCP, this.parentL);
        Class<?> jspcClass = commonCL.loadClass("org.apache.jasper.JspC");
        IntrospectionUtils.callMain(jspcClass, (String[])this.args);
    }

    public boolean processArgs(String[] args) {
        try {
            if (args.length > 0 && "jspc".equalsIgnoreCase(args[0])) {
                String[] args1 = new String[args.length - 1];
                System.arraycopy(args, 1, args1, 0, args.length - 1);
                args = args1;
            }
            this.setArgs(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void setProperty(String s, Object v) {
        if (dL > 0) {
            this.debug("Generic property " + s);
        }
        this.attributes.put(s, v);
    }

    public void setAttribute(String s, Object o) {
        if ("install".equals(s)) {
            this.setInstall((String)o);
        }
        if ("args".equals(s)) {
            this.args = (String[])o;
        }
        if ("parentClassLoader".equals(s)) {
            this.parentL = (ClassLoader)o;
        }
        this.attributes.put(s, o);
    }

    public static void main(String[] args) {
        try {
            Jspc task = new Jspc();
            task.setArgs(args);
            task.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void debug(String s) {
        System.out.println("Jspc: " + s);
    }
}

