/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import java.io.File;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.aaa.BasicAuthHandler;
import org.apache.tomcat.modules.aaa.FormAuthHandler;
import org.apache.tomcat.modules.aaa.FormSecurityCheckHandler;
import org.apache.tomcat.modules.aaa.SecurityConstraints;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.io.FileUtil;

public class AccessInterceptor
extends BaseInterceptor {
    ContextManager cm;
    int secMapNote;
    int reqRolesNote;
    int reqTransportNote;
    boolean ignoreCase = File.separatorChar == '\\';

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.cm = cm;
        this.secMapNote = cm.getNoteId(1, "map.security");
        this.reqRolesNote = cm.getNoteId(2, "required.roles");
        this.reqTransportNote = cm.getNoteId(2, "required.transport");
    }

    public void contextInit(Context ctx) throws TomcatException {
        String login_type = ctx.getAuthMethod();
        if (this.debug > 0) {
            this.log("Init  " + ctx.getHost() + " " + ctx.getPath() + " " + login_type);
        }
        if ("FORM".equals(login_type)) {
            String cpath;
            String page = ctx.getFormLoginPage();
            String errorPage = ctx.getFormErrorPage();
            if (page == null || errorPage == null) {
                ctx.log("Form login without form pages, defaulting to basic " + page + " " + errorPage);
                BasicAuthHandler baH = new BasicAuthHandler();
                baH.setModule(this);
                ctx.addServlet((Handler)baH);
                ctx.addErrorPage("401", "tomcat.basicAuthHandler");
                return;
            }
            if (!page.startsWith("/")) {
                ctx.log("FORM: login page doesn't start with / " + page);
                page = "/" + page;
            }
            if (!errorPage.startsWith("/")) {
                ctx.log("FORM: error page doesn't start with / " + errorPage);
                errorPage = "/" + errorPage;
            }
            if (page.startsWith((cpath = ctx.getPath()) + "/")) {
                if (!"".equals(cpath) && !"/".equals(cpath)) {
                    ctx.log("FORM: WARNING, login page starts with context path " + page + " " + cpath);
                }
            } else {
                page = cpath + page;
            }
            if (errorPage.startsWith(cpath + "/")) {
                if (!"/".equals(cpath) && !"".equals(cpath)) {
                    ctx.log("FORM: WARNING, error page starts with context path " + errorPage);
                }
            } else {
                errorPage = cpath + errorPage;
            }
            ctx.setFormLoginPage(page);
            ctx.setFormErrorPage(errorPage);
            FormAuthHandler formH = new FormAuthHandler();
            formH.setModule(this);
            ctx.addServlet((Handler)formH);
            FormSecurityCheckHandler fscH = new FormSecurityCheckHandler();
            fscH.setModule(this);
            ctx.addServlet((Handler)fscH);
            ctx.addErrorPage("401", "tomcat.formAuthHandler");
            String pageP = page.substring(cpath.length());
            int lastS = pageP.lastIndexOf("/");
            String location = "/j_security_check";
            if (lastS > 0) {
                location = pageP.substring(0, lastS) + "/j_security_check";
            }
            ctx.addServletMapping(location, "tomcat.formSecurityCheck");
            if (this.debug > 0) {
                ctx.log("Map " + location + " to tomcat.formSecurityCheck for " + page);
            }
        } else if ("BASIC".equals(login_type)) {
            BasicAuthHandler baH = new BasicAuthHandler();
            baH.setModule(this);
            ctx.addServlet((Handler)baH);
            ctx.addErrorPage("401", "tomcat.basicAuthHandler");
        }
    }

    public void removeContainer(Container ct) throws TomcatException {
    }

    public void addContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        Container ctxCt = ctx.getContainer();
        SecurityConstraints ctxSecurityC = (SecurityConstraints)ctxCt.getNote(this.secMapNote);
        if (ctxSecurityC == null) {
            ctxSecurityC = new SecurityConstraints();
            ctxCt.setNote(this.secMapNote, (Object)ctxSecurityC);
        }
        if (ct.getRoles() != null || ct.getTransport() != null) {
            if (this.debug > 0) {
                this.log("addContainer() " + ctx.getHost() + " " + ctx.getPath() + " " + ct.getPath());
            }
            ctxSecurityC.addContainer(ct);
        }
    }

    public int requestMap(Request req) {
        String ctxPath;
        int ctxPathLen;
        Context ctx = req.getContext();
        SecurityConstraints ctxSec = (SecurityConstraints)ctx.getContainer().getNote(this.secMapNote);
        MessageBytes reqURIMB = req.requestURI();
        if (reqURIMB.startsWithIgnoreCase("/META-INF", ctxPathLen = (ctxPath = ctx.getPath()).length()) || reqURIMB.startsWithIgnoreCase("/WEB-INF", ctxPathLen)) {
            req.setAttribute("javax.servlet.error.message", (Object)"Forbidden directory");
            return 403;
        }
        if (ctxSec == null || ctxSec.patterns == 0) {
            return 0;
        }
        String reqURI = req.requestURI().toString();
        String path = reqURI.substring(ctxPathLen);
        String method = req.method().toString();
        if (this.debug > 1) {
            this.log("checking " + path);
        }
        int i = 0;
        while (i < ctxSec.patterns) {
            Container ct = ctxSec.securityPatterns[i];
            if (this.match(ct, path, method)) {
                req.setSecurityContext(ct);
                String[] roles = ct.getRoles();
                String[] methods = ct.getMethods();
                String transport = ct.getTransport();
                if (this.debug > 0) {
                    StringBuffer sb = new StringBuffer("matched ");
                    sb.append(ct.getPath()).append(" ");
                    if (methods != null) {
                        int j = 0;
                        while (j < methods.length) {
                            sb.append(methods[j]).append(" ");
                            ++j;
                        }
                    }
                    sb.append(transport).append(" ");
                    if (roles != null) {
                        int j = 0;
                        while (j < roles.length) {
                            sb.append(roles[j]).append(" ");
                            ++j;
                        }
                    }
                    this.log(sb.toString());
                }
                if (transport != null && !"NONE".equals(transport)) {
                    req.setNote(this.reqTransportNote, (Object)transport);
                }
                if (roles != null && roles.length > 0) {
                    req.setRequiredRoles(roles);
                }
            }
            ++i;
        }
        return 0;
    }

    public int authorize(Request req, Response response, String[] roles) {
        String[] userRoles;
        if (req.getSecurityContext() == null && roles == null) {
            return 0;
        }
        if (roles == null) {
            roles = req.getSecurityContext().getRoles();
        }
        String transp = null;
        if (req.getSecurityContext() != null) {
            transp = (String)req.getNote(this.reqTransportNote);
        }
        if (this.debug > 0) {
            this.log("Transport " + transp);
        }
        if (("CONFIDENTIAL".equalsIgnoreCase(transp) || "INTEGRAL".equalsIgnoreCase(transp)) && !req.scheme().equals("https")) {
            response.setContentType("text/html");
            response.setStatus(403);
            req.setAttribute("javax.servlet.error.message", (Object)"Invalid transport, CONFIDENTIAL required");
            return 403;
        }
        if (roles == null || roles.length == 0) {
            return 0;
        }
        String user = req.getRemoteUser();
        if (user == null) {
            return -1;
        }
        if (this.debug > 0) {
            this.log("Controled access for " + user + " " + req + " " + req.getContainer());
        }
        if ((userRoles = req.getUserRoles()) == null) {
            return -1;
        }
        int i = 0;
        while (i < userRoles.length) {
            int j = 0;
            while (j < roles.length) {
                if (userRoles[i] != null && userRoles[i].equals(roles[j])) {
                    return 0;
                }
                ++j;
            }
            ++i;
        }
        if (this.debug > 0) {
            this.log("UnAuthorized " + roles[0]);
        }
        return -1;
    }

    boolean match(Container ct, String path, String method) {
        int i;
        String ctPath = ct.getPath();
        int ctPathL = ctPath.length();
        String[] ctMethods = ct.getMethods();
        if (ctMethods != null && ctMethods.length > 0) {
            boolean ok = false;
            i = 0;
            while (i < ctMethods.length) {
                if (method.equalsIgnoreCase(ctMethods[i])) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                return false;
            }
        }
        switch (ct.getMapType()) {
            case 2: {
                if (path.length() < ctPathL - 2) {
                    return false;
                }
                int matchLen = ctPathL - 2;
                if (path.length() > matchLen) {
                    ++matchLen;
                }
                if (this.ignoreCase) {
                    i = 0;
                    while (i < matchLen) {
                        if (Ascii.toLower((int)path.charAt(i)) != Ascii.toLower((int)ctPath.charAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < matchLen) {
                        if (path.charAt(i) != ctPath.charAt(i)) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
            case 3: {
                if (this.ignoreCase) {
                    return ctPath.substring(1).equalsIgnoreCase(FileUtil.getExtension((String)path));
                }
                return ctPath.substring(1).equals(FileUtil.getExtension((String)path));
            }
            case 1: {
                if (this.ignoreCase) {
                    return path.equalsIgnoreCase(ctPath);
                }
                return path.equals(ctPath);
            }
        }
        return false;
    }
}

