/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;

public class AutoWebApp
extends BaseInterceptor {
    int debug = 0;
    Hashtable hosts = new Hashtable();
    String appsD = "webapps";
    String defaultHost = null;
    boolean flat = true;
    boolean ignoreDot = true;
    String profile = null;
    boolean trusted = false;
    String prefix = "";
    boolean reloadable = true;
    char hostSeparator = (char)64;
    char dotReplacement = (char)95;
    char slashReplacement = (char)95;

    public void setDir(String d) {
        this.appsD = d;
    }

    public void setPrefix(String s) {
        this.prefix = s;
    }

    public void setHost(String h) {
        this.defaultHost = h;
    }

    public void setIngoreDot(boolean b) {
        this.ignoreDot = b;
    }

    public void setFlat(boolean b) {
        this.flat = b;
    }

    public void setProfile(String s) {
        this.profile = s;
    }

    public void setTrusted(boolean b) {
        this.trusted = b;
    }

    public void setReloadable(boolean b) {
        this.reloadable = b;
    }

    public void setHostChar(String c) {
        this.hostSeparator = c.length() > 0 ? c.charAt(0) : (char)'\u0000';
    }

    public void setHostDotChar(String c) {
        this.dotReplacement = c.length() > 0 ? c.charAt(0) : (char)'\u0000';
    }

    public void setPathSlashChar(String c) {
        this.slashReplacement = c.length() > 0 ? c.charAt(0) : (char)'\u0000';
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        Enumeration loadedCtx = cm.getContexts();
        while (loadedCtx.hasMoreElements()) {
            Hashtable<String, Context> loaded;
            Context ctx = (Context)loadedCtx.nextElement();
            String host = ctx.getHost();
            if (host == null) {
                host = "DEFAULT";
            }
            if ((loaded = (Hashtable<String, Context>)this.hosts.get(host)) == null) {
                loaded = new Hashtable<String, Context>();
                this.hosts.put(host, loaded);
            }
            loaded.put(ctx.getPath(), ctx);
        }
        File webappD = new File(this.appsD);
        if (!webappD.isAbsolute()) {
            webappD = new File(cm.getHome(), this.appsD);
        }
        if (!webappD.exists() || !webappD.isDirectory()) {
            this.log("No autoconf directory " + webappD);
            return;
        }
        String[] list = webappD.list();
        if (this.flat) {
            int i = 0;
            while (i < list.length) {
                File f;
                String name = list[i];
                if (!(this.ignoreDot && name.startsWith(".") || !(f = new File(webappD, name)).isDirectory())) {
                    int idx;
                    String appHost = this.defaultHost;
                    if (this.defaultHost == null && (idx = name.indexOf(this.hostSeparator)) > 0) {
                        appHost = name.substring(0, idx);
                        name = name.substring(idx + 1);
                    }
                    if (appHost == null) {
                        appHost = "DEFAULT";
                    }
                    this.addWebApp(cm, f, appHost, name);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < list.length) {
                String name = list[i];
                File f = new File(webappD, name);
                if (!(!f.isDirectory() || this.ignoreDot && name.startsWith("."))) {
                    this.addVHost(cm, webappD, name);
                }
                ++i;
            }
        }
    }

    private void addWebApp(ContextManager cm, File dir, String host, String name) throws TomcatException {
        Hashtable loaded;
        String path;
        if ((host = this.unEscapeHost(host)) == null) {
            host = "DEFAULT";
        }
        if ((path = "/" + this.unEscapePath(name)).equals("/ROOT")) {
            path = "";
        }
        if ((loaded = (Hashtable)this.hosts.get(host)) != null && loaded.get(path) != null) {
            this.log("Loaded from config: " + host + ":" + ("".equals(path) ? "/" : path));
            return;
        }
        this.log("Auto-Adding " + host + ":" + ("".equals(path) ? "/" : path));
        if (dir.isDirectory()) {
            Context ctx = cm.createContext();
            ctx.setContextManager(cm);
            ctx.setPath(this.prefix + path);
            ctx.setReloadable(this.reloadable);
            if (!"DEFAULT".equals(host)) {
                ctx.setHost(host);
            }
            try {
                ctx.setDocBase(dir.getCanonicalPath());
            }
            catch (IOException ex) {
                ctx.setDocBase(dir.getAbsolutePath());
            }
            if (this.trusted) {
                ctx.setTrusted(true);
            }
            if (this.profile != null) {
                ctx.setProperty("profile", this.profile);
            }
            if (this.debug > 0) {
                this.log("automatic add " + host + ":" + ctx.toString() + " " + path);
            }
            cm.addContext(ctx);
        } else {
            this.log("Not a dir " + dir.getAbsolutePath());
        }
    }

    private void addVHost(ContextManager cm, File dir, String host) throws TomcatException {
        File webappD = new File(dir, host);
        String[] list = webappD.list();
        if (list.length == 0) {
            this.log("No contexts in " + webappD);
        }
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            File f = new File(webappD, name);
            if (f.isDirectory()) {
                this.addWebApp(cm, webappD, host, name);
            }
            ++i;
        }
    }

    private String unEscapeHost(String hostName) {
        return this.unEscapeString(hostName, this.dotReplacement, '.');
    }

    private String unEscapePath(String pathDir) {
        return this.unEscapeString(pathDir, this.slashReplacement, '/');
    }

    private String unEscapeString(String s, char esc, char repl) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == esc) {
                if (len > i + 1 && s.charAt(i + 1) == esc) {
                    ++i;
                    sb.append(esc);
                } else {
                    sb.append(repl);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

