/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.BaseJkConfig;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.log.Log;

public class NSConfig
extends BaseJkConfig {
    public static final String WORKERS_CONFIG = "conf/jk/workers.properties";
    public static final String NS_CONFIG = "conf/auto/obj.conf";
    public static final String NSAPI_LOG_LOCATION = "logs/nsapi_redirect.log";
    public static String NSAPI_REDIRECTOR;
    private File objConfig = null;
    private File nsapiJk = null;
    private String objectName = "servlet";
    Log loghelper = Log.getLog((String)"tc_log", (Object)((Object)this));

    public void setObjConfig(String path) {
        this.objConfig = path == null ? null : new File(path);
    }

    public void setNsapiJk(String path) {
        this.nsapiJk = path == null ? null : new File(path);
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    protected void initProperties(ContextManager cm) {
        super.initProperties(cm);
        this.objConfig = FileUtil.getConfigFile((File)this.objConfig, (File)this.configHome, (String)NS_CONFIG);
        this.workersConfig = FileUtil.getConfigFile((File)this.workersConfig, (File)this.configHome, (String)WORKERS_CONFIG);
        this.nsapiJk = this.nsapiJk == null ? new File(NSAPI_REDIRECTOR) : FileUtil.getConfigFile((File)this.nsapiJk, (File)this.configHome, (String)NSAPI_REDIRECTOR);
        this.jkLog = FileUtil.getConfigFile((File)this.jkLog, (File)this.configHome, (String)NSAPI_LOG_LOCATION);
    }

    public void execute(ContextManager cm) throws TomcatException {
        try {
            this.initProperties(cm);
            this.initWorker(cm);
            PrintWriter objfile = new PrintWriter(new FileWriter(this.objConfig));
            this.log("Generating netscape web server config = " + this.objConfig);
            this.generateNsapiHead(objfile);
            objfile.println("<Object name=default>");
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String vhost = context.getHost();
                if (vhost != null) continue;
                if (this.forwardAll) {
                    this.generateStupidMappings(context, objfile);
                    continue;
                }
                this.generateContextMappings(context, objfile);
            }
            this.generateNsapiTail(objfile);
            objfile.close();
        }
        catch (Exception ex) {
            this.loghelper.log("Error generating automatic Netscape configuration", (Throwable)ex);
        }
    }

    private void generateNsapiHead(PrintWriter objfile) throws TomcatException {
        objfile.println("###################################################################");
        objfile.println("# Auto generated configuration. Dated: " + new Date());
        objfile.println("###################################################################");
        objfile.println();
        objfile.println("#");
        objfile.println("# You will need to merge the content of this file with your ");
        objfile.println("# regular obj.conf and then restart (=stop + start) your Netscape server. ");
        objfile.println("#");
        objfile.println();
        objfile.println("#");
        objfile.println("# Loading the redirector into your server");
        objfile.println("#");
        objfile.println();
        objfile.println("Init fn=\"load-modules\" funcs=\"jk_init,jk_service\" shlib=\"<put full path to the redirector here>\"");
        objfile.println("Init fn=\"jk_init\" worker_file=\"" + this.workersConfig.toString().replace('\\', '/') + "\" log_level=\"" + this.jkDebug + "\" log_file=\"" + this.jkLog.toString().replace('\\', '/') + "\"");
        objfile.println();
    }

    private void generateNsapiTail(PrintWriter objfile) throws TomcatException {
        objfile.println();
        objfile.println("#######################################################");
        objfile.println("# Protecting the WEB-INF and META-INF directories.");
        objfile.println("#######################################################");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/WEB-INF\"");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/WEB-INF/*\"");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/META-INF\"");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/META-INF/*\"");
        objfile.println();
        objfile.println("</Object>");
        objfile.println();
        objfile.println("#######################################################");
        objfile.println("# New object to execute your servlet requests.");
        objfile.println("#######################################################");
        objfile.println("<Object name=" + this.objectName + ">");
        objfile.println("ObjectType fn=force-type type=text/html");
        objfile.println("Service fn=\"jk_service\" worker=\"" + this.jkWorker + "\" path=\"/*\"");
        objfile.println("</Object>");
        objfile.println();
        if (!this.forwardAll) {
            objfile.println("#######################################################");
            objfile.println("# New object to execute URLs containing \";jsessionid=\"");
            objfile.println("#######################################################");
            objfile.println("<Object ppath=\"*;jsessionid=*\">");
            objfile.println("ObjectType fn=force-type type=text/html");
            objfile.println("Service fn=\"jk_service\" worker=\"" + this.jkWorker + "\" path=\"/*\"");
            objfile.println("</Object>");
            objfile.println();
        }
    }

    private void generateStupidMappings(Context context, PrintWriter objfile) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + "\" name=\"" + this.objectName + "\"");
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + "/*\" name=\"" + this.objectName + "\"");
    }

    private void generateContextMappings(Context context, PrintWriter objfile) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in non-forward-all mode  ");
            return;
        }
        objfile.println("#########################################################");
        objfile.println("# Auto configuration for the " + nPath + " context starts.");
        objfile.println("#########################################################");
        objfile.println();
        this.addMapping(ctxPath + "/servlet/*", objfile);
        Enumeration servletMaps = context.getContainers();
        while (servletMaps.hasMoreElements()) {
            Container ct = (Container)servletMaps.nextElement();
            this.addMapping(context, ct, objfile);
        }
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter objfile) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + "/*." + ext + "\" name=\"" + this.objectName + "\"");
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter objfile) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        if (fullPath.endsWith("/*")) {
            objfile.println("NameTrans fn=\"assign-name\" from=\"" + fullPath.substring(0, fullPath.length() - 2) + "\" name=\"" + this.objectName + "\"");
        }
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + fullPath + "\" name=\"" + this.objectName + "\"");
        return true;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        NSAPI_REDIRECTOR = os.indexOf("windows") >= 0 ? "bin/nsapi_redirect.dll" : (os.indexOf("netware") >= 0 ? "bin/nsapi_rd.nlm" : "bin/nsapi_redirector.so");
    }
}

