/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.res.StringManager;

class RedirectHandler
extends Handler {
    static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    int sbNote = 0;
    int defaultRedirectStatus = 301;

    RedirectHandler(BaseInterceptor bi) {
        this.name = "tomcat.redirectHandler";
        this.setModule(bi);
    }

    public void setDefaultRedirectStatus(int status) {
        this.defaultRedirectStatus = status;
    }

    public void doService(Request req, Response res) throws Exception {
        StringBuffer buf;
        String location = (String)req.getAttribute("javax.servlet.error.message");
        Context ctx = req.getContext();
        if (res.getStatus() != 301 && res.getStatus() != 302) {
            res.setStatus(this.defaultRedirectStatus);
        }
        location = this.makeAbsolute(req, location);
        if (this.debug > 0) {
            ctx.log("Redirect " + location + " " + req);
        }
        res.setContentType("text/html");
        res.setHeader("Location", location);
        if (this.sbNote == 0) {
            this.sbNote = req.getContextManager().getNoteId(2, "RedirectHandler.buff");
        }
        if ((buf = (StringBuffer)req.getNote(this.sbNote)) == null) {
            buf = new StringBuffer();
            req.setNote(this.sbNote, (Object)buf);
        }
        buf.append("<html><head><title>").append(sm.getString("defaulterrorpage.documentmoved")).append("</title></head>\r\n<body><h1>").append(sm.getString("defaulterrorpage.documentmoved")).append("</h1>\r\n").append(sm.getString("defaulterrorpage.thisdocumenthasmoved")).append(" <a href=\"").append(HttpMessages.filter((String)location)).append("\">here</a>.<p>\r\n</body>\r\n</html>");
        res.setContentLength(buf.length());
        res.getBuffer().write(buf);
        res.getBuffer().close();
        buf.setLength(0);
    }

    private String makeAbsolute(Request req, String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            String requrl = RedirectHandler.getRequestURL(req);
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException ignored) {
                return location;
            }
        }
        return url.toString();
    }

    static String getRequestURL(Request req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.scheme().toString();
        int port = req.getServerPort();
        String urlPath = req.requestURI().toString();
        url.append(scheme);
        url.append("://");
        url.append(req.serverName().toString());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(urlPath);
        return url.toString();
    }
}

