/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.io.File;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.generators.DirHandler;
import org.apache.tomcat.modules.generators.FileHandler;
import org.apache.tomcat.util.io.FileUtil;

public class StaticInterceptor
extends BaseInterceptor {
    int realFileNote = -1;
    boolean useAcceptLanguage = true;
    String charset = null;
    private boolean extraSafety = false;
    private boolean listings = true;

    public boolean getListings() {
        return this.listings;
    }

    public void setListings(boolean listings) {
        this.listings = listings;
    }

    public void setUseAcceptLanguage(boolean use) {
        this.useAcceptLanguage = use;
    }

    public void setUseCharset(String charset) {
        this.charset = charset;
    }

    public void setExtraSafety(boolean safe) {
        this.extraSafety = safe;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        try {
            this.realFileNote = cm.getNoteId(2, "static.realFile");
        }
        catch (TomcatException ex) {
            this.log("getting note for " + cm, ex);
            throw new RuntimeException("Invalid state ");
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        FileHandler fileHandler = new FileHandler();
        DirHandler dirHandler = new DirHandler();
        fileHandler.setModule(this);
        fileHandler.setContext(ctx);
        fileHandler.setNoteId(this.realFileNote);
        fileHandler.setExtraSafety(this.extraSafety);
        ctx.addServlet((Handler)fileHandler);
        dirHandler.setNoteId(this.realFileNote);
        dirHandler.setContext(ctx);
        dirHandler.setModule(this);
        dirHandler.setUseAcceptLanguage(this.useAcceptLanguage);
        dirHandler.setCharset(this.charset);
        if (this.listings) {
            ctx.addServlet((Handler)dirHandler);
        }
    }

    public int requestMap(Request req) {
        File file;
        if (req.getHandler() != null) {
            return 0;
        }
        Context ctx = req.getContext();
        String pathInfo = req.servletPath().toString();
        if (pathInfo == null) {
            pathInfo = "";
        }
        String absPath = FileUtil.safePath((String)ctx.getAbsolutePath(), (String)pathInfo);
        if (this.debug > 0) {
            this.log("RequestMap " + req + " " + absPath + " " + ctx.getAbsolutePath());
        }
        if (absPath == null) {
            return 0;
        }
        String requestURI = req.requestURI().toString();
        if (this.debug > 0) {
            this.log("Requested: " + absPath);
        }
        if ((file = new File(absPath)).isFile()) {
            if (this.debug > 0) {
                this.log("Setting handler to file " + absPath);
            }
            req.setNote(this.realFileNote, (Object)absPath);
            req.setHandler(ctx.getServletByName("tomcat.fileHandler"));
            return 0;
        }
        if (!file.isDirectory()) {
            if (this.debug > 0) {
                this.log("No file and no directory");
            }
            return 0;
        }
        String welcomeFile = this.getWelcomeFile(ctx, file);
        if (this.debug > 0) {
            this.log("DefaultServlet: welcome file: " + welcomeFile);
        }
        if (welcomeFile == null && !requestURI.endsWith("/")) {
            String redirectURI = requestURI + "/";
            redirectURI = this.fixURLRewriting(req, redirectURI);
            req.setAttribute("javax.servlet.error.message", (Object)redirectURI);
            if (this.debug > 0) {
                this.log("Redirect " + redirectURI);
            }
            req.setHandler(ctx.getServletByName("tomcat.redirectHandler"));
            return 0;
        }
        if (welcomeFile == null) {
            req.setHandler(ctx.getServletByName("tomcat.dirHandler"));
            if (this.debug > 0) {
                this.log("Dir handler");
            }
            return 0;
        }
        String redirectURI = null;
        redirectURI = StaticInterceptor.concatPath(requestURI, welcomeFile);
        redirectURI = this.fixURLRewriting(req, redirectURI);
        req.setAttribute("javax.servlet.error.message", (Object)redirectURI);
        if (this.debug > 0) {
            this.log("Redirect " + redirectURI);
        }
        req.setHandler(ctx.getServletByName("tomcat.redirectHandler"));
        return 0;
    }

    private String fixURLRewriting(Request req, String redirectURI) {
        ServerSession session = req.getSession(false);
        if (session != null && "url".equals(req.getSessionIdSource())) {
            String id = ";jsessionid=" + req.getSessionId();
            redirectURI = redirectURI + id;
        }
        return redirectURI;
    }

    private static String concatPath(String s1, String s2) {
        if (s1.endsWith("/")) {
            if (s2.startsWith("/")) {
                return s1 + s2.substring(1);
            }
            return s1 + s2;
        }
        if (s2.startsWith("/")) {
            return s1 + s2;
        }
        return s1 + "/" + s2;
    }

    private String getWelcomeFile(Context context, File dir) {
        String[] wf = context.getWelcomeFiles();
        int i = 0;
        while (i < wf.length) {
            File f = new File(dir, wf[i]);
            if (f.exists()) {
                return wf[i];
            }
            ++i;
        }
        return null;
    }
}

