/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.loggers;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.hooks.Hooks;

public class LogEvents
extends BaseInterceptor {
    boolean enabled = false;

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public int registerHooks(Hooks hooks, ContextManager cm, Context ctx) {
        if (this.enabled || cm.getDebug() > 5) {
            this.enabled = true;
            this.log("Adding LogEvents, cm.debug=" + cm.getDebug() + " " + this.enabled);
            hooks.addModule((Object)this);
        }
        return 0;
    }

    public int requestMap(Request request) {
        this.log("requestMap " + request);
        return 0;
    }

    public int contextMap(Request request) {
        this.log("contextMap " + request);
        return 0;
    }

    public int preService(Request request, Response response) {
        this.log("preService " + request);
        return 0;
    }

    public int authenticate(Request request, Response response) {
        this.log("authenticate " + request);
        return -1;
    }

    public int authorize(Request request, Response response, String[] reqRoles) {
        StringBuffer sb = new StringBuffer();
        this.appendSA(sb, reqRoles, " ");
        this.log("authorize " + request + " " + sb.toString());
        return -1;
    }

    public int beforeBody(Request request, Response response) {
        this.log("beforeBody " + request);
        return 0;
    }

    public int beforeCommit(Request request, Response response) {
        this.log("beforeCommit " + request);
        return 0;
    }

    public int afterBody(Request request, Response response) {
        this.log("afterBody " + request);
        return 0;
    }

    public int postRequest(Request request, Response response) {
        this.log("postRequest " + request);
        return 0;
    }

    public int handleError(Request request, Response response, Throwable t) {
        this.log("handleError " + request + " " + t);
        return 0;
    }

    public int postService(Request request, Response response) {
        this.log("postService " + request);
        return 0;
    }

    public int newSessionRequest(Request req, Response res) {
        this.log("newSessionRequest " + req);
        return 0;
    }

    public void contextInit(Context ctx) throws TomcatException {
        this.log("contextInit " + ctx);
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        this.log("contextShutdown " + ctx);
    }

    public void addServlet(Context ctx, Handler sw) throws TomcatException {
        this.log("addServlet " + ctx + " " + sw);
    }

    public void removeServlet(Context ctx, Handler sw) throws TomcatException {
        this.log("removeServlet " + ctx + " " + sw);
    }

    public void addMapping(Context ctx, String path, Handler servlet) throws TomcatException {
        this.log("addMapping " + ctx + " " + path + "->" + servlet);
    }

    public void removeMapping(Context ctx, String path) throws TomcatException {
        this.log("removeMapping " + ctx + " " + path);
    }

    private void appendSA(StringBuffer sb, String[] s, String sep) {
        int i = 0;
        while (i < s.length) {
            sb.append(sep).append(s[i]);
            ++i;
        }
    }

    public void addSecurityConstraint(Context ctx, String[] path, String[] methods, String transport, String[] roles) throws TomcatException {
        StringBuffer sb = new StringBuffer();
        sb.append("addSecurityConstraint " + ctx + " ");
        if (methods != null) {
            sb.append("Methods: ");
            this.appendSA(sb, methods, " ");
        }
        if (path != null) {
            sb.append(" Paths: ");
            this.appendSA(sb, path, " ");
        }
        if (roles != null) {
            sb.append(" Roles: ");
            this.appendSA(sb, roles, " ");
        }
        sb.append(" Transport " + transport);
        this.log(sb.toString());
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor i) throws TomcatException {
        if (!this.enabled) {
            return;
        }
        if (ctx == null) {
            this.log("addInterceptor " + i);
        } else {
            this.log("addInterceptor " + ctx + " " + i);
        }
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.log("engineInit ");
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        this.log("engineShutdown ");
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        this.log("addContext " + ctx);
    }

    public void addContainer(Container ct) throws TomcatException {
        if (this.debug > 0) {
            this.log("addContainer " + ct.getContext() + " " + ct);
        }
    }

    public void engineState(ContextManager cm, int state) throws TomcatException {
        this.log("engineState " + state);
    }

    public void engineStart(ContextManager cm) throws TomcatException {
        this.log("engineStart ");
    }

    public void removeContext(ContextManager cm, Context ctx) throws TomcatException {
        this.log("removeContext" + ctx);
    }

    public void preServletInit(Context ctx, Handler sw) throws TomcatException {
        this.log("preServletInit " + ctx + " " + sw);
    }

    public void postServletInit(Context ctx, Handler sw) throws TomcatException {
        this.log("postServletInit " + ctx + " " + sw);
    }

    public void preServletDestroy(Context ctx, Handler sw) throws TomcatException {
        this.log("preServletDestroy " + ctx + " " + sw);
    }

    public void postServletDestroy(Context ctx, Handler sw) throws TomcatException {
        this.log("postServletDestroy " + ctx + " " + sw);
    }
}

