/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.mappers;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.collections.SimpleHashtable;
import org.apache.tomcat.util.io.FileUtil;

class PrefixMapper {
    private static int debug = 1;
    Hashtable vhostMaps = new Hashtable();
    Hashtable vhostMapsWC = new Hashtable();
    boolean hasWCMap = false;
    Hashtable prefixMappedServlets = new Hashtable();
    Hashtable exactMappedServlets = new Hashtable();
    SimpleHashtable mapCache = new SimpleHashtable();
    boolean mapCacheEnabled = false;
    boolean ignoreCase = false;

    public void setMapCache(boolean v) {
        this.mapCacheEnabled = v;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public void removeAllMappings(String host, Context ctx) {
        Container ct;
        String s;
        PrefixMapper vmap = this;
        if (host != null) {
            vmap = (host = host.toLowerCase()).startsWith("*") ? (PrefixMapper)this.vhostMapsWC.get(host.substring(1)) : (PrefixMapper)this.vhostMaps.get(host);
        }
        Enumeration en = vmap.prefixMappedServlets.keys();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            ct = (Container)vmap.prefixMappedServlets.get(s);
            if (ct == null || ct.getContext() != ctx) continue;
            if (debug > 0) {
                ctx.log("Remove mapping " + s);
            }
            vmap.prefixMappedServlets.remove(s);
        }
        en = vmap.exactMappedServlets.keys();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            ct = (Container)vmap.exactMappedServlets.get(s);
            if (ct.getContext() != ctx) continue;
            if (debug > 0) {
                ctx.log("Remove mapping " + s);
            }
            vmap.exactMappedServlets.remove(s);
        }
        this.mapCache = new SimpleHashtable();
    }

    void addMapping(String path, Object target) {
        this.prefixMappedServlets.put(path, target);
    }

    void addExactMapping(String path, Object target) {
        this.exactMappedServlets.put(path, target);
    }

    public void addMapping(String host, String path, Object target) {
        if (host == null) {
            if (this.ignoreCase) {
                this.prefixMappedServlets.put(path.toLowerCase(), target);
            } else {
                this.prefixMappedServlets.put(path, target);
            }
        } else {
            Hashtable maps;
            if ((host = host.toLowerCase()).startsWith("*")) {
                maps = this.vhostMapsWC;
                host = host.substring(1);
                this.hasWCMap = true;
            } else {
                maps = this.vhostMaps;
            }
            PrefixMapper vmap = (PrefixMapper)maps.get(host);
            if (vmap == null) {
                vmap = new PrefixMapper();
                vmap.setIgnoreCase(this.ignoreCase);
                maps.put(host, vmap);
                vmap.setMapCache(this.mapCacheEnabled);
            }
            if (this.ignoreCase) {
                vmap.addMapping(path.toLowerCase(), target);
            } else {
                vmap.addMapping(path, target);
            }
        }
    }

    public void addMappings(Enumeration hostAliases, String path, Object target) {
        while (hostAliases.hasMoreElements()) {
            this.addMapping((String)hostAliases.nextElement(), path, target);
        }
    }

    public void addExactMapping(String host, String path, Object target) {
        if (host == null) {
            if (this.ignoreCase) {
                this.exactMappedServlets.put(path.toLowerCase(), target);
            } else {
                this.exactMappedServlets.put(path, target);
            }
        } else {
            Hashtable maps;
            if ((host = host.toLowerCase()).startsWith("*")) {
                maps = this.vhostMapsWC;
                host = host.substring(1);
                this.hasWCMap = true;
            } else {
                maps = this.vhostMaps;
            }
            PrefixMapper vmap = (PrefixMapper)maps.get(host);
            if (vmap == null) {
                vmap = new PrefixMapper();
                maps.put(host, vmap);
            }
            if (this.ignoreCase) {
                vmap.addExactMapping(path.toLowerCase(), target);
            } else {
                vmap.addExactMapping(path, target);
            }
        }
    }

    public void addExactMappings(Enumeration hostAliases, String path, Object target) {
        while (hostAliases.hasMoreElements()) {
            this.addExactMapping((String)hostAliases.nextElement(), path, target);
        }
    }

    public Object getLongestPrefixMatch(MessageBytes hostMB, MessageBytes pathMB) {
        String host = hostMB.toString();
        String path = pathMB.toString();
        Object container = null;
        PrefixMapper myMap = null;
        if (host != null && (myMap = (PrefixMapper)this.vhostMaps.get(host)) == null) {
            myMap = (PrefixMapper)this.vhostMaps.get(host.toLowerCase());
        }
        if (myMap == null && this.hasWCMap) {
            Enumeration vhosts = this.vhostMapsWC.keys();
            while (vhosts.hasMoreElements()) {
                String vhostName = (String)vhosts.nextElement();
                if (!host.endsWith(vhostName)) continue;
                myMap = (PrefixMapper)this.vhostMapsWC.get(vhostName);
                break;
            }
        }
        if (myMap == null) {
            myMap = this;
        }
        if (this.ignoreCase) {
            path = path.toLowerCase();
        }
        if ((container = (Object)myMap.exactMappedServlets.get(path)) != null) {
            return container;
        }
        if (myMap.mapCacheEnabled && (container = myMap.mapCache.get(path)) != null) {
            return container;
        }
        String s = path;
        while (s.length() >= 0) {
            container = myMap.prefixMappedServlets.get(s);
            if (container == null) {
                if (s.length() == 0) break;
                s = FileUtil.removeLast((String)s);
                continue;
            }
            if (myMap.mapCacheEnabled) {
                myMap.mapCache.put((Object)path, container);
            }
            return container;
        }
        return container;
    }
}

