/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.mappers;

import java.io.File;
import java.util.Enumeration;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.mappers.PrefixMapper;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.collections.SimpleHashtable;
import org.apache.tomcat.util.io.FileUtil;

public class SimpleMapper1
extends BaseInterceptor {
    ContextManager cm;
    PrefixMapper map = new PrefixMapper();
    int ctExtMapNote = -1;
    int defaultMapNOTE = -1;
    boolean mapCacheEnabled = false;
    boolean ignoreCase = File.separatorChar == '\\';

    public SimpleMapper1() {
        this.map.setIgnoreCase(this.ignoreCase);
    }

    public void setMapCache(boolean v) {
        this.mapCacheEnabled = v;
        this.map.setMapCache(v);
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
        this.map.setIgnoreCase(b);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.cm = cm;
        this.ctExtMapNote = cm.getNoteId(1, "map.extension");
        this.defaultMapNOTE = cm.getNoteId(1, "tomcat.map.default");
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        this.map.addMapping(ctx.getHost(), ctx.getPath(), ctx.getContainer());
        this.map.addMappings(ctx.getHostAliases(), ctx.getPath(), ctx.getContainer());
    }

    public void removeContext(ContextManager cm, Context ctx) throws TomcatException {
        if (this.debug > 0) {
            this.log("Removed from maps ");
        }
        this.map.removeAllMappings(ctx.getHost(), ctx);
        Enumeration vhostAliases = ctx.getHostAliases();
        while (vhostAliases.hasMoreElements()) {
            this.map.removeAllMappings((String)vhostAliases.nextElement(), ctx);
        }
    }

    public void addContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        String vhost = ctx.getHost();
        Enumeration vhostAliases = ctx.getHostAliases();
        String path = ct.getPath();
        String ctxP = ctx.getPath();
        if (ct.isSpecial()) {
            return;
        }
        if (ct.getNote("type") != null) {
            return;
        }
        if (ct.getRoles() != null || ct.getTransport() != null) {
            return;
        }
        switch (ct.getMapType()) {
            case 2: {
                if (!path.startsWith("/")) {
                    this.log("WARNING: Correcting error in web.xml for context \"" + ctxP + "\". Mapping for path \"" + path + "\" is missing a leading '/'.");
                    path = "/" + path;
                }
                String prefixPath = ctxP + path.substring(0, path.length() - 2);
                this.map.addMapping(vhost, prefixPath, ct);
                this.map.addMappings(vhostAliases, prefixPath, ct);
                if (this.debug <= 0) break;
                this.log("SM: prefix map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
                break;
            }
            case 4: {
                Container defMapC = ct.getContext().getContainer();
                defMapC.setNote(this.defaultMapNOTE, (Object)ct);
                if (this.debug <= 0) break;
                this.log("SM: default map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
                break;
            }
            case 3: {
                Context mapCtx = ct.getContext();
                Container defC = mapCtx.getContainer();
                SimpleHashtable eM = (SimpleHashtable)defC.getNote(this.ctExtMapNote);
                if (eM == null) {
                    eM = new SimpleHashtable();
                    defC.setNote(this.ctExtMapNote, (Object)eM);
                }
                if (this.ignoreCase) {
                    eM.put((Object)path.substring(1).toLowerCase(), (Object)ct);
                } else {
                    eM.put((Object)path.substring(1), (Object)ct);
                }
                if (this.debug <= 0) break;
                this.log("SM: extension map " + ctxP + "/" + path + " " + ct + " ");
                break;
            }
            case 1: {
                if (!path.startsWith("/")) {
                    this.log("WARNING: Correcting error in web.xml for context \"" + ctxP + "\". Mapping for path \"" + path + "\" is missing a leading '/'.");
                    path = "/" + path;
                }
                this.map.addExactMapping(vhost, ctxP + path, ct);
                this.map.addExactMappings(vhostAliases, ctxP + path, ct);
                if (this.debug <= 0) break;
                this.log("SM: exact map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
            }
        }
    }

    public void removeContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        String mapping = ct.getPath();
        String ctxP = ctx.getPath();
        mapping = mapping.trim();
        if (this.debug > 0) {
            this.log("Remove mapping " + mapping);
        }
    }

    public int contextMap(Request req) {
        MessageBytes pathMB = req.requestURI();
        try {
            Container ctxDef;
            Container defC;
            Container extC;
            Container container;
            MessageBytes hostMB = req.serverName();
            if (this.debug > 0) {
                this.cm.log("Host = " + hostMB.toString());
            }
            if ((container = (Container)this.map.getLongestPrefixMatch(hostMB, pathMB)) == null) {
                this.cm.log("Assertion failed: container==null (no Default Context?)");
                return 404;
            }
            if (this.debug > 0) {
                this.cm.log("SM: Prefix match " + pathMB.toString() + " -> " + container.getPath() + " " + container.getHandler() + " " + container.getRoles());
            }
            this.fixRequestPaths(pathMB.toString(), req, container);
            if (container.getHandler() == null && (extC = this.matchExtension(req)) != null) {
                if (extC.getHandler() != null) {
                    this.fixRequestPaths(pathMB.toString(), req, extC);
                    container = extC;
                }
                if (this.debug > 0) {
                    this.log("SM: Found extension mapping " + extC.getHandler());
                }
            }
            if (container.getHandler() == null && (defC = (Container)(ctxDef = req.getContext().getContainer()).getNote(this.defaultMapNOTE)) != null && defC.getHandler() != null) {
                this.fixRequestPaths(pathMB.toString(), req, defC);
                if (this.debug > 0) {
                    this.log("SM: Found default mapping " + defC.getHandler() + " " + defC.getPath() + " " + defC.getMapType());
                }
            }
            if (this.debug > 0) {
                this.log("SM: After mapping " + req + " " + req.getHandler());
            }
        }
        catch (Exception ex) {
            this.log("Mapping " + req, ex);
            return 500;
        }
        return 0;
    }

    Container matchExtension(Request req) {
        Container container;
        SimpleHashtable extM;
        Context ctx = req.getContext();
        String ctxP = ctx.getPath();
        String path = req.servletPath().toString();
        if (path == null) {
            return null;
        }
        String extension = FileUtil.getExtension((String)path);
        if (extension == null) {
            return null;
        }
        if (this.debug > 0) {
            this.cm.log("SM: Extension match " + ctxP + " " + path + " " + extension);
        }
        if ((extM = (SimpleHashtable)ctx.getContainer().getNote(this.ctExtMapNote)) == null) {
            return null;
        }
        if (this.ignoreCase) {
            extension = extension.toLowerCase();
        }
        if ((container = (Container)extM.get(extension)) == null) {
            return null;
        }
        if (container.getHandler() == null) {
            return container;
        }
        return container;
    }

    void fixRequestPaths(String path, Request req, Container container) throws Exception {
        String s = container.getPath();
        String ctxP = container.getContext().getPath();
        int sLen = s.length();
        int pathLen = path.length();
        int ctxPLen = ctxP.length();
        String pathI = null;
        switch (container.getMapType()) {
            case 2: {
                s = s.substring(0, sLen - 2);
                pathI = path.substring(ctxPLen + sLen - 2, pathLen);
                if (this.debug <= 0) break;
                this.log("Adjust for prefix map " + s + " " + pathI);
                break;
            }
            case 4: {
                s = path.substring(ctxPLen);
                pathI = null;
                if (this.debug <= 0) break;
                this.log("Default map " + s + " " + pathI);
                break;
            }
            case 1: {
                pathI = null;
                if (this.debug <= 0) break;
                this.log("Adjust for path map " + s + " " + pathI + container.getPath());
                break;
            }
            case 3: {
                s = path.substring(ctxPLen);
                pathI = null;
            }
        }
        req.servletPath().setString(s);
        if (!"".equals(pathI)) {
            req.pathInfo().setString(pathI);
        }
        Context ctx = container.getContext();
        req.setContext(ctx);
        req.setHandler(container.getHandler());
        req.setContainer(container);
    }
}

