/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.server.Ajp12;
import org.apache.tomcat.modules.server.Ajp13;
import org.apache.tomcat.modules.server.Ajp13Request;
import org.apache.tomcat.modules.server.Ajp13Response;
import org.apache.tomcat.modules.server.PoolTcpConnector;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;

public class Ajp13Interceptor
extends PoolTcpConnector
implements TcpConnectionHandler {
    private boolean tomcatAuthentication = true;
    private boolean shutdownEnable = false;
    private boolean decoded = true;
    private int decodedNote;
    private String secret = null;
    private File ajpidFile = null;
    private boolean authenticateConnection = false;

    public Ajp13Interceptor() {
        super.setSoLinger(100);
        super.setTcpNoDelay(true);
    }

    public void setShutdownEnable(boolean b) {
        this.shutdownEnable = b;
    }

    public void setShutDownEnable(boolean b) {
        this.shutdownEnable = b;
    }

    public void setUseSecret(boolean b) {
        this.secret = Double.toString(Math.random());
        this.shutdownEnable = true;
    }

    public void setSecret(String s) {
        this.secret = s;
        this.shutdownEnable = true;
    }

    public void setAjpidFile(String path) {
        this.ajpidFile = path == null ? null : new File(path);
    }

    public void setAuthenticateConnection(boolean b) {
        this.authenticateConnection = b;
    }

    public void setDecodedUri(boolean b) {
        this.decoded = b;
    }

    protected void localInit() throws Exception {
        this.ep.setConnectionHandler((TcpConnectionHandler)this);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.decodedNote = cm.getNoteId(2, "req.decoded");
        String ajpid13 = cm.getProperty("ajpid13");
        if (ajpid13 != null) {
            if (this.ajpidFile != null) {
                this.log("Overriding ajpidFile with " + ajpid13);
            }
            this.ajpidFile = new File(ajpid13);
        }
    }

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state == 3) {
            Ajp13Interceptor tcpCon = this;
            int portInt = tcpCon.getPort();
            InetAddress address = tcpCon.getAddress();
            File sf = FileUtil.getConfigFile((File)this.ajpidFile, (File)new File(cm.getHome()), (String)"conf/ajp13.id");
            Properties props = new Properties();
            if (this.ajpidFile != null || this.debug > 0) {
                this.log("Using stop file: " + sf);
            }
            try {
                FileOutputStream stopF = new FileOutputStream(sf);
                ((Hashtable)props).put("port", Integer.toString(portInt));
                if (address != null) {
                    ((Hashtable)props).put("address", address.getHostAddress());
                }
                if (this.secret != null) {
                    ((Hashtable)props).put("secret", this.secret);
                }
                if (this.shutdownEnable) {
                    ((Hashtable)props).put("shutdown", "enabled");
                }
                props.save(stopF, "Automatically generated, don't edit");
            }
            catch (IOException ex) {
                this.log("Can't create stop file: " + sf, ex);
            }
        }
    }

    public Object[] init() {
        Object[] thData = new Object[3];
        Ajp13Request req = new Ajp13Request();
        Ajp13Response res = new Ajp13Response();
        Ajp13 con = new Ajp13();
        con.setDebug(this.debug);
        req.setDebug(this.debug);
        con.setTomcatAuthentication(this.isTomcatAuthentication());
        this.cm.initRequest((Request)req, (Response)res);
        thData[0] = req;
        thData[1] = res;
        thData[2] = con;
        return thData;
    }

    public void processConnection(TcpConnection connection, Object[] thData) {
        try {
            if (connection == null) {
                return;
            }
            Socket socket = connection.getSocket();
            if (socket == null) {
                return;
            }
            Ajp13 con = null;
            Ajp13Request req = null;
            Ajp13Response res = null;
            if (thData != null) {
                req = (Ajp13Request)((Object)thData[0]);
                res = (Ajp13Response)((Object)thData[1]);
                con = (Ajp13)thData[2];
                if (req != null) {
                    req.recycle();
                }
                if (res != null) {
                    res.recycle();
                }
                if (con != null) {
                    con.recycle();
                }
            }
            if (req == null || res == null || con == null) {
                req = new Ajp13Request();
                res = new Ajp13Response();
                con = new Ajp13();
                con.setTomcatAuthentication(this.isTomcatAuthentication());
                this.cm.initRequest((Request)req, (Response)res);
            }
            req.ajp13 = con;
            res.ajp13 = con;
            con.setSocket(socket);
            boolean moreRequests = true;
            boolean authenticated = false;
            if (this.secret == null || !this.authenticateConnection) {
                authenticated = true;
            }
            while (moreRequests) {
                int status = req.receiveNextRequest();
                if (!authenticated) {
                    String conSecret = con.getSecret();
                    if (conSecret == null) {
                        this.log("Unauthenticated server");
                        break;
                    }
                    if (!this.secret.equals(conSecret)) {
                        this.log("Bad server secret");
                        break;
                    }
                    authenticated = true;
                }
                if (status == -2) {
                    if (this.secret != null && !this.secret.equals(con.getSecret())) {
                        this.log("Shutdown command ignored. Secret didn't match.");
                        continue;
                    }
                    if (!this.doShutdown(con, socket.getLocalAddress(), socket.getInetAddress())) {
                        moreRequests = false;
                        continue;
                    }
                }
                if (status != 200) break;
                if (this.decoded) {
                    req.setNote(this.decodedNote, (Object)this);
                }
                this.cm.service((Request)req, (Response)res);
                req.recycle();
                res.recycle();
            }
            this.log("Closing connection", 4);
            con.close();
            socket.close();
        }
        catch (Exception e) {
            this.log("Processing connection " + connection, e);
        }
    }

    public void setServer(Object contextM) {
        this.cm = (ContextManager)contextM;
    }

    protected boolean doShutdown(Ajp13 con, InetAddress serverAddr, InetAddress clientAddr) {
        try {
            if (this.shutdownEnable && Ajp12.isSameAddress(serverAddr, clientAddr)) {
                this.cm.shutdown();
                this.log("Exiting");
                System.exit(0);
            }
        }
        catch (Exception ignored) {
            this.log("Ignored " + ignored);
        }
        this.log("Shutdown command ignored");
        return false;
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }
}

