/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.io.RecycleBufferedInputStream;
import org.apache.tomcat.util.log.Log;

public class Http10 {
    private Socket socket;
    private boolean moreRequests = false;
    RecycleBufferedInputStream sin;
    protected OutputStream sout;
    byte[] buf;
    int bufSize = 2048;
    int off = 0;
    int count = 0;
    protected static final int DEFAULT_HEAD_BUFFER_SIZE = 1024;
    protected byte[] oBuffer = new byte[1024];
    protected int oBufferCount = 0;
    static final byte[] CRLF = new byte[]{13, 10};
    Log loghelper = Log.getLog((String)"tc_log", (Object)this);
    Location headerArea = new Location(this.off, -1);
    Location line = new Location(this.off, -1);
    Location nextLine = new Location(this.off, -1);
    private static final int d = 0;

    public Http10() {
        this.buf = new byte[this.bufSize];
    }

    public void setSocket(Socket socket) throws IOException {
        if (this.sin == null) {
            this.sin = new RecycleBufferedInputStream(socket.getInputStream());
        } else {
            this.sin.setInputStream(socket.getInputStream());
        }
        this.socket = socket;
        this.moreRequests = true;
        this.sout = socket.getOutputStream();
    }

    public void recycle() {
        this.off = 0;
        this.count = 0;
        this.oBufferCount = 0;
        if (this.sin != null) {
            this.sin.recycle();
        }
    }

    public int doRead() throws IOException {
        return this.sin.read();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.sin.read(b, off, len);
    }

    private int readLine(Location line) throws IOException {
        while (true) {
            line.end = line.off;
            int len = this.buf.length - line.off;
            if (len > 0) {
                if ((len = this.readLine((InputStream)this.sin, this.buf, line.off, len)) == -1) {
                    return 400;
                }
                line.end += len;
                if (len == 0 || this.buf[line.end - 1] == 10) {
                    if (line.end > line.off && this.buf[line.end - 1] == 10) {
                        --line.end;
                    }
                    if (line.end > line.off && this.buf[line.end - 1] == 13) {
                        --line.end;
                    }
                    return 0;
                }
            }
            byte[] tmp = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    public int readHeaders(MimeHeaders headers) throws IOException {
        block6: {
            this.headerArea.off = this.off = this.count;
            boolean firstLine = true;
            block0: do {
                int status;
                if (firstLine) {
                    this.line.off = this.off;
                    status = this.readLine(this.line);
                    if (status != 0) {
                        return status;
                    }
                    this.off = this.line.end;
                    firstLine = false;
                } else {
                    this.line.off = this.nextLine.off;
                    this.line.end = this.nextLine.end;
                }
                if (this.line.off == this.line.end) break block6;
                while (true) {
                    char firstB;
                    this.nextLine.off = this.line.end;
                    status = this.readLine(this.nextLine);
                    if (status != 0) {
                        return status;
                    }
                    this.off = this.nextLine.end;
                    if (this.nextLine.off == this.nextLine.end || (firstB = (char)this.buf[this.nextLine.off]) != ' ' && firstB != '\t') continue block0;
                    this.line.end = this.nextLine.end;
                }
            } while (this.parseHeaderField(headers, this.buf, this.line.off, this.line.end - this.line.off));
            return 200;
        }
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean parseHeaderField(MimeHeaders headers, byte[] b, int off, int len) {
        byte c;
        int start = off;
        while ((c = b[off++]) != 58 && c != 32) {
            void var6_6;
            if (var6_6 != 10) continue;
            this.loghelper.log("Parse error, empty line: " + new String(b, off, len), 1);
            return false;
        }
        int nS = start;
        int nE = off - start - 1;
        while (c == 32) {
            c = b[off++];
        }
        if (c != 58) {
            this.loghelper.log("Parse error, missing : in  " + new String(b, off, len), 1);
            this.loghelper.log("Full  " + new String(b, 0, b.length), 1);
            return false;
        }
        while ((c = b[off++]) == 32) {
        }
        headers.addValue(b, nS, nE).setBytes(b, off - 1, len - (off - start - 1));
        return true;
    }

    public final int processRequestLine(MessageBytes methodMB, MessageBytes uriMB, MessageBytes queryMB, MessageBytes protocolMB) throws IOException {
        this.count = this.readLine((InputStream)this.sin, this.buf, 0, this.buf.length);
        if (this.count < 0) {
            return 400;
        }
        this.off = 0;
        if (this.buf[this.count - 1] != 13 && this.buf[this.count - 1] != 10) {
            return 414;
        }
        int startMethod = this.skipSpaces();
        int endMethod = this.findSpace();
        int startReq = this.skipSpaces();
        int endReq = this.findSpace();
        int startProto = this.skipSpaces();
        int endProto = this.findSpace();
        if (startReq < 0) {
            return 400;
        }
        methodMB.setBytes(this.buf, startMethod, endMethod - startMethod);
        if (this.buf[startMethod] == 71 && methodMB.equals("GET")) {
            methodMB.setString("GET");
        }
        if (this.buf[startMethod] == 80) {
            if (methodMB.equals("POST")) {
                methodMB.setString("POST");
            }
            if (methodMB.equals("PUT")) {
                methodMB.setString("PUT");
            }
        }
        if (endReq < 0) {
            endReq = this.count;
        } else if (startProto > 0) {
            if (endProto < 0) {
                endProto = this.count;
            }
            protocolMB.setBytes(this.buf, startProto, endProto - startProto);
            if (protocolMB.equalsIgnoreCase("http/1.0")) {
                protocolMB.setString("HTTP/1.0");
            }
            if (protocolMB.equalsIgnoreCase("http/1.1")) {
                protocolMB.setString("HTTP/1.1");
            }
        } else {
            protocolMB.setString("");
        }
        int qryIdx = this.findChar('?', startReq, endReq);
        if (qryIdx < 0) {
            uriMB.setBytes(this.buf, startReq, endReq - startReq);
        } else {
            uriMB.setBytes(this.buf, startReq, qryIdx - startReq);
            queryMB.setBytes(this.buf, qryIdx + 1, endReq - qryIdx - 1);
        }
        return 200;
    }

    public void sendHeaders(MimeHeaders headers) throws IOException {
        int count = headers.size();
        int i = 0;
        while (i < count) {
            this.printHead(headers.getName(i).toString());
            this.printHead(": ");
            this.printHead(headers.getValue(i).toString());
            this.printHead("\r\n");
            ++i;
        }
        this.printHead("\r\n");
        this.sout.write(this.oBuffer, 0, this.oBufferCount);
        this.sout.flush();
    }

    public void sendStatus(int status, String message) throws IOException {
        this.printHead("HTTP/1.0 ");
        switch (status) {
            case 200: {
                this.printHead("200");
                break;
            }
            case 400: {
                this.printHead("400");
                break;
            }
            case 404: {
                this.printHead("404");
                break;
            }
            default: {
                this.printHead(String.valueOf(status));
            }
        }
        if (message != null) {
            this.printHead(" ");
            this.printHead(message);
        }
        this.printHead("\r\n");
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.sout.write(buffer, pos, count);
    }

    private final int skipSpaces() {
        while (this.off < this.count) {
            if (this.buf[this.off] != 32 && this.buf[this.off] != 9 && this.buf[this.off] != 13 && this.buf[this.off] != 10) {
                return this.off;
            }
            ++this.off;
        }
        return -1;
    }

    private int findSpace() {
        while (this.off < this.count) {
            if (this.buf[this.off] == 32 || this.buf[this.off] == 9 || this.buf[this.off] == 13 || this.buf[this.off] == 10) {
                return this.off;
            }
            ++this.off;
        }
        return -1;
    }

    private int findChar(char c, int start, int end) {
        byte b = (byte)c;
        int offset = start;
        while (offset < end) {
            if (this.buf[offset] == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            void var6_6;
            b[off++] = (byte)var6_6;
            if (var6_6 == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }

    public void printHead(String s) {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                this.loghelper.log("Header character is not iso8859_1, not supported yet: " + c, 1);
            }
            if (this.oBufferCount >= this.oBuffer.length) {
                byte[] bufferNew = new byte[this.oBuffer.length * 2];
                System.arraycopy(this.oBuffer, 0, bufferNew, 0, this.oBuffer.length);
                this.oBuffer = bufferNew;
            }
            this.oBuffer[this.oBufferCount] = (byte)c;
            ++this.oBufferCount;
            ++i;
        }
    }

    private static void debug(String s) {
        System.out.println("Http10: " + s);
    }

    static class Location {
        int off;
        int end;

        Location(int start, int end) {
            this.off = start;
            this.end = end;
        }
    }
}

