/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.modules.server.Http10;
import org.apache.tomcat.modules.server.HttpRequest;
import org.apache.tomcat.util.buf.DateTool;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;

class HttpResponse
extends Response {
    Http10 http;
    String reportedname;
    DateFormat dateFormat;

    public void init() {
        super.init();
        this.dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        this.dateFormat.setTimeZone(DateTool.GMT_ZONE);
    }

    public void setSocket(Socket s) {
        this.http = ((HttpRequest)this.request).http;
    }

    public void recycle() {
        super.recycle();
    }

    public void setReported(String reported) {
        this.reportedname = reported;
    }

    public void endHeaders() throws IOException {
        super.endHeaders();
        if (this.request.protocol().isNull() || this.request.protocol().equals("")) {
            return;
        }
        this.http.sendStatus(this.status, HttpMessages.getMessage((int)this.status));
        MessageBytes dateH = this.getMimeHeaders().getValue("Date");
        if (dateH == null) {
            MessageBytes dateHeader = this.getMimeHeaders().setValue("Date");
            dateHeader.setTime(System.currentTimeMillis(), this.dateFormat);
        }
        if (this.reportedname == null) {
            Context ctx = this.request.getContext();
            String server = ctx != null ? ctx.getEngineHeader() : "Tomcat Web Server/3.3.1 Final";
            this.getMimeHeaders().setValue("Server").setString(server);
        } else if (this.reportedname.length() != 0) {
            this.getMimeHeaders().setValue("Server").setString(this.reportedname);
        }
        this.http.sendHeaders(this.getMimeHeaders());
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.http.doWrite(buffer, pos, count);
    }
}

