/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public abstract class PoolTcpConnector
extends BaseInterceptor {
    protected PoolTcpEndpoint ep;
    protected ServerSocketFactory socketFactory;
    protected SSLImplementation sslImplementation;
    protected Hashtable attributes = new Hashtable();
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    protected boolean secure = false;

    public PoolTcpConnector() {
        this.ep = new PoolTcpEndpoint();
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.checkSocketFactory();
        try {
            this.localInit();
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    public void engineStart(ContextManager cm) throws TomcatException {
        try {
            if (this.socketFactory != null) {
                Enumeration attE = this.attributes.keys();
                while (attE.hasMoreElements()) {
                    String key = (String)attE.nextElement();
                    Object v = this.attributes.get(key);
                    this.socketFactory.setAttribute(key, v);
                }
            }
            this.ep.startEndpoint();
            this.log("Starting on " + this.ep.getPort());
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        try {
            this.ep.stopEndpoint();
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    protected abstract void localInit() throws Exception;

    public void setPools(boolean t) {
        this.ep.setPoolOn(t);
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.ep.setMaxSpareThreads(maxThreads);
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.ep.setMinSpareThreads(minSpareThreads);
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
    }

    public void setPort(int port) {
        this.ep.setPort(port);
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
    }

    public void setHostName(String name) {
    }

    private void checkSocketFactory() throws TomcatException {
        if (this.secure) {
            try {
                this.sslImplementation = SSLImplementation.getInstance((String)this.sslImplementationName);
                this.socketFactory = this.sslImplementation.getServerSocketFactory();
                this.ep.setServerSocketFactory(this.socketFactory);
            }
            catch (ClassNotFoundException e) {
                throw new TomcatException("Error loading SSLImplementation ", (Throwable)e);
            }
        }
        if (this.socketFactoryName != null) {
            try {
                this.socketFactory = PoolTcpConnector.string2SocketFactory(this.socketFactoryName);
                this.ep.setServerSocketFactory(this.socketFactory);
            }
            catch (Exception sfex) {
                throw new TomcatException("Error Loading Socket Factory " + this.socketFactoryName, (Throwable)sfex);
            }
        }
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
    }

    public void setServerSoTimeout(int i) {
        this.ep.setServerSoTimeout(i);
    }

    public PoolTcpEndpoint getEndpoint() {
        return this.ep;
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setKeystore(String k) {
        this.attributes.put("keystore", k);
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public void setClientauth(String k) {
        this.attributes.put("clientauth", k);
    }

    public boolean isKeystoreSet() {
        return this.attributes.get("keystore") != null;
    }

    public boolean isKeypassSet() {
        return this.attributes.get("keypass") != null;
    }

    public boolean isClientauthSet() {
        return this.attributes.get("clientauth") != null;
    }

    public boolean isAttributeSet(String attr) {
        return this.attributes.get(attr) != null;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAttribute(String prop, Object value) {
        this.attributes.put(prop, value);
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    public static boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

