/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.session;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.util.http.ServerCookie;

public class SessionId
extends BaseInterceptor {
    static final char SESSIONID_ROUTE_SEP = '.';
    boolean noCookies = false;
    boolean cookiesFirst = true;
    boolean checkSSLSessionId = false;

    public void setCookiesFirst(boolean b) {
        this.cookiesFirst = b;
    }

    public void setNoCookies(boolean noCookies) {
        this.noCookies = noCookies;
    }

    public void setCheckSSLSessionId(boolean checkSSLSessionId) {
        this.checkSSLSessionId = checkSSLSessionId;
    }

    public int postReadRequest(Request request) {
        if (request.getRequestedSessionId() != null) {
            return 0;
        }
        if (request.requestURI().indexOf(';') < 0) {
            return 0;
        }
        String sig = ";jsessionid=";
        int foundAt = -1;
        foundAt = request.requestURI().indexOf(sig);
        if (foundAt != -1) {
            String uri = request.requestURI().toString();
            String sessionId = uri.substring(foundAt + sig.length());
            request.requestURI().setString(uri.substring(0, foundAt));
            if (!request.unparsedURI().isNull() && (foundAt = request.unparsedURI().indexOf(sig)) != -1) {
                uri = request.unparsedURI().toString();
                request.unparsedURI().setString(uri.substring(0, foundAt));
            }
            request.setSessionIdSource("url");
            request.setRequestedSessionId(sessionId);
        }
        return 0;
    }

    public int requestMap(Request request) {
        String sessionId = null;
        Context ctx = request.getContext();
        if (ctx == null) {
            this.log("Configuration error in StandardSessionInterceptor  - no context " + request);
            return 0;
        }
        int count = request.getCookies().getCookieCount();
        ServerSession sess = null;
        if (!this.cookiesFirst) {
            sessionId = request.getRequestedSessionId();
            sess = this.processSession(request, sessionId, request.getSessionIdSource());
            if (this.debug > 0) {
                this.log("CookiesFirst==false, use url rewriting " + sess);
            }
            if (sess != null) {
                return 0;
            }
        }
        int i = 0;
        while (i < count) {
            ServerCookie cookie = request.getCookies().getCookie(i);
            if (cookie.getName().equals("JSESSIONID")) {
                sessionId = cookie.getValue().toString();
                if (this.debug > 0) {
                    this.log("Found session id cookie " + sessionId);
                }
                if ((sess = this.processSession(request, sessionId, "cookie")) != null) break;
            }
            ++i;
        }
        if (sess == null) {
            sessionId = request.getRequestedSessionId();
            sess = this.processSession(request, sessionId, request.getSessionIdSource());
            if (this.debug > 0) {
                this.log("Url rewriting, found " + sess);
            }
            if (sess != null) {
                return 0;
            }
        }
        return 0;
    }

    private ServerSession processSession(Request request, String sessionId, String source) {
        BaseInterceptor[] reqI = request.getContainer().getInterceptors(7);
        ServerSession sess = null;
        int i = 0;
        while (i < reqI.length) {
            sess = reqI[i].findSession(request, sessionId, false);
            if (sess != null) break;
            ++i;
        }
        if (this.checkSSLSessionId && sess != null && request.isSecure()) {
            String ids = (String)sess.getAttribute("javax.servlet.session.ssl_session");
            String idr = (String)request.getAttribute("javax.servlet.request.ssl_session");
            if (this.debug > 0) {
                this.cm.log("Request SSL ID=" + idr + ", Session SSL ID=" + ids);
            }
            if (idr != null) {
                if (ids != null) {
                    if (!ids.equals(idr)) {
                        sess = null;
                        this.cm.log("SECURITY WARNING: SSL session " + idr + " doesn't match Tomcat session " + sessionId + "!");
                    }
                } else {
                    sess.setAttribute("javax.servlet.session.ssl_session", (Object)idr);
                }
            } else {
                this.cm.log("SECURITY WARNING: checkSSLSessionId requested, but no SSL session ID available!");
            }
        }
        if (sess != null) {
            request.setRequestedSessionId(sessionId);
            request.setSessionIdSource(source);
            request.setSession(sess);
            request.setSessionId(sessionId);
            sess.touch(System.currentTimeMillis());
            if (sess.getState() == 0) {
                sess.setState(1, request);
            }
        }
        return sess;
    }

    public int beforeBody(Request rrequest, Response response) {
        String reqSessionId = rrequest.getSessionId();
        if (this.debug > 0) {
            this.cm.log("Before Body " + reqSessionId);
        }
        if (reqSessionId == null) {
            return 0;
        }
        if (this.noCookies) {
            return 0;
        }
        if (reqSessionId.equals(rrequest.getRequestedSessionId())) {
            return 0;
        }
        String sessionPath = rrequest.getContext().getPath();
        if (sessionPath.length() == 0) {
            sessionPath = "/";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("JSESSIONID=").append(reqSessionId);
        buf.append(";Path=").append(sessionPath);
        response.addHeader("Set-Cookie", buf.toString());
        if (this.debug > 0) {
            this.log("Setting cookie " + buf);
        }
        return 0;
    }
}

