/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.session;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.ObjectSerializer;
import org.apache.tomcat.util.buf.TimeStamp;
import org.apache.tomcat.util.collections.SimplePool;

public final class SimpleSessionStore
extends BaseInterceptor {
    int manager_note;
    int maxActiveSessions = -1;
    int size = 16;
    int max = 256;

    public void setMaxActiveSessions(int count) {
        this.maxActiveSessions = count;
    }

    public void setInitialPool(int initial) {
        this.size = initial;
    }

    public void setMaxPool(int max) {
        this.max = max;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.manager_note = cm.getNoteId(1, "tomcat.standardManager");
    }

    public void reload(Request req, Context ctx) throws TomcatException {
        ClassLoader newLoader = ctx.getClassLoader();
        SimpleSessionManager sM = this.getManager(ctx);
        Enumeration sessionEnum = sM.getSessionIds();
        while (sessionEnum.hasMoreElements()) {
            Object value;
            String key;
            ServerSession session = (ServerSession)sessionEnum.nextElement();
            ClassLoader oldLoader = (ClassLoader)ctx.getContainer().getNote("oldLoader");
            Hashtable<String, Object> newSession = new Hashtable<String, Object>();
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = session.getAttribute(key);
                if (value.getClass().getClassLoader() != oldLoader) {
                    newSession.put(key, value);
                    continue;
                }
                if (!(value instanceof Serializable)) continue;
                Object newValue = ObjectSerializer.doSerialization((ClassLoader)newLoader, (Object)value);
                newSession.put(key, newValue);
            }
            e = newSession.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                session.removeAttribute(key);
            }
            if (this.debug > 0) {
                this.log("Prepare for reloading, SUSPEND " + session);
            }
            session.setState(4, req);
            if (this.debug > 0) {
                this.log("After reloading, RESTORED " + session);
            }
            session.setState(5, req);
            e = newSession.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = newSession.get(key);
                session.setAttribute(key, value);
            }
        }
    }

    public ServerSession findSession(Request request, String sessionId, boolean create) {
        Context ctx = request.getContext();
        if (ctx == null) {
            return null;
        }
        SimpleSessionManager sM = this.getManager(ctx);
        ServerSession sess = sM.findSession(sessionId);
        if (sess != null) {
            return sess;
        }
        if (!create) {
            return null;
        }
        if (this.maxActiveSessions >= 0 && sM.getSessionCount() >= this.maxActiveSessions) {
            this.log("Too many sessions " + this.maxActiveSessions);
            return null;
        }
        ServerSession newS = sM.getNewSession(request, ctx);
        if (newS == null) {
            this.log("Create session failed ");
            return null;
        }
        return newS;
    }

    public void contextInit(Context ctx) throws TomcatException {
        SimpleSessionManager sm = this.getManager(ctx);
        if (sm == null) {
            sm = new SimpleSessionManager();
            sm.setDebug(this.debug);
            sm.setModule(this);
            ctx.getContainer().setNote(this.manager_note, (Object)sm);
        }
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        if (this.debug > 0) {
            this.log("Removing sessions from " + ctx);
        }
        SimpleSessionManager sm = this.getManager(ctx);
        Enumeration ids = sm.getSessionIds();
        while (ids.hasMoreElements()) {
            String id = (String)ids.nextElement();
            ServerSession session = sm.findSession(id);
            if (!session.getTimeStamp().isValid()) continue;
            if (this.debug > 0) {
                this.log("Shuting down " + id);
            }
            session.setState(4);
            session.setState(2);
        }
    }

    public int sessionState(Request req, ServerSession session, int state) {
        TimeStamp ts = session.getTimeStamp();
        if (state == 2) {
            SimpleSessionManager ssm = (SimpleSessionManager)session.getManager();
            ssm.removeSession(session);
        }
        return state;
    }

    public Enumeration getSessionIds(Context ctx) {
        SimpleSessionManager sm = this.getManager(ctx);
        return sm.getSessionIds();
    }

    public Enumeration getSessions(Context ctx) {
        SimpleSessionManager sm = this.getManager(ctx);
        return sm.getSessions();
    }

    public int getSessionCount(Context ctx) {
        SimpleSessionManager sm = this.getManager(ctx);
        return sm.getSessionCount();
    }

    public int getRecycledCount(Context ctx) {
        SimpleSessionManager sm = this.getManager(ctx);
        return sm.getRecycledCount();
    }

    public ServerSession findSession(Context ctx, String sessionId) {
        SimpleSessionManager sM = this.getManager(ctx);
        return sM.findSession(sessionId);
    }

    private SimpleSessionManager getManager(Context ctx) {
        return (SimpleSessionManager)ctx.getContainer().getNote(this.manager_note);
    }

    public static class SimpleSessionManager {
        private int debug = 0;
        private BaseInterceptor mod;
        protected SimplePool recycled = new SimplePool();
        protected Hashtable sessions = new Hashtable();

        public void setDebug(int l) {
            this.debug = l;
        }

        public void setModule(BaseInterceptor bi) {
            this.mod = bi;
        }

        public Enumeration getSessionIds() {
            return this.sessions.keys();
        }

        public Enumeration getSessions() {
            return this.sessions.elements();
        }

        public int getSessionCount() {
            return this.sessions.size();
        }

        public int getRecycledCount() {
            return this.recycled.getCount();
        }

        public ServerSession findSession(String id) {
            if (id == null) {
                return null;
            }
            return (ServerSession)this.sessions.get(id);
        }

        public void removeSession(ServerSession session) {
            if (this.debug > 0) {
                this.mod.log("removeSession " + session);
            }
            this.sessions.remove(session.getId().toString());
            this.recycled.put((Object)session);
            session.setValid(false);
        }

        public ServerSession getNewSession(Request req, Context ctx) {
            ServerSession session = (ServerSession)this.recycled.get();
            if (session == null) {
                session = ctx.getContextManager().createServerSession();
                session.setManager((Object)this);
                session.setDebug(this.debug);
            }
            session.setContext(ctx);
            session.setState(0, req);
            String newId = session.getId().toString();
            newId = newId == null ? "null" : newId;
            ServerSession oldS = this.findSession(newId);
            if (oldS != null) {
                oldS.setState(2);
                oldS.recycle();
            }
            this.sessions.put(newId, session);
            return session;
        }
    }
}

