/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.util.Locale;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class Response {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    public static final String LOCALE_DEFAULT = "en";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "");
    protected static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    protected Request request;
    protected Object responseFacade;
    protected int status = 200;
    protected MimeHeaders headers = new MimeHeaders();
    protected OutputBuffer oBuffer;
    protected boolean commited = false;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean included = false;
    protected Exception errorException = null;
    protected String errorURI = null;
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = "ISO-8859-1";
    protected Locale locale = DEFAULT_LOCALE;

    protected void init() {
        this.oBuffer = this.request.getContextManager().createOutputBuffer();
        this.oBuffer.setResponse(this);
    }

    public Object getFacade() {
        return this.responseFacade;
    }

    public void setFacade(Object facade) {
        this.responseFacade = facade;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public OutputBuffer getBuffer() {
        return this.oBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean incl) {
        this.included = incl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        if (this.included) {
            return;
        }
        this.status = status;
    }

    public boolean isUsingStream() {
        return this.usingStream;
    }

    public void setUsingStream(boolean stream) {
        this.usingStream = stream;
    }

    public boolean isUsingWriter() {
        return this.usingWriter;
    }

    public void setUsingWriter(boolean writer) {
        this.usingWriter = writer;
    }

    public boolean isBufferCommitted() {
        return this.commited;
    }

    public void setBufferCommitted(boolean v) {
        this.commited = v;
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public void setErrorURI(String uri) {
        this.errorURI = uri;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public void reset() throws IllegalStateException {
        if (!this.included) {
            this.contentType = DEFAULT_CONTENT_TYPE;
            this.locale = DEFAULT_LOCALE;
            this.characterEncoding = DEFAULT_CHAR_ENCODING;
            this.status = 200;
            this.headers.clear();
        }
        if (this.commited) {
            String msg = sm.getString("servletOutputStreamImpl.reset.ise");
            throw new IllegalStateException(msg);
        }
        this.oBuffer.reset();
    }

    public void finish() throws IOException {
        this.oBuffer.close();
        ContextManager cm = this.request.getContextManager();
        BaseInterceptor[] reqI = this.request.getContainer().getInterceptors(10);
        int i = 0;
        while (i < reqI.length) {
            reqI[i].afterBody(this.request, this);
            ++i;
        }
    }

    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public void setHeader(String name, String value) {
        if (this.included) {
            return;
        }
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    public void addHeader(String name, String value) {
        if (this.included) {
            return;
        }
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public void endHeaders() throws IOException {
        this.notifyEndHeaders();
    }

    public void notifyEndHeaders() throws IOException {
        this.commited = true;
        if (this.request.getContext() != null) {
            ContextManager cm = this.request.getContext().getContextManager();
            BaseInterceptor[] reqI = this.request.getContainer().getInterceptors(6);
            boolean saveIncluded = this.included;
            this.included = false;
            int i = 0;
            while (i < reqI.length) {
                reqI[i].beforeBody(this.request.getTop(), this);
                ++i;
            }
            this.included = saveIncluded;
        }
    }

    public int getBufferSize() {
        return this.oBuffer.getBufferSize();
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (!this.oBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("servletOutputStreamImpl.setbuffer.ise"));
        }
        this.oBuffer.setBufferSize(size);
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.commited) {
            String msg = sm.getString("servletOutputStreamImpl.reset.ise");
            throw new IllegalStateException(msg);
        }
        this.oBuffer.reset();
    }

    public void flushBuffer() throws IOException {
        this.oBuffer.flush();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.included) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        this.headers.setValue("Content-Language").setString(this.contentLanguage);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String contentType) {
        if (this.included) {
            return;
        }
        this.contentType = contentType;
        String encoding = ContentType.getCharsetFromContentType((String)contentType);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        this.headers.setValue("Content-Type").setString(contentType);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(int contentLength) {
        if (this.included) {
            return;
        }
        this.headers.setValue("Content-Length").setInt(contentLength);
    }

    /*
     * WARNING - void declaration
     */
    public int getContentLength() {
        String value = this.headers.getHeader("Content-Length");
        if (value == null) {
            return -1;
        }
        try {
            void ex;
            int cL = Integer.parseInt(value);
            return (int)ex;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
    }

    public void recycle() {
        this.contentType = DEFAULT_CONTENT_TYPE;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.characterEncoding = DEFAULT_CHAR_ENCODING;
        this.status = 200;
        this.usingWriter = false;
        this.usingStream = false;
        this.commited = false;
        this.included = false;
        this.errorException = null;
        this.errorURI = null;
        if (this.oBuffer != null) {
            this.oBuffer.recycle();
        }
        this.headers.clear();
    }
}

