/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.TimeStamp;

public class ServerSession {
    public static final int STATE_NEW = 0;
    public static final int STATE_ACCESSED = 1;
    public static final int STATE_EXPIRED = 2;
    public static final int STATE_INVALID = 3;
    public static final int STATE_SUSPEND = 4;
    public static final int STATE_RESTORED = 5;
    private int debug = 0;
    private MessageBytes id = MessageBytes.newInstance();
    private Hashtable attributes = new Hashtable();
    TimeStamp ts = new TimeStamp();
    boolean distributable = false;
    Object manager;
    Context context;
    ContextManager contextM;
    private Object[] notes = new Object[32];
    private int state = 0;
    Object facade;

    public void setManager(Object m) {
        this.manager = m;
    }

    public Object getManager() {
        return this.manager;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public Object getFacade() {
        return this.facade;
    }

    public void setFacade(Object o) {
        this.facade = o;
    }

    public final int getState() {
        return this.state;
    }

    public void setState(int state) {
        if (this.context != null) {
            BaseInterceptor[] reqI = this.context.getContainer().getInterceptors(8);
            int i = 0;
            while (i < reqI.length) {
                reqI[i].sessionState(null, this, state);
                ++i;
            }
        }
        this.state = state;
    }

    protected void setState1(int state) {
        this.state = state;
    }

    public void setState(int state, Request req) {
        if (this.context != null) {
            BaseInterceptor[] reqI = this.context.getContainer().getInterceptors(8);
            int i = 0;
            while (i < reqI.length) {
                reqI[i].sessionState(req, this, state);
                ++i;
            }
        }
        this.state = state;
    }

    public TimeStamp getTimeStamp() {
        return this.ts;
    }

    public MessageBytes getId() {
        return this.id;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public void removeAllAttributes() {
        if (this.debug > 0) {
            this.contextM.log("ServerSession:removeAllAttributes");
        }
        Enumeration attrs = this.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            this.removeAttribute(attr);
        }
    }

    public void removeAttribute(String name) {
        if (this.debug > 0) {
            this.contextM.log("ServerSession:removeAllAttribute " + name);
        }
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.debug > 0) {
            this.contextM.log("ServerSession:setAttribute " + name);
        }
        this.attributes.put(name, value);
    }

    public void touch(long time) {
        this.getTimeStamp().touch(time);
    }

    public void setValid(boolean b) {
        this.getTimeStamp().setValid(b);
    }

    public boolean isValid() {
        return this.getTimeStamp().isValid();
    }

    public void setDebug(int d) {
        this.debug = d;
    }

    public void recycle() {
        if (this.debug > 0) {
            this.contextM.log("ServerSession:recycle ");
        }
        this.facade = null;
        this.attributes.clear();
        this.ts.recycle();
        this.id.recycle();
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Object getNote(String name) throws TomcatException {
        int id = this.context.getContextManager().getNoteId(4, name);
        return this.getNote(id);
    }

    public void setNote(String name, Object value) throws TomcatException {
        int id = this.context.getContextManager().getNoteId(4, name);
        this.setNote(id, value);
    }
}

