/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Category;
import tyrex.resource.PoolLimits;
import tyrex.resource.PoolMetrics;
import tyrex.resource.Resource;
import tyrex.resource.ResourceException;
import tyrex.resource.jdbc.PoolEntry;
import tyrex.services.Clock;
import tyrex.services.DaemonMaster;
import tyrex.tm.TyrexTransactionManager;
import tyrex.util.LoggerPrintWriter;
import tyrex.util.Primes;

final class ConnectionPool
extends PoolMetrics
implements Resource,
DataSource,
ConnectionEventListener,
Runnable {
    public static final int TABLE_SIZE = 131;
    private final String _name;
    private final PoolEntry[] _pool;
    private final PoolLimits _limits;
    private final TyrexTransactionManager _txManager;
    private final Category _category;
    private final PrintWriter _logWriter;
    private final XAResource _xaResource;
    private long _nextExpiration;
    private final XADataSource _xaDataSource;
    private final ConnectionPoolDataSource _poolDataSource;
    private final ClassLoader _classLoader;
    private boolean _destroyed;
    static /* synthetic */ Class class$javax$sql$DataSource;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ConnectionPool(String string, PoolLimits poolLimits, ClassLoader classLoader, XADataSource xADataSource, ConnectionPoolDataSource connectionPoolDataSource, TyrexTransactionManager tyrexTransactionManager, Category category) throws ResourceException {
        int n;
        int n2;
        PooledConnection pooledConnection = null;
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        if (xADataSource == null && connectionPoolDataSource == null) {
            throw new IllegalArgumentException("Arguments xaDataSource and poolDataSource are null");
        }
        if (tyrexTransactionManager == null) {
            throw new IllegalArgumentException("Argument txManager is null");
        }
        if (category == null) {
            throw new IllegalArgumentException("Argument category is null");
        }
        this._name = string;
        this._classLoader = classLoader;
        this._xaDataSource = xADataSource;
        this._poolDataSource = connectionPoolDataSource;
        this._category = category;
        this._txManager = tyrexTransactionManager;
        try {
            if (poolLimits == null) {
                this._limits = new PoolLimits();
                this._logWriter = null;
            } else {
                this._limits = poolLimits;
                if (this._limits.getTrace()) {
                    this._logWriter = new LoggerPrintWriter(this._category, null);
                    if (this._xaDataSource != null) {
                        this._xaDataSource.setLogWriter(this._logWriter);
                    } else {
                        this._poolDataSource.setLogWriter(this._logWriter);
                    }
                } else {
                    this._logWriter = null;
                }
            }
            n2 = this._limits.getMaximum();
            this._pool = n2 > 0 ? new PoolEntry[Primes.nextPrime(n2)] : new PoolEntry[131];
            pooledConnection = this.createPooledConnection(null, null);
            if (this._xaDataSource != null) {
                if (!(pooledConnection instanceof XAConnection)) throw new ResourceException("Connection of type " + pooledConnection.getClass().getName() + " does not support XA transactions");
                this._xaResource = ((XAConnection)pooledConnection).getXAResource();
            } else {
                this._xaResource = null;
            }
            this.allocate(pooledConnection, null, null, false);
            n = this._limits.getInitial();
            if (n2 > 0 && n > n2) {
                n = n2;
            }
            int n3 = n - 1;
            while (n3-- > 0) {
                pooledConnection = this.createPooledConnection(null, null);
                this.allocate(pooledConnection, null, null, false);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceException(sQLException.toString());
        }
        if (this._logWriter != null) {
            this._logWriter.print("Created connection pool for data source " + string + " with initial size " + n + " and maximum iimit " + n2);
        }
        DaemonMaster.addDaemon(this, "Connection Pool " + string);
    }

    public PoolMetrics getPoolMetrics() {
        return this;
    }

    public PoolLimits getPoolLimits() {
        return this._limits;
    }

    public Object getClientFactory() {
        return this;
    }

    public Class getClientFactoryClass() {
        return class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = ConnectionPool.class$("javax.sql.DataSource")) : class$javax$sql$DataSource;
    }

    public String toString() {
        return this._name;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        long l = Clock.clock();
        DaemonMaster.removeDaemon(this);
        int n = this._pool.length;
        while (n-- > 0) {
            PoolEntry poolEntry = this._pool[n];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
                    this.recordDiscard();
                }
                try {
                    poolEntry._pooled.removeConnectionEventListener(this);
                    poolEntry._pooled.close();
                }
                catch (Exception exception) {
                    this._category.error((Object)("Error attempting to destory connection " + poolEntry._pooled + " by connection pool " + this), (Throwable)exception);
                }
                poolEntry._available = false;
                poolEntry = poolEntry._nextEntry;
            }
            this._pool[n] = null;
        }
        this._total = 0;
        this._available = 0;
    }

    public synchronized void run() {
        try {
            while (true) {
                long l;
                if ((l = this._nextExpiration) == 0L) {
                    this.wait();
                    continue;
                }
                long l2 = Clock.clock();
                if (l2 > l) {
                    this.expire();
                    continue;
                }
                this.wait(l - l2);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this._destroyed) {
            throw new SQLException("Connection pool has been destroyed");
        }
        PoolEntry poolEntry = this.allocate(string, string2);
        if (poolEntry._xaResource != null) {
            try {
                this._txManager.enlistResource(poolEntry._xaResource);
            }
            catch (Exception exception) {
                this.release(poolEntry._pooled, false);
                throw new SQLException("Error occured using connection " + poolEntry._pooled + ": " + exception);
            }
        }
        try {
            Connection connection = poolEntry._pooled.getConnection();
            return connection;
        }
        catch (Exception exception) {
            this.release(poolEntry._pooled, false);
            throw new SQLException("Error occured using connection " + poolEntry._pooled + ": " + exception);
        }
    }

    private synchronized PoolEntry allocate(String string, String string2) throws SQLException {
        int n;
        long l = this._limits.getTimeout() * 1000;
        while (true) {
            PoolEntry poolEntry;
            PooledConnection pooledConnection;
            if (this._available > 0) {
                pooledConnection = this.matchPooledConnections(string, string2);
                if (pooledConnection != null) {
                    poolEntry = this.reserve(pooledConnection);
                    if (poolEntry == null) {
                        this.release(pooledConnection, false);
                        this._category.error((Object)"Connector error: matchPooledConnetions returned an unavailable connection");
                        continue;
                    }
                    return poolEntry;
                }
            }
            if ((n = this._limits.getMaximum()) == 0 || this._total < n || this._available > 0 && this.discardNext()) {
                pooledConnection = this.createPooledConnection(string, string2);
                poolEntry = this.allocate(pooledConnection, string, string2, true);
                if (poolEntry == null) {
                    throw new SQLException("Connector error: createPooledConnetion returned an existing connection");
                }
                return poolEntry;
            }
            if (l <= 0L) {
                throw new SQLException("Cannot allocate new connection for " + this._name + ": reached limit of " + n + " connections");
            }
            long l2 = Clock.clock();
            try {
                this.wait(l);
                l -= Clock.clock() - l2;
            }
            catch (InterruptedException interruptedException) {
                l = 0L;
            }
            if (l <= 0L) break;
        }
        throw new SQLException("Cannot allocate new connection for " + this._name + ": reached limit of " + n + " connections");
    }

    private PooledConnection createPooledConnection(String string, String string2) throws SQLException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this._classLoader);
        PooledConnection pooledConnection = this._xaDataSource != null ? (string != null ? this._xaDataSource.getXAConnection(string, string2) : this._xaDataSource.getXAConnection()) : (string != null ? this._poolDataSource.getPooledConnection(string, string2) : this._poolDataSource.getPooledConnection());
        thread.setContextClassLoader(classLoader);
        return pooledConnection;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public int getLoginTimeout() {
        return 0;
    }

    public void setLoginTimeout(int n) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            if (pooledConnection != null) {
                if (!this.release(pooledConnection, true)) {
                    this._category.error((Object)"Connector error: connectionClosed called with invalid connection");
                }
            } else {
                this._category.error((Object)"Connector error: connectionClosed called without reference to connection");
            }
        }
        catch (ClassCastException classCastException) {
            this._category.error((Object)"Connector error: connectionClosed called without reference to connection");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            if (pooledConnection != null) {
                if (!this.release(pooledConnection, false)) {
                    this._category.error((Object)"Connector error: connectionClosed called with invalid connection");
                }
            } else {
                this._category.error((Object)"Connector error: connectionErrorOccurred called without reference to connection");
            }
        }
        catch (ClassCastException classCastException) {
            this._category.error((Object)"Connector error: connectionErrorOccurred called without reference to connection");
        }
    }

    private synchronized PoolEntry allocate(PooledConnection pooledConnection, String string, String string2, boolean bl) throws SQLException {
        int n;
        int n2;
        int n3;
        PoolEntry poolEntry;
        XAResource xAResource = null;
        if (pooledConnection == null) {
            throw new IllegalArgumentException("Argument pooled is null");
        }
        if (this._xaDataSource != null) {
            if (pooledConnection instanceof XAConnection) {
                xAResource = ((XAConnection)pooledConnection).getXAResource();
            } else {
                throw new SQLException("Connection of type " + pooledConnection.getClass().getName() + " does not support XA transactions");
            }
        }
        if ((poolEntry = this._pool[n3 = ((n2 = pooledConnection.hashCode()) & Integer.MAX_VALUE) % this._pool.length]) == null) {
            this._pool[n3] = poolEntry = new PoolEntry(pooledConnection, n2, xAResource, string, string2);
        } else {
            if (poolEntry._hashCode == n2 && poolEntry._pooled.equals(pooledConnection)) {
                this._category.error((Object)("Connector error: Allocated connection " + pooledConnection + " already in pool"));
                return null;
            }
            PoolEntry poolEntry2 = poolEntry._nextEntry;
            while (poolEntry2 != null) {
                if (poolEntry2._hashCode == n2 && poolEntry2._pooled.equals(pooledConnection)) {
                    this._category.error((Object)("Connector error: Allocated connection " + pooledConnection + " already in pool"));
                    return null;
                }
                poolEntry = poolEntry2;
                poolEntry2 = poolEntry._nextEntry;
            }
            poolEntry._nextEntry = poolEntry2 = new PoolEntry(pooledConnection, n2, xAResource, string, string2);
            poolEntry = poolEntry2;
        }
        poolEntry._pooled.addConnectionEventListener(this);
        this.recordCreated();
        if (!bl) {
            poolEntry._available = true;
            ++this._available;
        }
        if ((n = this._limits.getMaxRetain()) > 0) {
            long l = poolEntry._timeStamp + (long)(n * 1000);
            if (this._nextExpiration == 0L || this._nextExpiration > l) {
                this._nextExpiration = l;
                this.notifyAll();
            }
        }
        if (this._logWriter != null) {
            this._logWriter.println("Allocated new connection " + poolEntry._pooled);
        }
        return poolEntry;
    }

    private synchronized PoolEntry reserve(PooledConnection pooledConnection) {
        if (pooledConnection == null) {
            return null;
        }
        int n = pooledConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        while (poolEntry != null && poolEntry._hashCode != n && !poolEntry._pooled.equals(pooledConnection)) {
            poolEntry = poolEntry._nextEntry;
        }
        if (poolEntry != null && poolEntry._available) {
            poolEntry._available = false;
            --this._available;
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            poolEntry._timeStamp = l;
            if (this._logWriter != null) {
                this._logWriter.println("Reusing connection " + poolEntry._pooled);
            }
            return poolEntry;
        }
        return null;
    }

    private synchronized boolean release(PooledConnection pooledConnection, boolean bl) {
        if (pooledConnection == null) {
            return false;
        }
        int n = pooledConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        if (poolEntry != null) {
            if (n == poolEntry._hashCode && poolEntry._pooled.equals(pooledConnection)) {
                if (poolEntry._available) {
                    this._category.error((Object)("Connector error: Released connection " + pooledConnection + " not in pool"));
                    return false;
                }
            } else {
                poolEntry = poolEntry._nextEntry;
                while (poolEntry != null && n != poolEntry._hashCode && !poolEntry._pooled.equals(pooledConnection)) {
                    poolEntry = poolEntry._nextEntry;
                }
                if (poolEntry == null || poolEntry._available) {
                    this._category.error((Object)("Connector error: Released connection " + pooledConnection + " not in pool"));
                    return false;
                }
            }
        } else {
            this._category.error((Object)("Connector error: Released connection " + pooledConnection + " not in pool"));
            return false;
        }
        try {
            long l = Clock.clock();
            this.recordUsedDuration((int)(l - poolEntry._timeStamp));
            poolEntry._timeStamp = l;
            poolEntry._available = true;
            if (poolEntry._xaResource != null) {
                this._txManager.delistResource(poolEntry._xaResource, bl ? 0x4000000 : 0x20000000);
            }
            if (bl) {
                ++this._available;
                int n3 = this._limits.getMaxRetain();
                if (n3 > 0) {
                    long l2 = poolEntry._timeStamp + (long)(n3 * 1000);
                    if (this._nextExpiration == 0L || this._nextExpiration > l2) {
                        this._nextExpiration = l2;
                    }
                }
                this.notifyAll();
            } else {
                this.discard(pooledConnection, false);
            }
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to release connection " + poolEntry._pooled + " by connection pool " + this), (Throwable)exception);
            this.discard(poolEntry._pooled, false);
        }
        if (this._logWriter != null) {
            this._logWriter.println("Released connection " + pooledConnection);
        }
        return true;
    }

    private synchronized boolean discardNext() {
        PoolEntry poolEntry = null;
        int n = this._pool.length;
        while (n-- > 0) {
            poolEntry = this._pool[n];
            if (poolEntry != null) {
                if (poolEntry._available) {
                    this._pool[n] = poolEntry._nextEntry;
                    break;
                }
                PoolEntry poolEntry2 = poolEntry._nextEntry;
                while (poolEntry2 != null) {
                    if (poolEntry2._available) {
                        poolEntry._nextEntry = poolEntry2._nextEntry;
                        poolEntry = poolEntry2;
                        break;
                    }
                    poolEntry = poolEntry2;
                    poolEntry2 = poolEntry2._nextEntry;
                }
                if (poolEntry2 != null) break;
            }
            poolEntry = null;
        }
        if (poolEntry == null) {
            return false;
        }
        try {
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            this.recordDiscard();
            poolEntry._pooled.removeConnectionEventListener(this);
            poolEntry._pooled.close();
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to destory connection " + poolEntry._pooled + " by connection pool " + this), (Throwable)exception);
        }
        this.notifyAll();
        if (this._logWriter != null) {
            this._logWriter.println("Discarded connection " + poolEntry._pooled);
        }
        return true;
    }

    private synchronized boolean discard(PooledConnection pooledConnection, boolean bl) {
        if (pooledConnection == null) {
            return false;
        }
        int n = pooledConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        if (poolEntry == null) {
            return false;
        }
        if (n == poolEntry._hashCode && poolEntry._pooled.equals(pooledConnection)) {
            this._pool[n2] = poolEntry._nextEntry;
            if (!poolEntry._available) {
                this._category.error((Object)("Connector error: Discarded connection " + pooledConnection + " not in pool"));
                return false;
            }
        } else {
            PoolEntry poolEntry2 = poolEntry._nextEntry;
            while (poolEntry2 != null) {
                if (n == poolEntry2._hashCode && poolEntry2._pooled.equals(pooledConnection)) {
                    if (!poolEntry2._available) {
                        this._category.error((Object)("Connector error: Discarded connection " + pooledConnection + " not in pool"));
                        return false;
                    }
                    poolEntry._nextEntry = poolEntry2._nextEntry;
                    poolEntry = poolEntry2;
                    break;
                }
                poolEntry = poolEntry2;
                poolEntry2 = poolEntry._nextEntry;
            }
            if (poolEntry2 == null) {
                this._category.error((Object)("Connector error: Discarded connection " + pooledConnection + " not in pool"));
                return false;
            }
        }
        try {
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            if (bl) {
                this.recordDiscard();
            } else {
                this.recordError();
            }
            poolEntry._pooled.removeConnectionEventListener(this);
            poolEntry._pooled.close();
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to destory connection " + poolEntry._pooled + " by connection pool " + this), (Throwable)exception);
        }
        this.notifyAll();
        if (this._logWriter != null) {
            this._logWriter.println("Discarded connection " + pooledConnection);
        }
        return true;
    }

    protected synchronized long expire() {
        int n = this._limits.getMaxRetain();
        if (n == 0) {
            return 0L;
        }
        n *= 1000;
        long l = Clock.clock();
        if (l >= this._nextExpiration) {
            long l2 = l - (long)n;
            long l3 = 0L;
            int n2 = this._pool.length;
            while (n2-- > 0) {
                PoolEntry poolEntry = null;
                PoolEntry poolEntry2 = this._pool[n2];
                while (poolEntry2 != null) {
                    if (poolEntry2._available) {
                        if (poolEntry2._timeStamp <= l2) {
                            if (poolEntry == null) {
                                this._pool[n2] = poolEntry2._nextEntry;
                            } else {
                                poolEntry._nextEntry = poolEntry2._nextEntry;
                            }
                            this.recordUnusedDuration((int)(l - poolEntry2._timeStamp));
                            this.recordDiscard();
                            try {
                                poolEntry2._pooled.removeConnectionEventListener(this);
                                poolEntry2._pooled.close();
                            }
                            catch (Exception exception) {
                                this._category.error((Object)("Error attempting to destory connection " + poolEntry2._pooled + " by connection pool " + this), (Throwable)exception);
                            }
                            poolEntry2 = poolEntry2._nextEntry;
                            continue;
                        }
                        if (l3 == 0L || l3 > poolEntry2._timeStamp) {
                            l3 = poolEntry2._timeStamp;
                        }
                        poolEntry = poolEntry2;
                        poolEntry2 = poolEntry2._nextEntry;
                        continue;
                    }
                    poolEntry = poolEntry2;
                    poolEntry2 = poolEntry2._nextEntry;
                }
            }
            if (l3 != 0L) {
                l3 += (long)n;
            }
            this._nextExpiration = l3;
        }
        return this._nextExpiration;
    }

    private PooledConnection matchPooledConnections(String string, String string2) {
        int n = this._pool.length;
        while (n-- > 0) {
            PoolEntry poolEntry = this._pool[n];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    if (string == null && poolEntry._user == null) {
                        return poolEntry._pooled;
                    }
                    if (string != null && poolEntry._user != null && string.equals(poolEntry._user) && (string2 == null && poolEntry._password == null || string2 != null && poolEntry._password != null && string2.equals(poolEntry._password))) {
                        return poolEntry._pooled;
                    }
                }
                poolEntry = poolEntry._nextEntry;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

