/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc.xa;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import tyrex.resource.jdbc.xa.TxConnection;
import tyrex.resource.jdbc.xa.XAConnectionImpl;
import tyrex.services.Clock;
import tyrex.util.BackgroundThread;

public abstract class XADataSourceImpl
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Serializable,
Runnable {
    private transient Hashtable _txConnections = new Hashtable();
    private transient ArrayList _pool = new ArrayList();
    private transient BackgroundThread _background = new BackgroundThread((Runnable)this, (long)(this._txTimeout * 1000), "XADataSource Timeout Daemon");
    private int _txTimeout = 10;
    private float _pruneFactor = 0.1f;
    private static final float DEFAULT_PRUNE_FACTOR = 0.1f;
    public static final int DEFAULT_TX_TIMEOUT = 10;
    private int _isolationLevel = 2;
    public static final int DEFAULT_ISOLATION_LEVEL = 2;

    public XADataSourceImpl() {
        this._background.setPriority(1);
        this._background.setDaemon(true);
        this._background.start();
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        return new XAConnectionImpl(this, null, string, string2);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return new XAConnectionImpl(this, this.newConnection(string, string2), string, string2);
    }

    public final int getTransactionTimeout() {
        return this._txTimeout;
    }

    public abstract PrintWriter getLogWriter();

    public final void setTransactionTimeout(int n) {
        int n2 = this._txTimeout;
        this._txTimeout = n <= 0 ? 10 : n;
        if (n2 != this._txTimeout) {
            this._background.setWait(this._txTimeout * 1000);
            this._background.interrupt();
        }
    }

    TxConnection getTxConnection(Xid xid) {
        return (TxConnection)this._txConnections.get(xid);
    }

    TxConnection setTxConnection(Xid xid, TxConnection txConnection) {
        if (txConnection == null) {
            return (TxConnection)this._txConnections.remove(xid);
        }
        return this._txConnections.put(xid, txConnection);
    }

    void releaseConnection(Connection connection, String string, String string2) {
        if (null != connection) {
            ArrayList arrayList = this._pool;
            synchronized (arrayList) {
                this._pool.add(new ConnectionEntry(connection, this.getAccount(string, string2)));
            }
        }
    }

    private String getAccount(String string, String string2) {
        if (string == null) {
            return "";
        }
        if (string2 == null) {
            return string;
        }
        return string + ":" + string2;
    }

    Connection newConnection(String string, String string2) throws SQLException {
        ArrayList arrayList = this._pool;
        synchronized (arrayList) {
            if (!this._pool.isEmpty()) {
                String string3 = this.getAccount(string, string2);
                Iterator iterator = ((AbstractList)this._pool).iterator();
                while (iterator.hasNext()) {
                    ConnectionEntry connectionEntry = (ConnectionEntry)iterator.next();
                    if (!connectionEntry._account.equals(string3)) continue;
                    iterator.remove();
                    connectionEntry._connection.setTransactionIsolation(this._isolationLevel);
                    Connection connection = connectionEntry._connection;
                    return connection;
                }
            }
        }
        Connection connection = this.getConnection(string, string2);
        connection.setTransactionIsolation(this._isolationLevel);
        return connection;
    }

    Xid[] getTxRecover() {
        Vector<Xid> vector = new Vector<Xid>();
        Enumeration enumeration = this._txConnections.elements();
        while (enumeration.hasMoreElements()) {
            TxConnection txConnection = (TxConnection)enumeration.nextElement();
            if (txConnection.conn == null || !txConnection.prepared) continue;
            vector.add(txConnection.xid);
        }
        return vector.toArray(new Xid[vector.size()]);
    }

    public final int getIsolationLevel() {
        return this._isolationLevel;
    }

    public final void setIsolationLevel(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException("Invalid isolation level " + n);
        }
        this._isolationLevel = n;
    }

    public final float getPruneFactor() {
        return this._pruneFactor;
    }

    public final void setPruneFactor(float f) {
        if (0.0f > f || 1.0f < f) {
            throw new IllegalArgumentException("The argument 'pruneFactor' " + f + " does not lie between 0 and 1.");
        }
        this._pruneFactor = f;
    }

    public void run() {
        Object object;
        if (this._pruneFactor > 0.0f) {
            object = this._pool;
            synchronized (object) {
                block24: {
                    try {
                        int n = this._pool.size();
                        int n2 = (1.0f == this._pruneFactor ? n : n - (int)((float)n * this._pruneFactor)) - 1;
                        if (n2 < 0 || n <= n2) break block24;
                        if (this.getLogWriter() != null) {
                            this.getLogWriter().println("DataSource " + this.toString() + ": Reducing internal connection pool size from " + n + " to " + n2);
                        }
                        Iterator iterator = ((AbstractList)this._pool).iterator();
                        do {
                            try {
                                ((ConnectionEntry)iterator.next())._connection.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            iterator.remove();
                        } while (--n > n2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        long l = Clock.clock();
        Enumeration enumeration = this._txConnections.elements();
        while (enumeration.hasMoreElements()) {
            TxConnection txConnection = (TxConnection)enumeration.nextElement();
            if (txConnection.conn == null) {
                this._txConnections.remove(txConnection.xid);
                enumeration = this._txConnections.elements();
                continue;
            }
            if (txConnection.timeout >= l) continue;
            try {
                XADataSourceImpl xADataSourceImpl = this;
                synchronized (xADataSourceImpl) {
                    if (txConnection.conn == null) {
                        continue;
                    }
                    if (this.getLogWriter() != null) {
                        this.getLogWriter().println("DataSource " + this.toString() + ": Transaction timed out and being aborted: " + txConnection.xid);
                    }
                    object = txConnection.conn;
                    txConnection.conn = null;
                    txConnection.timedOut = true;
                    try {
                        object.rollback();
                        this.releaseConnection((Connection)object, txConnection.userName, txConnection.password);
                    }
                    catch (SQLException sQLException) {
                        if (this.getLogWriter() != null) {
                            this.getLogWriter().println("DataSource " + this.toString() + ": Error aborting timed out transaction: " + sQLException);
                        }
                        try {
                            object.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(PrintWriter printWriter) {
        printWriter.println("Debug info for XADataSource:");
        Enumeration enumeration = this._txConnections.elements();
        if (!enumeration.hasMoreElements()) {
            printWriter.println("Empty");
        }
        while (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            TxConnection txConnection = (TxConnection)enumeration.nextElement();
            stringBuffer.append("TxConnection ");
            if (txConnection.xid != null) {
                stringBuffer.append(txConnection.xid);
            }
            if (txConnection.conn != null) {
                stringBuffer.append(' ').append(txConnection.conn);
            }
            stringBuffer.append(" count: ").append(txConnection.count);
            if (txConnection.prepared) {
                stringBuffer.append(" prepared");
            }
            if (txConnection.timedOut) {
                stringBuffer.append(" timed-out");
            }
            if (txConnection.readOnly) {
                stringBuffer.append(" read-only");
            }
            printWriter.println(stringBuffer.toString());
        }
        Iterator iterator = ((AbstractList)this._pool).iterator();
        while (iterator.hasNext()) {
            printWriter.println("Pooled underlying: " + iterator.next().toString());
        }
    }

    public abstract void setLoginTimeout(int var1) throws SQLException;

    public abstract void setLogWriter(PrintWriter var1) throws SQLException;

    public abstract int getLoginTimeout() throws SQLException;

    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    public abstract Connection getConnection() throws SQLException;

    private static class ConnectionEntry {
        private final String _account;
        private final Connection _connection;

        private ConnectionEntry(Connection connection, String string) {
            this._connection = connection;
            this._account = string;
        }

        public String toString() {
            return this._connection.toString();
        }
    }
}

