/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.javagroups.JChannel;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.HAPartitionImpl;
import org.jboss.system.ServiceMBeanSupport;

public class ClusterPartition
extends ServiceMBeanSupport
implements ClusterPartitionMBean {
    protected String partitionName = "DefaultPartition";
    protected String jgProps = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=64;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000;min_wait_time=2000):FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    protected HAPartitionImpl partition;
    protected boolean deadlock_detection = false;
    protected JChannel channel;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newName) {
        this.partitionName = newName;
    }

    public String getPartitionProperties() {
        return this.jgProps;
    }

    public void setPartitionProperties(String newProps) {
        this.jgProps = newProps;
    }

    public boolean getDeadlockDetection() {
        return this.deadlock_detection;
    }

    public void setDeadlockDetection(boolean doit) {
        this.deadlock_detection = doit;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? ClusterPartitionMBean.OBJECT_NAME : name;
    }

    public HAPartition getHAPartition() {
        return this.partition;
    }

    public String getName() {
        return this.partitionName;
    }

    protected void createService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"Creating JavaGroups JChannel");
        }
        this.channel = new JChannel((Object)this.jgProps);
        this.channel.setOpt(3, (Object)new Boolean(false));
        this.channel.setOpt(4, (Object)new Boolean(true));
        this.channel.setOpt(5, (Object)new Boolean(true));
        this.channel.setOpt(6, (Object)new Boolean(true));
        if (debug) {
            this.log.debug((Object)"Creating HAPartition");
        }
        this.partition = new HAPartitionImpl(this.partitionName, this.channel, this.deadlock_detection, this.getServer());
        if (debug) {
            this.log.debug((Object)("Initing HAPartition: " + this.partition));
        }
        this.partition.init();
        if (debug) {
            this.log.debug((Object)"HAPartition initialized");
        }
    }

    protected void startService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Starting ClusterPartition: " + this.partitionName));
        }
        this.log.info((Object)"Connecting to channel");
        this.channel.connect(this.partitionName);
        this.log.info((Object)"Starting channel");
        this.partition.startPartition();
        this.log.info((Object)("Started ClusterPartition: " + this.partitionName));
    }

    protected void stopService() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping HAPartition: " + this.partitionName));
        }
        this.partition.closePartition();
    }
}

