/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.ha.framework.interfaces.SubPartitionInfo;
import org.jboss.ha.framework.interfaces.SubPartitionsInfo;
import org.jboss.ha.hasessionstate.server.HASessionStateTopologyComputer;

public class HASessionStateTopologyComputerImpl
implements HASessionStateTopologyComputer {
    protected long nodesPerSubPartition = 0L;
    protected String sessionStateIdentifier = null;

    public void init(String sessionStateName, long nodesPerSubPartition) {
        this.sessionStateIdentifier = sessionStateName;
        this.nodesPerSubPartition = nodesPerSubPartition;
    }

    public void start() {
    }

    public SubPartitionsInfo computeNewTopology(SubPartitionsInfo currentTopology, ArrayList newReplicants) {
        if (newReplicants.size() < 1) {
            currentTopology.partitions = null;
        } else if (newReplicants.size() == 1) {
            if (currentTopology.partitions != null) {
                currentTopology = this.computeCompatibleComposition(currentTopology, newReplicants);
            } else {
                SubPartitionInfo aPartition = new SubPartitionInfo();
                aPartition.subPartitionName = this.getSubPartitionName(currentTopology);
                aPartition.memberNodeNames.add(newReplicants.get(0));
                SubPartitionInfo[] thePartition = new SubPartitionInfo[]{aPartition};
                currentTopology.partitions = thePartition;
            }
        } else {
            currentTopology = currentTopology == null || currentTopology.partitions == null ? this.computerFirstComposition(currentTopology, newReplicants) : this.computeCompatibleComposition(currentTopology, newReplicants);
        }
        return currentTopology;
    }

    protected SubPartitionsInfo computerFirstComposition(SubPartitionsInfo splitingInfo, ArrayList replicants) {
        int i = 0;
        String rep = null;
        ArrayList<SubPartitionInfo> newConfig = new ArrayList<SubPartitionInfo>();
        SubPartitionInfo aPartition = null;
        int grpNumber = 0;
        Iterator reps = replicants.iterator();
        while (reps.hasNext()) {
            rep = (String)reps.next();
            if ((long)i % this.nodesPerSubPartition == 0L) {
                ++grpNumber;
                aPartition = new SubPartitionInfo();
                aPartition.subPartitionName = this.getSubPartitionName(splitingInfo);
                newConfig.add(aPartition);
            }
            aPartition.memberNodeNames.add(rep);
            ++i;
        }
        if (aPartition.memberNodeNames.size() == 1) {
            rep = (String)aPartition.memberNodeNames.get(0);
            newConfig.remove(grpNumber - 1);
            aPartition = (SubPartitionInfo)newConfig.get(grpNumber - 1);
            aPartition.memberNodeNames.add(rep);
        }
        SubPartitionInfo[] newSpliting = new SubPartitionInfo[1];
        newSpliting = newConfig.toArray(newSpliting);
        splitingInfo.partitions = newSpliting;
        return splitingInfo;
    }

    protected SubPartitionsInfo computeCompatibleComposition(SubPartitionsInfo splitingInfo, ArrayList replicants) {
        SubPartitionInfo[] newSpliting = null;
        ArrayList<SubPartitionInfo> newSubParts = new ArrayList<SubPartitionInfo>();
        int i = 0;
        while (i < splitingInfo.partitions.length) {
            SubPartitionInfo currentSubPart = splitingInfo.partitions[i];
            SubPartitionInfo newCurrent = null;
            Iterator iter = currentSubPart.memberNodeNames.iterator();
            while (iter.hasNext()) {
                String node = (String)iter.next();
                if (!replicants.contains(node)) continue;
                if (newCurrent == null) {
                    newCurrent = (SubPartitionInfo)currentSubPart.clone();
                    newCurrent.memberNodeNames.clear();
                }
                newCurrent.memberNodeNames.add(node);
            }
            if (newCurrent != null) {
                newSubParts.add(newCurrent);
            }
            ++i;
        }
        Iterator iter = replicants.iterator();
        ArrayList<String> newMembersNotInAGroup = new ArrayList<String>();
        while (iter.hasNext()) {
            boolean found = false;
            String aMember = (String)iter.next();
            Iterator iterNewSubPart = newSubParts.iterator();
            while (iterNewSubPart.hasNext() && !found) {
                if (!((SubPartitionInfo)iterNewSubPart.next()).memberNodeNames.contains(aMember)) continue;
                found = true;
            }
            if (found) continue;
            newMembersNotInAGroup.add(aMember);
        }
        iter = null;
        boolean curs = false;
        ArrayList smallerGroups = new ArrayList();
        ArrayList correctlySizedGroups = new ArrayList();
        ArrayList biggerGroups = new ArrayList();
        int i2 = 0;
        while (i2 < newSubParts.size()) {
            int groupSize = ((SubPartitionInfo)newSubParts.get((int)i2)).memberNodeNames.size();
            if ((long)groupSize < this.nodesPerSubPartition) {
                smallerGroups.add(newSubParts.get(i2));
            } else if ((long)groupSize > this.nodesPerSubPartition) {
                biggerGroups.add(newSubParts.get(i2));
            } else {
                correctlySizedGroups.add(newSubParts.get(i2));
            }
            ++i2;
        }
        Collections.sort(smallerGroups);
        iter = newMembersNotInAGroup.iterator();
        while (iter.hasNext()) {
            String member = (String)iter.next();
            SubPartitionInfo target = null;
            if (smallerGroups.size() > 0) {
                target = (SubPartitionInfo)smallerGroups.get(0);
                target.memberNodeNames.add(member);
                if ((long)target.memberNodeNames.size() != this.nodesPerSubPartition) continue;
                smallerGroups.remove(0);
                correctlySizedGroups.add(target);
                continue;
            }
            target = new SubPartitionInfo();
            target.setIsNewGroup();
            target.subPartitionName = this.getSubPartitionName(splitingInfo);
            target.memberNodeNames.add(member);
            smallerGroups.add(target);
            Collections.sort(smallerGroups);
        }
        iter = biggerGroups.iterator();
        while (iter.hasNext()) {
            SubPartitionInfo big = (SubPartitionInfo)iter.next();
            if (smallerGroups.size() <= 0) continue;
            String member = (String)big.memberNodeNames.get(big.memberNodeNames.size() - 1);
            SubPartitionInfo target = null;
            target = (SubPartitionInfo)smallerGroups.get(0);
            target.memberNodeNames.add(member);
            big.memberNodeNames.remove(big.memberNodeNames.size() - 1);
            if ((long)target.memberNodeNames.size() != this.nodesPerSubPartition) continue;
            smallerGroups.remove(0);
            correctlySizedGroups.add(target);
        }
        correctlySizedGroups.addAll(biggerGroups);
        boolean thirdStepFinished = smallerGroups.size() == 0;
        while (!thirdStepFinished) {
            SubPartitionInfo current = (SubPartitionInfo)smallerGroups.get(smallerGroups.size() - 1);
            int i3 = smallerGroups.size() - 2;
            while (i3 >= 0) {
                SubPartitionInfo merger = (SubPartitionInfo)smallerGroups.get(i3);
                if ((long)(merger.memberNodeNames.size() + current.memberNodeNames.size()) <= this.nodesPerSubPartition) {
                    current.merge(merger);
                    smallerGroups.remove(i3);
                }
                if ((long)current.memberNodeNames.size() == this.nodesPerSubPartition) break;
                --i3;
            }
            if (current.memberNodeNames.size() > 1) {
                smallerGroups.remove(smallerGroups.size() - 1);
                correctlySizedGroups.add(current);
            }
            boolean bl = thirdStepFinished = smallerGroups.size() == 0 || smallerGroups.size() == 1 && ((SubPartitionInfo)smallerGroups.get((int)0)).memberNodeNames.size() == 1;
        }
        if (smallerGroups.size() > 0) {
            if (correctlySizedGroups.size() > 0) {
                Collections.sort(correctlySizedGroups);
                SubPartitionInfo merger = (SubPartitionInfo)smallerGroups.get(0);
                SubPartitionInfo master = (SubPartitionInfo)correctlySizedGroups.get(0);
                master.merge(merger);
            } else {
                correctlySizedGroups.add(smallerGroups.get(0));
            }
        }
        newSpliting = new SubPartitionInfo[1];
        newSpliting = correctlySizedGroups.toArray(newSpliting);
        splitingInfo.partitions = newSpliting;
        return splitingInfo;
    }

    protected String getSubPartitionName(SubPartitionsInfo manager) {
        return this.sessionStateIdentifier + "-Group-" + manager.getNextGroupId();
    }
}

