/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.server;

import java.rmi.MarshalledObject;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxyHA;
import org.jboss.invocation.jrmp.server.JRMPInvoker;
import org.jboss.system.Registry;

public class JRMPInvokerHA
extends JRMPInvoker {
    protected HashMap beanMap = new HashMap();

    public String getName() {
        return "JRMPInvokerHA";
    }

    public void start() throws Exception {
        if (this.getState() != 0 && this.getState() != 4) {
            return;
        }
        this.state = 2;
        this.log.info((Object)"Starting");
        try {
            this.exportCI();
            Registry.bind((Object)this.serviceName, (Object)((Object)this));
        }
        catch (Exception e) {
            this.state = 4;
            this.log.error((Object)"Failed", (Throwable)e);
            throw new ServerException("Could not bind HA JRMP invoker", e);
        }
        this.state = 3;
        this.log.info((Object)"Started");
    }

    public void stop() {
        if (this.getState() != 3) {
            return;
        }
        this.state = 1;
        this.log.info((Object)"Stopping");
        try {
            this.unexportCI();
        }
        catch (Throwable e) {
            this.state = 4;
            this.log.error((Object)"Failed", e);
            return;
        }
        this.state = 0;
        this.log.info((Object)"Stopped");
    }

    public void destroy() {
    }

    public void registerBean(String beanName, HATarget target) throws Exception {
        Integer hash = new Integer(new ObjectName(beanName).hashCode());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("BEAN NAME IS " + beanName));
        }
        if (this.beanMap.containsKey(hash)) {
            throw new IllegalStateException("Trying to register bean with the existing hashCode");
        }
        this.beanMap.put(hash, target);
    }

    public JRMPInvokerProxy createProxy(String beanName, LoadBalancePolicy policy) throws Exception {
        Integer hash = new Integer(new ObjectName(beanName).hashCode());
        HATarget target = (HATarget)this.beanMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The bean hashCode not found");
        }
        return new JRMPInvokerProxyHA(target.getReplicants(), policy);
    }

    public void unregisterBean(String beanName) throws Exception {
        Integer hash = new Integer(new ObjectName(beanName).hashCode());
        this.beanMap.remove(hash);
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                invocation.setTransaction(this.importTPC(((MarshalledInvocation)invocation).getTransactionPropagationContext()));
                ObjectName mbean = (ObjectName)Registry.lookup((Object)((Integer)invocation.getObjectName()));
                long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
                Object rtn = this.server.invoke(mbean, "", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
                HARMIResponse rsp = new HARMIResponse();
                HATarget target = (HATarget)this.beanMap.get((Integer)invocation.getObjectName());
                if (target == null) {
                    throw new IllegalStateException("The bean hashCode not found");
                }
                if (clientViewId != target.getCurrentViewId()) {
                    rsp.newReplicants = new ArrayList(target.getReplicants());
                    rsp.currentViewId = target.getCurrentViewId();
                }
                rsp.response = rtn;
                MarshalledObject<HARMIResponse> marshalledObject = new MarshalledObject<HARMIResponse>(rsp);
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                return marshalledObject;
            }
            catch (InstanceNotFoundException infe) {
                throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, infe.getMessage());
            }
            catch (ReflectionException ie) {
                throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, ie.getMessage());
            }
            catch (MBeanException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }
}

