/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref.dom2dtm;

import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class DOM2DTM
extends DTMDefaultBaseIterators {
    static final boolean JJK_DEBUG = false;
    private transient Node m_pos;
    private int m_last_parent = 0;
    private int m_last_kid = -1;
    private transient Node m_root;
    boolean m_processedFirstElement = false;
    private transient boolean m_nodesAreProcessed;
    protected Vector m_nodes = new Vector();
    TreeWalker m_walker = new TreeWalker(null);

    public DOM2DTM(DTMManager dTMManager, DOMSource dOMSource, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        super(dTMManager, dOMSource, n, dTMWSFilter, xMLStringFactory, bl);
        this.m_pos = this.m_root = dOMSource.getNode();
        this.m_last_kid = -1;
        this.m_last_parent = -1;
        this.m_last_kid = this.addNode(this.m_root, this.m_last_parent, this.m_last_kid, -1);
        if (this.m_root.getNodeType() == 1) {
            int n2;
            NamedNodeMap namedNodeMap = this.m_root.getAttributes();
            int n3 = n2 = namedNodeMap == null ? 0 : namedNodeMap.getLength();
            if (n2 > 0) {
                int n4 = -1;
                int n5 = 0;
                while (n5 < n2) {
                    n4 = this.addNode(namedNodeMap.item(n5), 0, n4, -1);
                    this.m_firstch.setElementAt(-1, n4);
                    ++n5;
                }
                this.m_nextsib.setElementAt(-1, n4);
            }
        }
        this.m_nodesAreProcessed = false;
    }

    protected int addNode(Node node, int n, int n2, int n3) {
        String string;
        String string2;
        int n4 = this.m_nodes.size();
        ++this.m_size;
        int n5 = n3 == -1 ? (int)node.getNodeType() : n3;
        if (n5 == 2 && ((string2 = node.getNodeName()).startsWith("xmlns:") || string2.equals("xmlns"))) {
            n5 = 13;
        }
        this.m_nodes.addElement(node);
        this.m_firstch.setElementAt(-2, n4);
        this.m_nextsib.setElementAt(-2, n4);
        this.m_prevsib.setElementAt(n2, n4);
        this.m_parent.setElementAt(n, n4);
        if (n != -1 && n5 != 2 && n5 != 13 && this.m_firstch.elementAt(n) == -2) {
            this.m_firstch.setElementAt(n4, n);
        }
        string2 = node.getNamespaceURI();
        String string3 = string = n5 == 7 ? node.getNodeName() : node.getLocalName();
        if ((n5 == 1 || n5 == 2) && string == null) {
            string = node.getNodeName();
        }
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        boolean bl = node.getLocalName() == null && (n5 == 1 || n5 == 2);
        int n6 = string != null ? expandedNameTable.getExpandedTypeID(string2, string, n5) : expandedNameTable.getExpandedTypeID(n5);
        this.m_exptype.setElementAt(n6, n4);
        this.indexNode(n6, n4);
        if (n2 != -1) {
            this.m_nextsib.setElementAt(n4, n2);
        }
        if (n5 == 13) {
            this.declareNamespaceInContext(n, n4);
        }
        return n4;
    }

    public void dispatchCharactersEvents(int n, ContentHandler contentHandler, boolean bl) throws SAXException {
        if (bl) {
            XMLString xMLString = this.getStringValue(n);
            xMLString = xMLString.fixWhiteSpace(true, true, false);
            xMLString.dispatchCharactersEvents(contentHandler);
        } else {
            short s = this.getNodeType(n);
            Node node = this.getNode(n);
            DOM2DTM.dispatchNodeData(node, contentHandler, 0);
            if (s == 3 || s == 4) {
                while ((node = this.logicalNextDOMTextNode(node)) != null) {
                    DOM2DTM.dispatchNodeData(node, contentHandler, 0);
                }
            }
        }
    }

    protected static void dispatchNodeData(Node node, ContentHandler contentHandler, int n) throws SAXException {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    DOM2DTM.dispatchNodeData(node2, contentHandler, n + 1);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 7: 
            case 8: {
                if (n != 0) break;
            }
            case 2: 
            case 3: 
            case 4: {
                String string = node.getNodeValue();
                if (contentHandler instanceof CharacterNodeHandler) {
                    ((CharacterNodeHandler)((Object)contentHandler)).characters(node);
                    break;
                }
                contentHandler.characters(string.toCharArray(), 0, string.length());
                break;
            }
        }
    }

    public void dispatchToEvents(int n, ContentHandler contentHandler) throws SAXException {
        TreeWalker treeWalker = this.m_walker;
        ContentHandler contentHandler2 = treeWalker.getContentHandler();
        if (contentHandler2 != null) {
            treeWalker = new TreeWalker(null);
        }
        treeWalker.setContentHandler(contentHandler);
        try {
            Node node = this.getNode(n);
            treeWalker.traverse(node);
        }
        finally {
            Object var6_6 = null;
            treeWalker.setContentHandler(null);
        }
    }

    public int getAttributeNode(int n, String string, String string2) {
        short s;
        if (string == null) {
            string = "";
        }
        if ((s = this.getNodeType(n)) == 1) {
            int n2 = n & 0x3FFFFF;
            while ((n2 = this.getNextNodeIdentity(n2)) != -1) {
                s = this.getNodeType(n2);
                if (s == 2) {
                    Node node = this.lookupNode(n2);
                    String string3 = node.getNamespaceURI();
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = node.getLocalName();
                    if (!string3.equals(string) || !string2.equals(string4)) continue;
                    return n2 | this.m_dtmIdent;
                }
                if (s != 13) break;
            }
        }
        return -1;
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public DeclHandler getDeclHandler() {
        return null;
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        DocumentType documentType;
        Document document = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (document != null && (documentType = document.getDoctype()) != null) {
            return documentType.getPublicId();
        }
        return null;
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        DocumentType documentType;
        Document document = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (document != null && (documentType = document.getDoctype()) != null) {
            return documentType.getSystemId();
        }
        return null;
    }

    public int getElementById(String string) {
        Element element;
        Document document;
        Document document2 = document = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (document != null && (element = document.getElementById(string)) != null) {
            int n = this.getHandleFromNode(element);
            if (n == -1) {
                int n2 = this.m_nodes.size() - 1;
                while ((n2 = this.getNextNodeIdentity(n2)) != -1) {
                    Node node = this.getNode(n2);
                    if (node != element) continue;
                    n = this.getHandleFromNode(element);
                    break;
                }
            }
            return n;
        }
        return -1;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    private int getHandleFromNode(Node node) {
        if (node != null) {
            int n = this.m_nodes.size();
            int n2 = 0;
            while (true) {
                if (n2 < n) {
                    if (this.m_nodes.elementAt(n2) == node) {
                        return n2 | this.m_dtmIdent;
                    }
                    ++n2;
                    continue;
                }
                boolean bl = this.nextNode();
                n = this.m_nodes.size();
                if (!bl && n2 >= n) break;
            }
        }
        return -1;
    }

    public int getHandleOfNode(Node node) {
        if (node != null && (this.m_root == node || this.m_root.getNodeType() == 9 && this.m_root == node.getOwnerDocument() || this.m_root.getNodeType() != 9 && this.m_root.getOwnerDocument() == node.getOwnerDocument())) {
            Node node2 = node;
            while (node2 != null) {
                if (node2 == this.m_root) {
                    return this.getHandleFromNode(node);
                }
                Node node3 = node2 = node2.getNodeType() != 2 ? node2.getParentNode() : ((Attr)node2).getOwnerElement();
            }
        }
        return -1;
    }

    public LexicalHandler getLexicalHandler() {
        return null;
    }

    public String getLocalName(int n) {
        String string;
        short s = this.getNodeType(n);
        switch (s) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                Node node = this.getNode(n);
                string = node.getLocalName();
                if (string != null) break;
                String string2 = node.getNodeName();
                int n2 = string2.indexOf(58);
                string = n2 < 0 ? string2 : string2.substring(n2 + 1);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getNamespaceURI(int n) {
        String string;
        short s = this.getNodeType(n);
        switch (s) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                Node node = this.getNode(n);
                string = node.getNamespaceURI();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    protected int getNextNodeIdentity(int n) {
        if (++n >= this.m_nodes.size() && !this.nextNode()) {
            n = -1;
        }
        return n;
    }

    public Node getNode(int n) {
        int n2 = n & 0x3FFFFF;
        return (Node)this.m_nodes.elementAt(n2);
    }

    protected static void getNodeData(Node node, FastStringBuffer fastStringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    DOM2DTM.getNodeData(node2, fastStringBuffer);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                fastStringBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    public String getNodeName(int n) {
        Node node = this.getNode(n);
        return node.getNodeName();
    }

    public String getNodeNameX(int n) {
        String string;
        short s = this.getNodeType(n);
        switch (s) {
            case 13: {
                Node node = this.getNode(n);
                string = node.getNodeName();
                if (string.startsWith("xmlns:")) {
                    string = QName.getLocalPart(string);
                    break;
                }
                if (!string.equals("xmlns")) break;
                string = "";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                Node node = this.getNode(n);
                string = node.getNodeName();
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getNodeValue(int n) {
        short s = this._type(n);
        if (s != 3 && s != 4) {
            return this.getNode(n).getNodeValue();
        }
        Node node = this.getNode(n);
        Node node2 = this.logicalNextDOMTextNode(node);
        if (node2 == null) {
            return node.getNodeValue();
        }
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        fastStringBuffer.append(node.getNodeValue());
        while (node2 != null) {
            fastStringBuffer.append(node2.getNodeValue());
            node2 = this.logicalNextDOMTextNode(node2);
        }
        String string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
        StringBufferPool.free(fastStringBuffer);
        return string;
    }

    protected int getNumberOfNodes() {
        return this.m_nodes.size();
    }

    public String getPrefix(int n) {
        String string;
        short s = this.getNodeType(n);
        switch (s) {
            case 13: {
                Node node = this.getNode(n);
                String string2 = node.getNodeName();
                int n2 = string2.indexOf(58);
                string = n2 < 0 ? "" : string2.substring(n2 + 1);
                break;
            }
            case 1: 
            case 2: {
                Node node = this.getNode(n);
                String string3 = node.getNodeName();
                int n3 = string3.indexOf(58);
                string = n3 < 0 ? "" : string3.substring(0, n3);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public SourceLocator getSourceLocatorFor(int n) {
        return null;
    }

    public XMLString getStringValue(int n) {
        short s = this.getNodeType(n);
        Node node = this.getNode(n);
        if (s == 1 || s == 9 || s == 11) {
            String string;
            FastStringBuffer fastStringBuffer = StringBufferPool.get();
            try {
                DOM2DTM.getNodeData(node, fastStringBuffer);
                string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
            }
            finally {
                Object var7_8 = null;
                StringBufferPool.free(fastStringBuffer);
            }
            return this.m_xstrf.newstr(string);
        }
        if (s == 3 || s == 4) {
            FastStringBuffer fastStringBuffer = StringBufferPool.get();
            while (node != null) {
                fastStringBuffer.append(node.getNodeValue());
                node = this.logicalNextDOMTextNode(node);
            }
            String string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
            StringBufferPool.free(fastStringBuffer);
            return this.m_xstrf.newstr(string);
        }
        return this.m_xstrf.newstr(node.getNodeValue());
    }

    public String getUnparsedEntityURI(String string) {
        DocumentType documentType;
        Document document;
        String string2 = "";
        Document document2 = document = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (document != null && (documentType = document.getDoctype()) != null) {
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (namedNodeMap == null) {
                return string2;
            }
            Entity entity = (Entity)namedNodeMap.getNamedItem(string);
            if (entity == null) {
                return string2;
            }
            String string3 = entity.getNotationName();
            if (string3 != null && (string2 = entity.getSystemId()) == null) {
                string2 = entity.getPublicId();
            }
        }
        return string2;
    }

    public boolean isAttributeSpecified(int n) {
        short s = this.getNodeType(n);
        if (s == 2) {
            Attr attr = (Attr)this.getNode(n);
            return attr.getSpecified();
        }
        return false;
    }

    private static boolean isSpace(char c) {
        return XMLCharacterRecognizer.isWhiteSpace(c);
    }

    private Node logicalNextDOMTextNode(Node node) {
        short s;
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            node = node.getParentNode();
            while (node != null && node.getNodeType() == 5) {
                node2 = node.getNextSibling();
                if (node2 != null) break;
                node = node.getParentNode();
            }
        }
        node = node2;
        while (node != null && node.getNodeType() == 5) {
            node = node.hasChildNodes() ? node.getFirstChild() : node.getNextSibling();
        }
        if (node != null && (s = node.getNodeType()) != 3 && s != 4) {
            node = null;
        }
        return node;
    }

    protected Node lookupNode(int n) {
        return (Node)this.m_nodes.elementAt(n);
    }

    public boolean needsTwoThreads() {
        return false;
    }

    protected boolean nextNode() {
        int n;
        if (this.m_nodesAreProcessed) {
            return false;
        }
        Node node = this.m_pos;
        Node node2 = null;
        int n2 = -1;
        do {
            if (node.hasChildNodes()) {
                node2 = node.getFirstChild();
                if (node2 != null && node2.getNodeType() == 10) {
                    node2 = node2.getNextSibling();
                }
                if (node.getNodeType() != 5) {
                    this.m_last_parent = this.m_last_kid;
                    this.m_last_kid = -1;
                    if (this.m_wsfilter != null) {
                        n = this.m_wsfilter.getShouldStripSpace(this.m_last_parent | this.m_dtmIdent, this);
                        boolean bl = n == 3 ? this.getShouldStripWhitespace() : n == 2;
                        this.pushShouldStripWhitespace(bl);
                    }
                }
            } else {
                if (this.m_last_kid != -1 && this.m_firstch.elementAt(this.m_last_kid) == -2) {
                    this.m_firstch.setElementAt(-1, this.m_last_kid);
                }
                while (this.m_last_parent != -1) {
                    node2 = node.getNextSibling();
                    if (node2 != null && node2.getNodeType() == 10) {
                        node2 = node2.getNextSibling();
                    }
                    if (node2 != null) break;
                    if ((node = node.getParentNode()) != null && node.getNodeType() == 5) continue;
                    this.popShouldStripWhitespace();
                    if (this.m_last_kid == -1) {
                        this.m_firstch.setElementAt(-1, this.m_last_parent);
                    } else {
                        this.m_nextsib.setElementAt(-1, this.m_last_kid);
                    }
                    this.m_last_kid = this.m_last_parent;
                    this.m_last_parent = this.m_parent.elementAt(this.m_last_kid);
                }
                if (this.m_last_parent == -1) {
                    node2 = null;
                }
            }
            if (node2 != null) {
                n2 = node2.getNodeType();
            }
            if (n2 != 5) continue;
            node = node2;
        } while (n2 == 5);
        if (node2 == null) {
            this.m_nextsib.setElementAt(-1, 0);
            this.m_nodesAreProcessed = true;
            this.m_pos = null;
            return false;
        }
        n = 0;
        Node node3 = null;
        n2 = node2.getNodeType();
        if (n2 == 3 || n2 == 4) {
            n = this.m_wsfilter == null || !this.getShouldStripWhitespace() ? 0 : 1;
            Node node4 = node2;
            while (node4 != null) {
                node3 = node4;
                if (node4.getNodeType() == 3) {
                    n2 = 3;
                }
                n &= XMLCharacterRecognizer.isWhiteSpace(node4.getNodeValue());
                node4 = this.logicalNextDOMTextNode(node4);
            }
        } else if (n2 == 7) {
            n = node.getNodeName().toLowerCase().equals("xml") ? 1 : 0;
        }
        if (n == 0) {
            int n3;
            this.m_last_kid = n3 = this.addNode(node2, this.m_last_parent, this.m_last_kid, n2);
            if (n2 == 1) {
                int n4;
                Object object;
                int n5 = -1;
                if (!this.m_processedFirstElement) {
                    object = "http://www.w3.org/XML/1998/namespace";
                    n5 = this.addNode(new defaultNamespaceDeclarationNode((Element)node2, "xml", (String)object), n3, n5, -1);
                    this.m_firstch.setElementAt(-1, n5);
                    this.m_processedFirstElement = true;
                }
                int n6 = n4 = (object = node2.getAttributes()) == null ? 0 : object.getLength();
                if (n4 > 0) {
                    int n7 = 0;
                    while (n7 < n4) {
                        n5 = this.addNode(object.item(n7), n3, n5, -1);
                        this.m_firstch.setElementAt(-1, n5);
                        ++n7;
                    }
                }
                if (n5 != -1) {
                    this.m_nextsib.setElementAt(-1, n5);
                }
            }
        }
        if (n2 == 3 || n2 == 4) {
            node2 = node3;
        }
        this.m_pos = node2;
        return true;
    }

    public void setIncrementalSAXSource(IncrementalSAXSource incrementalSAXSource) {
    }

    public void setProperty(String string, Object object) {
    }

    public static interface CharacterNodeHandler {
        public void characters(Node var1) throws SAXException;
    }

    class defaultNamespaceDeclarationNode
    implements Attr {
        final String NOT_SUPPORTED_ERR = "Unsupported operation on pseudonode";
        Element pseudoparent = this.pseudoparent;
        String prefix;
        String uri;

        defaultNamespaceDeclarationNode(Element element, String string, String string2) {
            this.prefix = string;
            this.uri = string2;
        }

        public Node appendChild(Node node) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public Node cloneNode(boolean bl) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public NamedNodeMap getAttributes() {
            return null;
        }

        public NodeList getChildNodes() {
            return null;
        }

        public Node getFirstChild() {
            return null;
        }

        public Node getLastChild() {
            return null;
        }

        public String getLocalName() {
            return this.prefix;
        }

        public String getName() {
            return this.getNodeName();
        }

        public String getNamespaceURI() {
            return "http://www.w3.org/2000/xmlns/";
        }

        public Node getNextSibling() {
            return null;
        }

        public String getNodeName() {
            return "xmlns:" + this.prefix;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeValue() {
            return this.uri;
        }

        public Document getOwnerDocument() {
            return this.pseudoparent.getOwnerDocument();
        }

        public Element getOwnerElement() {
            return this.pseudoparent;
        }

        public Node getParentNode() {
            return null;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Node getPreviousSibling() {
            return null;
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.uri;
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return false;
        }

        public Node insertBefore(Node node, Node node2) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public boolean isSupported(String string, String string2) {
            return false;
        }

        public void normalize() {
        }

        public Node removeChild(Node node) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public Node replaceChild(Node node, Node node2) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public void setNodeValue(String string) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public void setPrefix(String string) {
            throw new DTMException("Unsupported operation on pseudonode");
        }

        public void setValue(String string) {
            throw new DTMException("Unsupported operation on pseudonode");
        }
    }
}

