/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.MessageReceptorPool;
import org.jacorb.orb.connection.NoBiDirServerReplyListener;
import org.jacorb.orb.connection.ReplyListener;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.connection.ServerRequestListener;
import org.jacorb.orb.connection.Server_TCP_IP_Transport;
import org.jacorb.orb.dns.DNSLookup;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter {
    private static SSLServerSocketFactory ssl_socket_factory = null;
    private static ServerSocketFactory socket_factory = null;
    private static SocketFactory client_socket_factory = null;
    private int pendingReplies = 0;
    private ORB orb;
    private POA rootPOA;
    private Listener listener;
    private Listener sslListener;
    private MessageReceptorPool receptor_pool = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    private int timeout = 0;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public BasicAdapter(ORB oRB, POA pOA) {
        String string;
        this.orb = oRB;
        this.rootPOA = pOA;
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            Constructor<?> constructor;
            Class<?> clazz;
            if (ssl_socket_factory == null) {
                string = Environment.getProperty("jacorb.ssl.server_socket_factory");
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
                }
                try {
                    clazz = Class.forName(string);
                    constructor = clazz.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = BasicAdapter.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                    ssl_socket_factory = (SSLServerSocketFactory)constructor.newInstance(oRB);
                }
                catch (Exception exception) {
                    Debug.output(257, exception);
                    throw new RuntimeException("SSL support is on, but the ssl server socket factory can't be instanciated (see trace)!");
                }
            }
            if (client_socket_factory == null) {
                string = Environment.getProperty("jacorb.ssl.socket_factory");
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
                }
                try {
                    clazz = Class.forName(string);
                    constructor = clazz.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = BasicAdapter.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                    client_socket_factory = (SocketFactory)constructor.newInstance(oRB);
                }
                catch (Exception exception) {
                    Debug.output(257, exception);
                    throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instanciated (see trace)!");
                }
            }
            this.sslListener = new Listener(Environment.getProperty("OASSLPort"), ssl_socket_factory, true);
            Debug.output(1, "SSL Listener on port " + this.sslListener.port);
        } else if (client_socket_factory == null) {
            client_socket_factory = SocketFactoryManager.getSocketFactory(oRB);
        }
        this.receptor_pool = MessageReceptorPool.getInstance();
        this.request_listener = new ServerRequestListener(oRB, pOA);
        this.reply_listener = new NoBiDirServerReplyListener();
        this.listener = new Listener(Environment.getProperty("OAPort"), socket_factory, false);
        string = Environment.getProperty("jacorb.connection.server_timeout");
        if (string != null) {
            this.timeout = Integer.parseInt(string);
        }
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public void replyPending() {
        ++this.pendingReplies;
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public int getSSLPort() {
        return this.sslListener.getPort();
    }

    public boolean hasSSLListener() {
        return this.sslListener != null;
    }

    public String getAddress() {
        return this.listener.getAddress();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deliverRequest(ServerRequest var1_1, POA var2_2) {
        var3_3 = (org.jacorb.poa.POA)var2_2;
        var4_4 = var1_1.remainingPOAName();
        try {
            var5_5 = 0;
            while (var5_5 < var4_4.length - 1) {
                block10: {
                    if (var4_4[var5_5].equals("")) {
                        var1_1.setRemainingPOAName(null);
                        break;
                    }
                    try {
                        var3_3 = var3_3._getChildPOA(var4_4[var5_5]);
                        break block10;
                    }
                    catch (ParentIsHolding var6_7) {
                        var7_9 = new String[var4_4.length - var5_5];
                        var8_11 = 0;
                        ** while (var8_11 < var5_5)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var7_9[var8_11] = var4_4[var8_11 + var5_5];
                        ++var8_11;
                        continue;
                    }
lbl19:
                    // 1 sources

                    var1_1.setRemainingPOAName(var7_9);
                    break;
                }
                ++var5_5;
            }
            if (var3_3 == null) {
                throw new Error("request POA null!");
            }
            var3_3._invoke(var1_1);
        }
        catch (WrongAdapter var5_6) {
            var1_1.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            var1_1.reply();
        }
        catch (SystemException var6_8) {
            var1_1.setSystemException(var6_8);
            var1_1.reply();
        }
        catch (Throwable var7_10) {
            var1_1.setSystemException(new UNKNOWN(var7_10.toString()));
            var1_1.reply();
            var7_10.printStackTrace();
        }
    }

    public synchronized void return_result(ServerRequest serverRequest) {
        --this.pendingReplies;
        serverRequest.reply();
    }

    public void stopListeners() {
        this.listener.doStop();
        if (this.sslListener != null) {
            this.sslListener.doStop();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        socket_factory = SocketFactoryManager.getServerSocketFactory(null);
    }

    class Listener
    extends Thread {
        private ServerSocket serverSocket = null;
        private int port = 0;
        private String address_string = null;
        private boolean is_ssl = false;
        private ServerSocketFactory factory = null;
        private boolean do_run = true;

        public Listener(String string, ServerSocketFactory serverSocketFactory, boolean bl) {
            if (serverSocketFactory == null) {
                throw new Error("No socket factory available!");
            }
            this.factory = serverSocketFactory;
            this.is_ssl = bl;
            try {
                String string2 = Environment.getProperty("OAIAddr");
                if (string2 == null) {
                    this.serverSocket = string != null ? serverSocketFactory.createServerSocket(Integer.parseInt(string)) : serverSocketFactory.createServerSocket(0);
                    this.setAddress(InetAddress.getLocalHost());
                } else {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    if (inetAddress == null) {
                        inetAddress = InetAddress.getLocalHost();
                    }
                    if (inetAddress == null) {
                        System.err.println("[ Listener: Couldn't initialize, illegal ip addr " + string2 + " ]");
                        System.exit(1);
                    }
                    this.serverSocket = string != null ? serverSocketFactory.createServerSocket(Integer.parseInt(string), 20, inetAddress) : serverSocketFactory.createServerSocket(0, 20, inetAddress);
                    this.setAddress(inetAddress);
                }
                this.port = this.serverSocket.getLocalPort();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                System.err.println("[ Listener: Couldn't initialize. Illegal address configuration? ]");
                System.exit(1);
            }
            bl = ssl_socket_factory == null ? false : ssl_socket_factory.isSSL(this.serverSocket);
            this.setName("JacORB Listener Thread on port " + this.port);
            this.setDaemon(true);
            this.start();
        }

        public int getPort() {
            return this.port;
        }

        private void setAddress(InetAddress inetAddress) {
            this.address_string = DNSLookup.inverseLookup(inetAddress);
            if (this.address_string == null) {
                this.address_string = inetAddress.toString();
                if (this.address_string.indexOf("/") > 0) {
                    this.address_string = this.address_string.substring(this.address_string.indexOf("/") + 1);
                }
            }
            Debug.output(2, "Set BasicListener address string to " + this.address_string);
        }

        private void setAddress(String string) {
            this.address_string = DNSLookup.inverseLookup(string);
            if (this.address_string == null) {
                this.address_string = string;
            }
            Debug.output(2, "Set BasicListener address string to " + this.address_string);
        }

        public String getAddress() {
            return this.address_string;
        }

        public void run() {
            while (this.do_run) {
                try {
                    Socket socket = this.serverSocket.accept();
                    if (BasicAdapter.this.timeout > 0) {
                        socket.setSoTimeout(BasicAdapter.this.timeout);
                    }
                    if (this.is_ssl) {
                        ssl_socket_factory.switchToClientMode(socket);
                    }
                    Server_TCP_IP_Transport server_TCP_IP_Transport = new Server_TCP_IP_Transport(socket, this.is_ssl);
                    GIOPConnection gIOPConnection = new GIOPConnection(server_TCP_IP_Transport, BasicAdapter.this.request_listener, BasicAdapter.this.reply_listener);
                    BasicAdapter.this.receptor_pool.connectionCreated(gIOPConnection);
                }
                catch (Exception exception) {
                    if (!this.do_run) continue;
                    Debug.output(257, exception);
                }
            }
            Debug.output(258, "Listener exited");
        }

        public void doStop() {
            this.do_run = false;
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Debug.output(258, iOException);
            }
        }
    }
}

