/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Stack;
import org.jacorb.util.Environment;

public final class BufferManager {
    private Stack[] bufferPool;
    private static int MAX;
    private static final int MIN_OFFSET = 5;
    private static final int THREASHOLD = 20;
    private static int MEM_BUFSIZE;
    private static int NET_BUFSIZE;
    private static int MIN_PREFERRED_BUFS;
    private int hits = 0;
    private int calls = 0;
    private static BufferManager singleton;

    private BufferManager() {
        MAX = Environment.getMaxManagedBufSize();
        this.bufferPool = new Stack[MAX];
        int n = 0;
        while (n < MAX) {
            this.bufferPool[n] = new Stack();
            ++n;
        }
        int n2 = 0;
        int n3 = MEM_BUFSIZE;
        while (n3 > 1) {
            n3 >>= 1;
            ++n2;
        }
        int n4 = 0;
        while (n4 < MIN_PREFERRED_BUFS) {
            this.bufferPool[n2 - 5].push(new byte[MEM_BUFSIZE]);
            ++n4;
        }
        n2 = 0;
        n3 = NET_BUFSIZE;
        while (n3 > 1) {
            n3 >>= 1;
            ++n2;
        }
        int n5 = 0;
        while (n5 < MIN_PREFERRED_BUFS) {
            this.bufferPool[n2 - 5].push(new byte[NET_BUFSIZE]);
            ++n5;
        }
    }

    public static BufferManager getInstance() {
        return singleton;
    }

    private static final int log2up(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2;
    }

    private static final int log2down(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    public byte[] getPreferredNetworkBuffer() {
        return this.getBuffer(NET_BUFSIZE);
    }

    public byte[] getPreferredMemoryBuffer() {
        return this.getBuffer(MEM_BUFSIZE);
    }

    public synchronized byte[] getBuffer(int n) {
        ++this.calls;
        int n2 = BufferManager.log2up(n);
        if (n2 >= MAX + 5) {
            return new byte[n];
        }
        Stack stack = this.bufferPool[n2 > 5 ? n2 - 5 : 0];
        if (!stack.isEmpty()) {
            ++this.hits;
            Object e = stack.pop();
            byte[] byArray = (byte[])e;
            return byArray;
        }
        byte[] byArray = new byte[n2 > 5 ? 1 << n2 : 32];
        return byArray;
    }

    public synchronized void returnBuffer(byte[] byArray) {
        int n = BufferManager.log2down(byArray.length);
        if (n >= 5) {
            if (n > MAX) {
                return;
            }
            Stack stack = this.bufferPool[n - 5];
            if (stack.size() < 20) {
                stack.push(byArray);
            }
        }
    }

    public void printStatistics() {
        System.out.println("BufferManager statistics: " + this.hits * 100 / this.calls + "%");
        System.out.println("\t get Buffer called: " + this.calls);
        System.out.println("\t buffers found in pool: " + this.hits);
        System.out.println("\t buffer sizes: ");
        int n = MAX;
        while (n > 0) {
            System.out.println("\t size 2**" + (5 + --n) + " # " + this.bufferPool[n].size());
        }
    }

    public void release() {
        int n = MAX;
        while (n > 0) {
            this.bufferPool[--n].removeAllElements();
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            System.out.println("log2up(" + n2 + "): " + BufferManager.log2up(n2));
            System.out.println("log2down(" + n2 + "): " + BufferManager.log2down(n2));
            ++n;
        }
    }

    static {
        MEM_BUFSIZE = 256;
        NET_BUFSIZE = 2048;
        MIN_PREFERRED_BUFS = 10;
        singleton = new BufferManager();
    }
}

