/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Stack;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    int read_index;
    private Stack encaps_stack = new Stack();
    private Hashtable recursiveTCMap = new Hashtable();
    private int marked_pos;
    private int marked_index;
    private boolean closed = false;
    private boolean use_BOM = false;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    public int giop_minor = 2;
    private Hashtable valueMap = new Hashtable();
    private int currentValueIndex;
    private Hashtable repIdMap = new Hashtable();
    private Hashtable codebaseMap = new Hashtable();
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private org.omg.CORBA.ORB orb = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray) {
        this.orb = oRB;
        this.buffer = byArray;
        this.use_BOM = Environment.isPropertyOn("jacorb.use_bom");
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, boolean bl) {
        this(oRB, byArray);
        this.littleEndian = bl;
    }

    public void setGIOPMinor(int n) {
        this.giop_minor = n;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.encaps_stack.removeAllElements();
        BufferManager.getInstance().returnBuffer(this.buffer);
        this.recursiveTCMap.clear();
        this.closed = true;
    }

    public org.omg.CORBA.ORB orb() {
        if (this.orb == null) {
            this.orb = org.omg.CORBA.ORB.init();
        }
        return this.orb;
    }

    public void setCodeSet(int n, int n2) {
        this.codeSet = n;
        this.codeSetW = n2;
    }

    private static final int _read4int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0);
        }
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return (short)(((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0));
        }
        return (short)(((byArray[n] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0));
    }

    protected final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void closeEncapsulation() {
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = encapsInfo.littleEndian;
        int n = encapsInfo.start;
        int n2 = encapsInfo.size;
        if (this.pos < n + n2) {
            this.pos = n + n2;
        }
        this.index = encapsInfo.index + n2;
    }

    public final void openEncapsulation() {
        boolean bl = this.littleEndian;
        int n = this.pos;
        int n2 = this.read_long();
        this.encaps_stack.push(new EncapsInfo(bl, this.index, this.pos, n2));
        this.openEncapsulatedArray();
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        return this.buffer[this.read_index++];
    }

    public int available() {
        return this.pos - this.read_index;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int n3 = n2 < this.available() ? n2 : this.available();
        System.arraycopy(this.buffer, 0, byArray, n, n3);
        return n3;
    }

    public final Any read_any() {
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public final boolean read_boolean() {
        byte by;
        ++this.index;
        if ((by = this.buffer[this.pos++]) == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        Debug.output(1, "", this.buffer);
        throw new Error("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byte by;
            ++this.index;
            if ((by = this.buffer[this.pos++]) == 1) {
                blArray[n3] = true;
            } else if (by == 0) {
                blArray[n3] = false;
            } else {
                Debug.output(1, "", this.buffer);
                throw new Error("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
            }
            ++n3;
        }
    }

    public final char read_char() {
        if (this.codeSet == 65537) {
            ++this.index;
            return (char)(0xFF & this.buffer[this.pos++]);
        }
        throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        if (this.codeSet == 65537) {
            int n3 = n;
            while (n3 < n + n2) {
                ++this.index;
                cArray[n3] = (char)(0xFF & this.buffer[this.pos++]);
                ++n3;
            }
        } else {
            throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            dArray[n3] = Double.longBitsToDouble(this.read_longlong());
            ++n3;
        }
    }

    public final BigDecimal read_fixed() {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.buffer[this.pos++];
        int n = by & 0xF;
        ++this.index;
        while (true) {
            n = (by & 0xF0) >>> 4;
            stringBuffer.append(n);
            n = by & 0xF;
            if (n == 12 || n == 13) break;
            stringBuffer.append(n);
            by = this.buffer[this.pos++];
            ++this.index;
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(stringBuffer.toString()));
        if (n == 13) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            fArray[n3] = Float.intBitsToFloat(this.read_long());
            ++n3;
        }
    }

    public final int read_long() {
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            nArray[n4] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
            ++n4;
        }
        this.index += 4 * n2;
    }

    public final long read_longlong() {
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this.read_long() & 0xFFFFFFFFL) + ((long)this.read_long() << 32);
        }
        return ((long)this.read_long() << 32) + ((long)this.read_long() & 0xFFFFFFFFL);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            int n4 = n;
            while (n4 < n + n2) {
                lArray[n4] = ((long)this.read_long() & 0xFFFFFFFFL) + ((long)this.read_long() << 32);
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n + n2) {
                lArray[n5] = ((long)this.read_long() << 32) + ((long)this.read_long() & 0xFFFFFFFFL);
                ++n5;
            }
        }
    }

    public final Object read_Object() {
        IOR iOR = IORHelper.read(this);
        ParsedIOR parsedIOR = new ParsedIOR(iOR);
        if (parsedIOR.isNull()) {
            return null;
        }
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        return ((ORB)this.orb)._getObject(parsedIOR);
    }

    public Object read_Object(Class clazz) {
        if (clazz.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = CDRInputStream.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clazz);
        }
        return this.read_Object();
    }

    public final byte read_octet() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.index += n2;
        this.pos += n2;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final short read_short() {
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            sArray[n4] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
            ++n4;
        }
        this.index += n2 * 2;
    }

    public final String read_string() {
        if (this.codeSet != 65537) {
            throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
        }
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)(0xFF & this.buffer[this.pos++]);
            ++n3;
        }
        this.index += n2;
        if (n2 > 0 && cArray[n2 - 1] == '\u0000') {
            return new String(cArray, 0, n2 - 1);
        }
        return new String(cArray);
    }

    public final org.omg.CORBA.TypeCode read_TypeCode() {
        Hashtable hashtable = new Hashtable();
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
        hashtable.clear();
        return typeCode;
    }

    private final org.omg.CORBA.TypeCode read_TypeCode(Hashtable hashtable) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 26: {
                return this.orb.get_primitive_tc(TCKind.from_int(n));
            }
            case 14: {
                this.openEncapsulation();
                String string = this.read_string();
                String string2 = this.read_string();
                this.closeEncapsulation();
                return this.orb.create_interface_tc(string, string2);
            }
            case 15: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string3 = this.read_string();
                int n3 = this.read_long();
                StructMember[] structMemberArray = new StructMember[n3];
                int n4 = 0;
                while (n4 < n3) {
                    structMemberArray[n4] = new StructMember(this.read_string(), this.read_TypeCode(hashtable), null);
                    ++n4;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.orb.create_struct_tc(string, string3, structMemberArray);
                this.recursiveTCMap.put(string, typeCode);
                return typeCode;
            }
            case 22: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string4 = this.read_string();
                int n5 = this.read_long();
                StructMember[] structMemberArray = new StructMember[n5];
                int n6 = 0;
                while (n6 < n5) {
                    structMemberArray[n6] = new StructMember(this.read_string(), this.read_TypeCode(), null);
                    ++n6;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.orb.create_struct_tc(string, string4, structMemberArray);
                this.recursiveTCMap.put(string, typeCode);
                return typeCode;
            }
            case 17: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string5 = this.read_string();
                int n7 = this.read_long();
                String[] stringArray = new String[n7];
                int n8 = 0;
                while (n8 < n7) {
                    stringArray[n8] = this.read_string();
                    ++n8;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.orb.create_enum_tc(string, string5, stringArray);
                this.recursiveTCMap.put(string, typeCode);
                return typeCode;
            }
            case 16: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string6 = this.read_string();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                TypeCode typeCode2 = ((TypeCode)typeCode).originalType();
                int n9 = this.read_long();
                int n10 = this.read_long();
                UnionMember[] unionMemberArray = new UnionMember[n10];
                int n11 = 0;
                while (n11 < n10) {
                    Any any = this.orb.create_any();
                    if (n11 == n9) {
                        any.insert_octet(this.read_octet());
                    } else {
                        any.read_value(this, typeCode2);
                    }
                    String string7 = this.read_string();
                    unionMemberArray[n11] = new UnionMember(string7, any, this.read_TypeCode(hashtable), null);
                    ++n11;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode3 = this.orb.create_union_tc(string, string6, typeCode, unionMemberArray);
                this.recursiveTCMap.put(string, typeCode3);
                return typeCode3;
            }
            case 18: {
                return this.orb.create_string_tc(this.read_long());
            }
            case 27: {
                return this.orb.create_wstring_tc(this.read_long());
            }
            case 28: {
                return this.orb.create_fixed_tc(this.read_ushort(), this.read_short());
            }
            case 20: {
                this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n12 = this.read_long();
                this.closeEncapsulation();
                return this.orb.create_array_tc(n12, typeCode);
            }
            case 19: {
                this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n13 = this.read_long();
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode4 = this.orb.create_sequence_tc(n13, typeCode);
                return typeCode4;
            }
            case 21: {
                this.openEncapsulation();
                String string = this.read_string();
                String string8 = this.read_string();
                hashtable.put(new Integer(n2), string);
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode5 = this.orb.create_alias_tc(string, string8, typeCode);
                this.recursiveTCMap.put(string, typeCode5);
                return typeCode5;
            }
            case 29: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string9 = this.read_string();
                short s = this.read_short();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n14 = this.read_long();
                ValueMember[] valueMemberArray = new ValueMember[n14];
                int n15 = 0;
                while (n15 < n14) {
                    valueMemberArray[n15] = new ValueMember(this.read_string(), null, null, null, this.read_TypeCode(hashtable), null, this.read_short());
                    ++n15;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode6 = this.orb.create_value_tc(string, string9, s, typeCode, valueMemberArray);
                this.recursiveTCMap.put(string, typeCode6);
                return typeCode6;
            }
            case 30: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n2), string);
                String string10 = this.read_string();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode7 = this.orb.create_value_box_tc(string, string10, typeCode);
                this.recursiveTCMap.put(string, typeCode7);
                return typeCode7;
            }
            case 32: {
                this.openEncapsulation();
                String string = this.read_string();
                String string11 = this.read_string();
                this.closeEncapsulation();
                return this.orb.create_abstract_interface_tc(string, string11);
            }
            case -1: {
                int n16 = this.read_long();
                String string = (String)hashtable.get(new Integer(this.pos - 4 + n16));
                Debug.myAssert(string != null, "No recursive TypeCode! (pos: " + (this.pos - 4 + n16) + ")");
                org.omg.CORBA.TypeCode typeCode = (org.omg.CORBA.TypeCode)this.recursiveTCMap.get(string);
                if (typeCode == null) {
                    typeCode = this.orb.create_recursive_tc(string);
                }
                return typeCode;
            }
        }
        throw new MARSHAL("Cannot handle TypeCode with kind " + n);
    }

    public final int read_ulong() {
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            nArray[n4] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
            ++n4;
        }
        this.index += 4 * n2;
    }

    public final long read_ulonglong() {
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this.read_long() & 0xFFFFFFFFL) + ((long)this.read_long() << 32);
        }
        return ((long)this.read_long() << 32) + ((long)this.read_long() & 0xFFFFFFFFL);
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            int n4 = n;
            while (n4 < n + n2) {
                lArray[n4] = ((long)this.read_long() & 0xFFFFFFFFL) + ((long)this.read_long() << 32);
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n + n2) {
                lArray[n5] = ((long)this.read_long() << 32) + ((long)this.read_long() & 0xFFFFFFFFL);
                ++n5;
            }
        }
    }

    public final short read_ushort() {
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            sArray[n4] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
            ++n4;
        }
        this.index += n2 * 2;
    }

    public final char read_wchar() {
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean bl = this.readBOM();
            return this.read_wchar(bl);
        }
        return this.read_wchar(this.littleEndian);
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean bl) {
        switch (this.codeSetW) {
            case 0x5010001: {
                if (this.giop_minor < 2) {
                    throw new Error("GIOP 1." + this.giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
                }
                short s = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((s & 0x80) == 0) {
                    return (char)s;
                }
                if ((s & 0xE0) == 192) {
                    ++this.index;
                    return (char)((s & 0x1F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short s2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((s & 0xF) << 12 | (s2 & 0x3F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                char c = bl ? (char)(this.buffer[this.pos++] & 0xFF | this.buffer[this.pos++] << 8) : (char)(this.buffer[this.pos++] << 8 | this.buffer[this.pos++] & 0xFF);
                this.index += 2;
                return c;
            }
        }
        throw new Error("Bad CodeSet: " + this.codeSetW);
    }

    private final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.read_wchar();
            ++n3;
        }
    }

    public final String read_wstring() {
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        if (this.giop_minor == 2) {
            int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = this.pos + n2;
            boolean bl = this.readBOM();
            while (this.pos < n4) {
                cArray[n3++] = this.read_wchar(bl);
            }
            return new String(cArray, 0, n3);
        }
        int n5 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        char[] cArray = new char[n5];
        int n6 = this.pos + n5;
        if (this.codeSetW == 65801) {
            n6 += n5;
        }
        int n7 = 0;
        while (this.pos < n6) {
            cArray[n7++] = this.read_wchar(this.littleEndian);
        }
        if (n7 != 0 && cArray[n7 - 1] == '\u0000') {
            return new String(cArray, 0, n7 - 1);
        }
        return new String(cArray, 0, n7);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new IOException("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, OutputStream outputStream) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = ((TypeCode)typeCode)._kind();
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 8: {
                outputStream.write_boolean(this.read_boolean());
                break;
            }
            case 9: {
                outputStream.write_char(this.read_char());
                break;
            }
            case 26: {
                outputStream.write_wchar(this.read_wchar());
                break;
            }
            case 10: {
                outputStream.write_octet(this.read_octet());
                break;
            }
            case 4: {
                outputStream.write_ushort(this.read_ushort());
                break;
            }
            case 2: {
                outputStream.write_short(this.read_short());
                break;
            }
            case 3: {
                outputStream.write_long(this.read_long());
                break;
            }
            case 5: {
                outputStream.write_ulong(this.read_ulong());
                break;
            }
            case 6: {
                outputStream.write_float(this.read_float());
                break;
            }
            case 7: {
                outputStream.write_double(this.read_double());
                break;
            }
            case 23: {
                outputStream.write_longlong(this.read_longlong());
                break;
            }
            case 24: {
                outputStream.write_ulonglong(this.read_ulonglong());
                break;
            }
            case 11: {
                outputStream.write_any(this.read_any());
                break;
            }
            case 12: {
                outputStream.write_TypeCode(this.read_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                outputStream.write_Object(this.read_Object());
                break;
            }
            case 18: {
                outputStream.write_string(this.read_string());
                break;
            }
            case 27: {
                outputStream.write_wstring(this.read_wstring());
                break;
            }
            case 20: {
                try {
                    int n2 = typeCode.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        this.read_value(typeCode.content_type(), outputStream);
                        ++n3;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 19: {
                try {
                    int n4 = this.read_long();
                    outputStream.write_long(n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        this.read_value(typeCode.content_type(), outputStream);
                        ++n5;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 22: {
                outputStream.write_string(this.read_string());
            }
            case 15: {
                try {
                    int n6 = 0;
                    while (n6 < typeCode.member_count()) {
                        this.read_value(typeCode.member_type(n6), outputStream);
                        ++n6;
                    }
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                }
                catch (Bounds bounds) {
                    bounds.printStackTrace();
                }
                break;
            }
            case 17: {
                outputStream.write_long(this.read_long());
                break;
            }
            case 21: {
                try {
                    this.read_value(typeCode.content_type(), outputStream);
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                }
                break;
            }
            case 16: {
                try {
                    TypeCode typeCode2 = (TypeCode)typeCode.discriminator_type();
                    typeCode2 = typeCode2.originalType();
                    int n7 = typeCode.default_index();
                    int n8 = -1;
                    block35 : switch (typeCode2.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            outputStream.write_short(s);
                            int n9 = 0;
                            while (n9 < typeCode.member_count()) {
                                if (n9 != n7 && s == typeCode.member_label(n9).extract_short()) {
                                    n8 = n9;
                                    break block35;
                                }
                                ++n9;
                            }
                            break;
                        }
                        case 3: {
                            int n10 = this.read_long();
                            outputStream.write_long(n10);
                            int n11 = 0;
                            while (n11 < typeCode.member_count()) {
                                if (n11 != n7 && n10 == typeCode.member_label(n11).extract_long()) {
                                    n8 = n11;
                                    break block35;
                                }
                                ++n11;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            outputStream.write_ushort(s);
                            int n12 = 0;
                            while (n12 < typeCode.member_count()) {
                                if (n12 != n7 && s == typeCode.member_label(n12).extract_ushort()) {
                                    n8 = n12;
                                    break block35;
                                }
                                ++n12;
                            }
                            break;
                        }
                        case 5: {
                            int n13 = this.read_ulong();
                            outputStream.write_ulong(n13);
                            int n14 = 0;
                            while (n14 < typeCode.member_count()) {
                                if (n14 != n7 && n13 == typeCode.member_label(n14).extract_ulong()) {
                                    n8 = n14;
                                    break block35;
                                }
                                ++n14;
                            }
                            break;
                        }
                        case 23: {
                            long l = this.read_longlong();
                            outputStream.write_longlong(l);
                            int n15 = 0;
                            while (n15 < typeCode.member_count()) {
                                if (n15 != n7 && l == typeCode.member_label(n15).extract_longlong()) {
                                    n8 = n15;
                                    break block35;
                                }
                                ++n15;
                            }
                            break;
                        }
                        case 24: {
                            long l = this.read_ulonglong();
                            outputStream.write_ulonglong(l);
                            int n16 = 0;
                            while (n16 < typeCode.member_count()) {
                                if (n16 != n7 && l == typeCode.member_label(n16).extract_ulonglong()) {
                                    n8 = n16;
                                    break block35;
                                }
                                ++n16;
                            }
                            break;
                        }
                        case 9: {
                            char c = this.read_char();
                            outputStream.write_char(c);
                            int n17 = 0;
                            while (n17 < typeCode.member_count()) {
                                if (n17 != n7 && c == typeCode.member_label(n17).extract_char()) {
                                    n8 = n17;
                                    break block35;
                                }
                                ++n17;
                            }
                            break;
                        }
                        case 8: {
                            boolean bl = this.read_boolean();
                            outputStream.write_boolean(bl);
                            int n18 = 0;
                            while (n18 < typeCode.member_count()) {
                                if (n18 != n7 && bl == typeCode.member_label(n18).extract_boolean()) {
                                    n8 = n18;
                                    break block35;
                                }
                                ++n18;
                            }
                            break;
                        }
                        case 17: {
                            int n19 = this.read_long();
                            outputStream.write_long(n19);
                            int n20 = 0;
                            while (n20 < typeCode.member_count()) {
                                int n21;
                                if (n20 != n7 && n19 == (n21 = typeCode.member_label(n20).create_input_stream().read_long())) {
                                    n8 = n20;
                                    break block35;
                                }
                                ++n20;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                    }
                    if (n8 != -1) {
                        this.read_value(typeCode.member_type(n8), outputStream);
                        break;
                    }
                    if (n7 == -1) break;
                    this.read_value(typeCode.member_type(n7), outputStream);
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case -1: {
                try {
                    org.omg.CORBA.TypeCode typeCode3 = (org.omg.CORBA.TypeCode)this.recursiveTCMap.get(typeCode.id());
                    if (typeCode3 == null) {
                        throw new MARSHAL("No recursive TC found for " + typeCode.id());
                    }
                    this.read_value(typeCode3, outputStream);
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                }
                break;
            }
            default: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n);
            }
        }
    }

    public Serializable read_value() {
        String string;
        int n = this.pos;
        int n2 = this.read_long();
        if (n2 == -1) {
            return this.read_indirect_value();
        }
        if (n2 == 0) {
            return null;
        }
        String string2 = string = (n2 & 1) != 0 ? this.read_codebase() : null;
        if ((n2 &= 0xFFFFFFFE) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (n2 == 2147483394) {
            return this.read_typed_value(n, string);
        }
        if (n2 == 2147483398) {
            return this.read_multi_typed_value(n, string);
        }
        throw new MARSHAL("unknown value tag: " + Integer.toHexString(n2));
    }

    public Serializable read_value(String string) {
        String string2;
        int n = this.pos;
        int n2 = this.read_long();
        if (n2 == -1) {
            return this.read_indirect_value();
        }
        if (n2 == 0) {
            return null;
        }
        String string3 = string2 = (n2 & 1) != 0 ? this.read_codebase() : null;
        if ((n2 &= 0xFFFFFFFE) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{string}, n, string2);
        }
        if (n2 == 2147483394) {
            return this.read_typed_value(n, string2);
        }
        if (n2 == 2147483398) {
            return this.read_multi_typed_value(n, string2);
        }
        throw new MARSHAL("unknown value tag: " + Integer.toHexString(n2));
    }

    public Serializable read_value(Serializable serializable) {
        return this.read_value(serializable.getClass());
    }

    public Serializable read_value(Class clazz) {
        String string;
        int n = this.pos;
        int n2 = this.read_long();
        if (n2 == -1) {
            return this.read_indirect_value();
        }
        if (n2 == 0) {
            Debug.output(4, "read_value(clz): read null tag");
            return null;
        }
        String string2 = string = (n2 & 1) != 0 ? this.read_codebase() : null;
        if ((n2 &= 0xFFFFFFFE) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{RepositoryID.repId(clazz)}, n, string);
        }
        if (n2 == 2147483394) {
            return this.read_typed_value(n, string);
        }
        if (n2 == 2147483398) {
            return this.read_multi_typed_value(n, string);
        }
        throw new MARSHAL("unknown value tag: " + Integer.toHexString(n2));
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        String string;
        int n = this.pos;
        int n2 = this.read_long();
        if (n2 == -1) {
            return this.read_indirect_value();
        }
        if (n2 == 0) {
            return null;
        }
        String string2 = string = (n2 & 1) != 0 ? this.read_codebase() : null;
        if ((n2 &= 0xFFFFFFFE) == 0x7FFFFF00) {
            Serializable serializable = boxedValueHelper.read_value(this);
            if (serializable != null) {
                this.valueMap.put(new Integer(n), serializable);
            }
            return serializable;
        }
        if (n2 == 2147483394) {
            return this.read_typed_value(n, string);
        }
        throw new MARSHAL("unknown value tag: " + Integer.toHexString(n2));
    }

    private Serializable read_untyped_value(String[] stringArray, int n, String string) {
        java.lang.Object object = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            block13: {
                java.lang.Object object2;
                if (stringArray[n2].equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                    object = this.read_wstring();
                    break;
                }
                if (stringArray[n2].startsWith("IDL:")) {
                    object2 = ((org.omg.CORBA_2_3.ORB)this.orb).lookup_value_factory(stringArray[n2]);
                    if (object2 != null) {
                        this.currentValueIndex = n;
                        object = object2.read_value(this);
                        break;
                    }
                    if (n2 >= stringArray.length - 1) {
                        throw new MARSHAL("No factory found for: " + stringArray[0]);
                    }
                } else {
                    object2 = RepositoryID.className(stringArray[n2]);
                    Class clazz = null;
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        if (classLoader != null) {
                            try {
                                clazz = classLoader.loadClass((String)object2);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                clazz = ValueHandler.loadClass((String)object2, string, null);
                            }
                        } else {
                            clazz = ValueHandler.loadClass((String)object2, string, null);
                        }
                        object = ValueHandler.readValue(this, n, clazz, stringArray[n2], null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (n2 < stringArray.length - 1) break block13;
                        throw new MARSHAL("class not found: " + (String)object2);
                    }
                }
            }
            ++n2;
        }
        if (object != null) {
            this.valueMap.put(new Integer(n), object);
        }
        return object;
    }

    private Serializable read_typed_value(int n, String string) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, n, string);
    }

    private Serializable read_multi_typed_value(int n, String string) {
        int n2 = this.read_long();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.read_repository_id();
            ++n3;
        }
        return this.read_untyped_value(stringArray, n, string);
    }

    private String read_repository_id() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            String string = (String)this.repIdMap.get(new Integer(n2 = n2 + this.pos - 4));
            if (string == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return string;
        }
        this.pos -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.repIdMap.put(new Integer(n3), string);
        return string;
    }

    private String read_codebase() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            String string = (String)this.codebaseMap.get(new Integer(n2 = n2 + this.pos - 4));
            if (string == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return string;
        }
        this.pos -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.codebaseMap.put(new Integer(n3), string);
        return string;
    }

    private Serializable read_indirect_value() {
        int n = this.read_long();
        java.lang.Object v = this.valueMap.get(new Integer(n = n + this.pos - 4));
        if (v == null) {
            throw new IndirectionException(n);
        }
        return (Serializable)v;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        return this.read_boolean() ? this.read_Object(clazz) : this.read_value(clazz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable serializable) {
        this.valueMap.put(new Integer(this.currentValueIndex), serializable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

