/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ParsedIOR {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int effectiveProfileBody = 0;
    private ProfileBody_1_1[] profileBodies = null;
    public TaggedComponent[] taggedComponents = new TaggedComponent[0];
    public TaggedProfile[] effectiveProfile;
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private ORB orb = null;
    private String adport = null;
    private boolean use_ssl = false;
    private CodeSetComponentInfo cs_info = null;
    static /* synthetic */ Class class$java$lang$String;

    public static IOR createObjectIOR(String string, short s, byte[] byArray, int n) {
        IOR iOR = new IOR();
        iOR.type_id = "IDL:org.omg/CORBA/Object:1.0";
        iOR.profiles = new TaggedProfile[1];
        iOR.profiles[0] = new TaggedProfile();
        iOR.profiles[0].tag = 0;
        if (n == 0) {
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(new Version(1, 0), string, s, byArray);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
            iOR.profiles[0].profile_data = cDROutputStream.getBufferCopy();
        } else {
            ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1(new Version(1, (byte)n), string, s, byArray, new TaggedComponent[0]);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            ProfileBody_1_1Helper.write(cDROutputStream, profileBody_1_1);
            iOR.profiles[0].profile_data = cDROutputStream.getBufferCopy();
        }
        return iOR;
    }

    public static IOR createObjectIOR(String string, short s, byte[] byArray, int n, TaggedComponent[] taggedComponentArray) {
        IOR iOR = new IOR();
        iOR.type_id = "IDL:org.omg/CORBA/Object:1.0";
        TaggedProfile taggedProfile = new TaggedProfile();
        taggedProfile.tag = 0;
        if (n == 0) {
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(new Version(1, 0), string, s, byArray);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
            taggedProfile.profile_data = cDROutputStream.getBufferCopy();
            iOR.profiles = new TaggedProfile[2];
            cDROutputStream.reset();
            cDROutputStream.beginEncapsulatedArray();
            MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentArray);
            iOR.profiles[1] = new TaggedProfile(1, cDROutputStream.getBufferCopy());
        } else {
            ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1(new Version(1, (byte)n), string, s, byArray, taggedComponentArray);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            ProfileBody_1_1Helper.write(cDROutputStream, profileBody_1_1);
            taggedProfile.profile_data = cDROutputStream.getBufferCopy();
            iOR.profiles = new TaggedProfile[1];
        }
        iOR.profiles[0] = taggedProfile;
        return iOR;
    }

    public static ProfileBody_1_1 getProfileBody(byte[] byArray, int n) {
        ProfileBody_1_1 profileBody_1_1 = null;
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        try {
            cDRInputStream.openEncapsulatedArray();
            cDRInputStream.mark(0);
            byte by = VersionHelper.read((InputStream)cDRInputStream).minor;
            if (by < n || by > 2) {
                return null;
            }
            cDRInputStream.reset();
            switch (by) {
                case 1: 
                case 2: {
                    profileBody_1_1 = ProfileBody_1_1Helper.read(cDRInputStream);
                    break;
                }
                case 0: {
                    ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(cDRInputStream);
                    profileBody_1_1 = new ProfileBody_1_1(profileBody_1_0.iiop_version, profileBody_1_0.host, profileBody_1_0.port, profileBody_1_0.object_key, new TaggedComponent[0]);
                    if (profileBody_1_1.port >= 0) break;
                    profileBody_1_1.port = (short)(profileBody_1_1.port + 65536);
                }
            }
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            throw new INV_OBJREF();
        }
        return profileBody_1_1;
    }

    private static SSL getSSLTaggedComponent(ProfileBody_1_1 profileBody_1_1) {
        if (profileBody_1_1 == null || profileBody_1_1.iiop_version == null || profileBody_1_1.iiop_version.minor == 0 || profileBody_1_1.components == null) {
            return null;
        }
        boolean bl = false;
        int n = 0;
        while (n < profileBody_1_1.components.length) {
            if (profileBody_1_1.components[n].tag == 20) {
                bl = true;
                Debug.output(8, "Component data", profileBody_1_1.components[n].component_data);
                CDRInputStream cDRInputStream = new CDRInputStream(null, profileBody_1_1.components[n].component_data);
                try {
                    cDRInputStream.openEncapsulatedArray();
                    return SSLHelper.read(cDRInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public static void unfiyTargetAddress(TargetAddress targetAddress) {
        if (targetAddress.discriminator() == 1) {
            TaggedProfile taggedProfile = targetAddress.profile();
            ProfileBody_1_1 profileBody_1_1 = ParsedIOR.getProfileBody(targetAddress.profile().profile_data, 0);
            targetAddress.object_key(profileBody_1_1.object_key);
        } else if (targetAddress.discriminator() == 2) {
            IORAddressingInfo iORAddressingInfo = targetAddress.ior();
            ParsedIOR parsedIOR = new ParsedIOR(iORAddressingInfo.ior);
            parsedIOR.effectiveProfileBody = iORAddressingInfo.selected_profile_index;
            targetAddress.object_key(parsedIOR.get_object_key());
        }
    }

    public String getCodebaseComponent() {
        int n = 0;
        while (n < this.taggedComponents.length) {
            if (this.taggedComponents[n].tag == 25) {
                Debug.output(4, "TAG_JAVA_CODEBASE found");
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, this.taggedComponents[n].component_data);
                cDRInputStream.openEncapsulatedArray();
                return cDRInputStream.read_string();
            }
            ++n;
        }
        return null;
    }

    public ParsedIOR(String string) throws IllegalArgumentException {
        this.parse(string);
    }

    public ParsedIOR(String string, ORB oRB) throws IllegalArgumentException {
        this.orb = oRB;
        this.parse(string);
    }

    public ParsedIOR(IOR iOR) {
        this.decode(iOR);
    }

    public boolean equals(java.lang.Object object) {
        return object instanceof ParsedIOR && ((ParsedIOR)object).ior_str.equals(this.ior_str);
    }

    public void init() {
        ProfileBody_1_1 profileBody_1_1 = this.getProfileBody();
        if (profileBody_1_1 == null) {
            throw new INV_OBJREF("No TAG_INTERNET_IOP found in object_reference");
        }
        int n = profileBody_1_1.port;
        SSL sSL = ParsedIOR.getSSLTaggedComponent(profileBody_1_1);
        if (sSL != null && Environment.isPropertyOn("jacorb.security.support_ssl")) {
            this.use_ssl = true;
            n = sSL.port;
        } else {
            this.use_ssl = false;
        }
        if (n < 0) {
            n += 65536;
        }
        this.adport = profileBody_1_1.host + ":" + n;
    }

    public String getAdPort() {
        return this.adport;
    }

    public boolean useSSL() {
        return this.use_ssl;
    }

    public void decode(IOR iOR) {
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        int n = 0;
        while (n < iOR.profiles.length) {
            switch (iOR.profiles[n].tag) {
                case 1: {
                    java.lang.Object object = new CDRInputStream(null, iOR.profiles[n].profile_data);
                    ((CDRInputStream)object).openEncapsulatedArray();
                    this.taggedComponents = MultipleComponentProfileHelper.read((InputStream)object);
                    break;
                }
                case 0: {
                    java.lang.Object object = ParsedIOR.getProfileBody(iOR.profiles[n].profile_data, 0);
                    if (object == null) break;
                    vector.addElement(object);
                    Debug.output(4, "IOP 1.1 decoded");
                }
            }
            ++n;
        }
        this.profileBodies = new ProfileBody_1_1[vector.size()];
        vector.copyInto(this.profileBodies);
        this.effectiveProfileBody = 0;
        int n2 = 1;
        while (n2 < this.profileBodies.length) {
            if (this.profileBodies[n2].iiop_version.minor > this.profileBodies[this.effectiveProfileBody].iiop_version.minor) {
                this.effectiveProfileBody = n2;
            }
            ++n2;
        }
        this.ior = iOR;
        this.ior_str = this.getIORString();
        TaggedComponent[] taggedComponentArray = null;
        taggedComponentArray = this.profileBodies.length == 0 ? new TaggedComponent[]{} : this.profileBodies[this.effectiveProfileBody].components;
        int n3 = 0;
        while (n3 < this.taggedComponents.length) {
            if (this.taggedComponents[n3].tag == 1) {
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, this.taggedComponents[n3].component_data);
                cDRInputStream.openEncapsulatedArray();
                this.cs_info = CodeSetComponentInfoHelper.read(cDRInputStream);
                break;
            }
            ++n3;
        }
    }

    public void decode(CorbaLoc corbaLoc) {
        IOR iOR = null;
        CorbaLoc.ObjectAddress objectAddress = corbaLoc.objectAddressList[0];
        if (objectAddress.protocol_identifier.equals("rir")) {
            try {
                Object object = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else if (objectAddress.protocol_identifier.equals("iiop")) {
            iOR = ParsedIOR.createObjectIOR(objectAddress.host, (short)objectAddress.port, corbaLoc.getKey(), objectAddress.minor);
        } else if (objectAddress.protocol_identifier.equals("ssliop")) {
            String string;
            SSL sSL = new SSL();
            sSL.port = (short)objectAddress.port;
            String string2 = Environment.getProperty("jacorb.security.ssl.corbaloc_ssliop.supported_options");
            if (string2 != null && !string2.equals("")) {
                try {
                    sSL.target_supports = (short)Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(0, "WARNING: Unable to create int from string >>" + string2 + "<<");
                    Debug.output(0, "Please check property \"jacorb.security.ssl.corbaloc_ssliop.supported_options\"");
                    sSL.target_supports = (short)32;
                }
            } else {
                sSL.target_supports = (short)32;
            }
            if ((string = Environment.getProperty("jacorb.security.ssl.corbaloc_ssliop.required_options")) != null && !string.equals("")) {
                try {
                    sSL.target_supports = (short)Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(0, "WARNING: Unable to create int from string >>" + string + "<<");
                    Debug.output(0, "Please check property \"jacorb.security.ssl.corbaloc_ssliop.required_options\"");
                    sSL.target_supports = (short)32;
                }
            } else {
                sSL.target_requires = (short)32;
            }
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            SSLHelper.write(cDROutputStream, sSL);
            TaggedComponent taggedComponent = new TaggedComponent(20, cDROutputStream.getBufferCopy());
            iOR = ParsedIOR.createObjectIOR(objectAddress.host, (short)objectAddress.port, corbaLoc.getKey(), objectAddress.minor, new TaggedComponent[]{taggedComponent});
        }
        this.decode(iOR);
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                cDROutputStream.beginEncapsulatedArray();
                IORHelper.write(cDROutputStream, this.ior);
                byte[] byArray = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                int n = 0;
                while (n < byArray.length) {
                    stringBuffer.append(lookup[byArray[n] >> 4 & 0xF]);
                    stringBuffer.append(lookup[byArray[n] & 0xF]);
                    ++n;
                }
                this.ior_str = stringBuffer.toString();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public byte[] get_object_key() {
        return this.profileBodies[this.effectiveProfileBody].object_key;
    }

    public ProfileBody_1_1 getProfileBody() {
        if (this.profileBodies.length > this.effectiveProfileBody) {
            return this.profileBodies[this.effectiveProfileBody];
        }
        return null;
    }

    public ProfileBody_1_1[] getProfileBodies() {
        return this.profileBodies;
    }

    public TaggedProfile getEffectiveProfile() {
        if (this.profileBodies.length > this.effectiveProfileBody) {
            return this.ior.profiles[this.effectiveProfileBody];
        }
        return null;
    }

    public String getAddress() {
        return this.getHost() + ":" + this.getPort();
    }

    public String getPort() {
        int n = this.profileBodies[this.effectiveProfileBody].port;
        if (n < 0) {
            n += 65536;
        }
        return Integer.toString(n);
    }

    public String getHost() {
        return this.profileBodies[this.effectiveProfileBody].host;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        StringBuffer stringBuffer = new StringBuffer(this.getTypeId());
        stringBuffer.append(":");
        byte[] byArray = this.get_object_key();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(lookup[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(lookup[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isNull() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    protected void parse(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (string.startsWith("IOR:")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = (string.length() - 4) / 2;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c = string.charAt(n2 * 2 + 4);
                char c2 = string.charAt(n2 * 2 + 5);
                int n4 = c >= 'a' ? 10 + c - 97 : (n3 = c >= 'A' ? 10 + c - 65 : c - 48);
                int n5 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
                byteArrayOutputStream.write(n3 * 16 + n5);
                ++n2;
            }
            CDRInputStream cDRInputStream = null;
            cDRInputStream = this.orb == null ? new CDRInputStream(org.omg.CORBA.ORB.init(), byteArrayOutputStream.toByteArray()) : new CDRInputStream(this.orb, byteArrayOutputStream.toByteArray());
            this.endianness = cDRInputStream.read_boolean();
            if (this.endianness) {
                cDRInputStream.setLittleEndian(true);
            }
            IOR iOR = IORHelper.read(cDRInputStream);
            this.decode(iOR);
        } else if (string.startsWith("corbaloc:")) {
            this.decode(new CorbaLoc(string));
        } else {
            if (string.startsWith("corbaname:")) {
                String string2 = "corbaloc:";
                String string3 = "";
                if (string.indexOf(35) == -1) {
                    string2 = string2 + string.substring(string.indexOf(58) + 1);
                } else {
                    string2 = string2 + string.substring(string.indexOf(58) + 1, string.indexOf(35));
                    string3 = string.substring(string.indexOf(35) + 1);
                }
                if (string2.indexOf(47) == -1) {
                    string2 = string2 + "/NameService";
                }
                Debug.output(4, string2);
                try {
                    NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.orb.string_to_object(string2));
                    Object object = namingContextExt.resolve_str(string3);
                    IOR iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
                    this.decode(iOR);
                }
                catch (Exception exception) {
                    Debug.output(4, exception);
                    throw new IllegalArgumentException("Invalid object reference: " + string);
                }
            }
            if (string.startsWith("resource:")) {
                URL uRL;
                String string4 = string.substring(9);
                Debug.output(2, "Trying to resolve URL/IOR from resource: " + string4);
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if ((uRL = classLoader.getResource(string4)) == null) {
                    throw new IllegalArgumentException("Failed to get resource: " + string4);
                }
                String string5 = ObjectUtil.readURL(uRL.toString());
                if (string5 == null) {
                    throw new IllegalArgumentException("Failed to read resource: " + string4);
                }
                this.parse(string5);
            } else if (string.startsWith("jndi:")) {
                String string6 = string.substring(5);
                Debug.output(2, "Trying to resolve JNDI/IOR from name: " + string6);
                java.lang.Object object = null;
                try {
                    Class[] classArray = new Class[1];
                    java.lang.Object[] objectArray = new java.lang.Object[1];
                    Class<?> clazz = Class.forName("javax.naming.InitialContext");
                    java.lang.Object obj = clazz.newInstance();
                    classArray[0] = class$java$lang$String == null ? (class$java$lang$String = ParsedIOR.class$("java.lang.String")) : class$java$lang$String;
                    objectArray[0] = string6;
                    Method method = clazz.getMethod("lookup", classArray);
                    object = method.invoke(obj, objectArray);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + exception);
                }
                if (object == null) {
                    throw new IllegalArgumentException("Null JNDI/IOR: " + string);
                }
                this.parse(object.toString());
            } else {
                Debug.output(2, "Trying to resolve URL/IOR from: " + string);
                String string7 = ObjectUtil.readURL(string);
                if (string7 == null) {
                    throw new IllegalArgumentException("Invalid or unreadable URL/IOR: " + string);
                }
                this.parse(string7);
            }
        }
        this.ior_str = this.getIORString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

