/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptor;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;

public class BiDirConnectionClientInterceptor
extends DefaultClientInterceptor {
    private String name = "BiDirConnectionClientInterceptor";
    private Codec codec = null;
    private ORB orb = null;
    private ServiceContext bidir_ctx = null;

    public BiDirConnectionClientInterceptor(ORB oRB, Codec codec) {
        this.orb = oRB;
        this.codec = codec;
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.orb.useBiDirGIOP() && ((ClientRequestInfoImpl)clientRequestInfo).connection.isClientInitiated()) {
            if (this.bidir_ctx == null) {
                IDLEntity iDLEntity;
                BasicAdapter basicAdapter = this.orb.getBasicAdapter();
                ListenPoint listenPoint = new ListenPoint(basicAdapter.getAddress(), (short)basicAdapter.getPort());
                ListenPoint[] listenPointArray = null;
                if (basicAdapter.hasSSLListener()) {
                    iDLEntity = new ListenPoint(basicAdapter.getAddress(), (short)basicAdapter.getSSLPort());
                    listenPointArray = new ListenPoint[]{listenPoint, iDLEntity};
                } else {
                    listenPointArray = new ListenPoint[]{listenPoint};
                }
                iDLEntity = new BiDirIIOPServiceContext(listenPointArray);
                Any any = this.orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, (BiDirIIOPServiceContext)iDLEntity);
                CDROutputStream cDROutputStream = new CDROutputStream();
                cDROutputStream.beginEncapsulatedArray();
                BiDirIIOPServiceContextHelper.write(cDROutputStream, (BiDirIIOPServiceContext)iDLEntity);
                this.bidir_ctx = new ServiceContext(5, cDROutputStream.getBufferCopy());
            }
            clientRequestInfo.add_request_service_context(this.bidir_ctx, true);
        }
    }
}

