/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.GIOP.ReplyStatusType_1_2;

public class NoBiDirClientRequestListener
implements RequestListener {
    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a request on a non-bidir connection");
        this.replyException(byArray, gIOPConnection);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a locate request on a non-bidir connection");
        this.replyException(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a cancel request on a non-bidir connection");
        this.replyException(byArray, gIOPConnection);
    }

    public void fragmentReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    private void replyException(byte[] byArray, GIOPConnection gIOPConnection) {
        int n = Messages.getGIOPMinor(byArray);
        ReplyOutputStream replyOutputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n, false);
        SystemExceptionHelper.write(replyOutputStream, new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
        try {
            gIOPConnection.sendMessage(replyOutputStream);
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
    }
}

